/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.build.lib.actions.AutoValue_FilesetOutputSymlink;
import com.google.devtools.build.lib.actions.HasDigest;
import com.google.devtools.build.lib.vfs.PathFragment;

@AutoValue
public abstract class FilesetOutputSymlink {
    public abstract PathFragment getName();

    public abstract PathFragment getTargetPath();

    public abstract HasDigest getMetadata();

    public abstract boolean isRelativeToExecRoot();

    public final PathFragment reconstituteTargetPath(PathFragment execRoot) {
        return this.isRelativeToExecRoot() ? execRoot.getRelative(this.getTargetPath()) : this.getTargetPath();
    }

    public final String toString() {
        if (this.getMetadata() == HasDigest.EMPTY) {
            return String.format("FilesetOutputSymlink(%s -> %s)", this.getName().getPathString(), this.getTargetPath().getPathString());
        }
        return String.format("FilesetOutputSymlink(%s -> %s | metadataHash=%s)", this.getName().getPathString(), this.getTargetPath().getPathString(), this.getMetadata());
    }

    @VisibleForTesting
    public static FilesetOutputSymlink createForTesting(PathFragment name, PathFragment target, PathFragment execRoot) {
        return FilesetOutputSymlink.create(name, target, HasDigest.EMPTY, execRoot);
    }

    @VisibleForTesting
    public static FilesetOutputSymlink createAlreadyRelativizedForTesting(PathFragment name, PathFragment target, boolean isRelativeToExecRoot) {
        return FilesetOutputSymlink.createAlreadyRelativized(name, target, HasDigest.EMPTY, isRelativeToExecRoot);
    }

    public static FilesetOutputSymlink create(PathFragment name, PathFragment target, HasDigest metadata, PathFragment execRoot) {
        boolean isRelativeToExecRoot = false;
        if (target.startsWith(execRoot)) {
            target = target.relativeTo(execRoot);
            isRelativeToExecRoot = true;
        }
        return FilesetOutputSymlink.createAlreadyRelativized(name, target, metadata, isRelativeToExecRoot);
    }

    public static FilesetOutputSymlink createAlreadyRelativized(PathFragment name, PathFragment target, HasDigest metadata, boolean isRelativeToExecRoot) {
        return new AutoValue_FilesetOutputSymlink(name, target, metadata, isRelativeToExecRoot);
    }
}

