/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.actions.AutoValue_ExecutionRequirements_ParseableRequirement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ExecutionRequirements {
    public static final String TIMEOUT = "timeout";
    public static final String REQUIRES_DARWIN = "requires-darwin";
    public static final String DISABLE_LOCAL_PREFETCH = "disable-local-prefetch";
    public static final ParseableRequirement CPU = ParseableRequirement.create("cpu:<int>", Pattern.compile("cpu:(.+)"), s2 -> {
        int value;
        Preconditions.checkNotNull(s2);
        try {
            value = Integer.parseInt(s2);
        }
        catch (NumberFormatException e) {
            return "can't be parsed as an integer";
        }
        if (!Integer.toString(value).equals(s2)) {
            return "must be in canonical format (e.g. '4' instead of '+04')";
        }
        if (value < 1) {
            return "can't be zero or negative";
        }
        return null;
    });
    public static final ParseableRequirement RESOURCES = ParseableRequirement.create("resources:<str>:<float>", Pattern.compile("resources:(.+:.+)"), s2 -> {
        float value;
        Preconditions.checkNotNull(s2);
        int splitIndex = s2.indexOf(":");
        String resourceCount = s2.substring(splitIndex + 1);
        try {
            value = Float.parseFloat(resourceCount);
        }
        catch (NumberFormatException e) {
            return "can't be parsed as a float";
        }
        if (value < 0.0f) {
            return "can't be negative";
        }
        return null;
    });
    public static final String SUPPORTS_WORKERS = "supports-workers";
    public static final String SUPPORTS_MULTIPLEX_WORKERS = "supports-multiplex-workers";
    public static final String REQUIRES_WORKER_PROTOCOL = "requires-worker-protocol";
    public static final String SUPPORTS_WORKER_CANCELLATION = "supports-worker-cancellation";
    public static final String SUPPORTS_MULTIPLEX_SANDBOXING = "supports-multiplex-sandboxing";
    public static final String WORKER_KEY_MNEMONIC = "worker-key-mnemonic";
    public static final ImmutableMap<String, String> WORKER_MODE_ENABLED = ImmutableMap.of("supports-workers", "1");
    public static final ImmutableMap<String, String> WORKER_MULTIPLEX_MODE_ENABLED = ImmutableMap.of("supports-multiplex-workers", "1");
    public static final String LOCAL = "local";
    public static final String NO_CACHE = "no-cache";
    public static final String NO_REMOTE_CACHE = "no-remote-cache";
    public static final String NO_REMOTE_CACHE_UPLOAD = "no-remote-cache-upload";
    public static final String NO_REMOTE_EXEC = "no-remote-exec";
    public static final String NO_TESTLOASD = "no-testloasd";
    public static final String NO_REMOTE = "no-remote";
    public static final String NO_LOCAL = "no-local";
    public static final String LEGACY_NOSANDBOX = "nosandbox";
    public static final String NO_SANDBOX = "no-sandbox";
    public static final String REQUIREMENTS_SET = "supports-xcode-requirements-set";
    public static final String REQUIRES_NETWORK = "requires-network";
    public static final String BLOCK_NETWORK = "block-network";
    public static final String REQUIRES_FAKEROOT = "requires-fakeroot";
    public static final String DO_NOT_REPORT = "internal-do-not-report";
    public static final String REMOTE_EXECUTION_INLINE_OUTPUTS = "internal-inline-outputs";
    public static final String GRACEFUL_TERMINATION = "supports-graceful-termination";
    public static final String REQUIRES_XCODE = "requires-xcode";
    public static final String REQUIRES_XCODE_LABEL = "requires-xcode-label";
    public static final String DIFFERENTIATE_WORKSPACE_CACHE = "internal-differentiate-workspace-cache";

    public static enum WorkerProtocolFormat {
        JSON,
        PROTO;

    }

    @AutoValue
    public static abstract class ParseableRequirement {
        static ParseableRequirement create(String userFriendlyName, Pattern detectionPattern, Function<String, String> validator) {
            return new AutoValue_ExecutionRequirements_ParseableRequirement(userFriendlyName, detectionPattern, validator);
        }

        public abstract String userFriendlyName();

        public abstract Pattern detectionPattern();

        public abstract Function<String, String> validator();

        @Nullable
        public String parseIfMatches(String tag) throws ValidationException {
            Matcher matcher = this.detectionPattern().matcher(tag);
            if (!matcher.matches()) {
                return null;
            }
            String tagValue = matcher.group(1);
            String errorMsg = this.validator().apply(tagValue);
            if (errorMsg != null) {
                throw new ValidationException(tagValue, errorMsg);
            }
            return tagValue;
        }

        public static class ValidationException
        extends Exception {
            private final String tagValue;

            public ValidationException(String tagValue, String errorMsg) {
                super(errorMsg);
                this.tagValue = tagValue;
            }

            public String getTagValue() {
                return this.tagValue;
            }
        }
    }
}

