/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.devtools.build.lib.cmdline.LabelConstants;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.starlarkbuildapi.FileRootApi;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.lib.vfs.Root;
import java.util.Objects;
import net.starlark.java.eval.Printer;

@AutoCodec
public final class ArtifactRoot
implements Comparable<ArtifactRoot>,
FileRootApi {
    private static final Interner<ArtifactRoot> INTERNER = Interners.newWeakInterner();
    private final Root root;
    private final PathFragment execPath;
    private final RootType rootType;

    public static ArtifactRoot asSourceRoot(Root root) {
        return INTERNER.intern(new ArtifactRoot(root, PathFragment.EMPTY_FRAGMENT, RootType.MainSource));
    }

    public static ArtifactRoot asExternalSourceRoot(Root root) {
        Preconditions.checkArgument(root.asPath().asFragment().getParentDirectory().endsWith(LabelConstants.EXTERNAL_REPOSITORY_LOCATION));
        return INTERNER.intern(new ArtifactRoot(root, PathFragment.EMPTY_FRAGMENT, RootType.ExternalSource));
    }

    public static ArtifactRoot asDerivedRoot(Path execRoot, RootType rootType, String ... prefixes) {
        PathFragment execPath = PathFragment.EMPTY_FRAGMENT;
        for (String prefix : prefixes) {
            if (prefix.isEmpty()) continue;
            execPath = execPath.getChild(prefix);
        }
        return ArtifactRoot.asDerivedRoot(execRoot, rootType, execPath);
    }

    public static ArtifactRoot asDerivedRoot(Path execRoot, RootType rootType, PathFragment execPath) {
        Preconditions.checkArgument(!execPath.isEmpty(), "empty execPath");
        Preconditions.checkArgument(!execPath.isAbsolute(), "execPath must be relative: %s", (Object)execPath);
        Preconditions.checkArgument(!execPath.containsUplevelReferences(), "execPath: %s contains parent directory reference (..)", (Object)execPath);
        Preconditions.checkArgument(ArtifactRoot.isOutputRootType(rootType) || ArtifactRoot.isMiddlemanRootType(rootType), "%s is not a derived root type", (Object)rootType);
        Path root = execRoot.getRelative(execPath);
        return INTERNER.intern(new ArtifactRoot(Root.fromPath(root), execPath, rootType));
    }

    @AutoCodec.VisibleForSerialization
    @AutoCodec.Instantiator
    static ArtifactRoot createForSerialization(Root rootForSerialization, PathFragment execPath, RootType rootType) {
        if (!ArtifactRoot.isOutputRootType(rootType)) {
            return INTERNER.intern(new ArtifactRoot(rootForSerialization, execPath, rootType));
        }
        return ArtifactRoot.asDerivedRoot(rootForSerialization.asPath(), rootType, execPath);
    }

    private ArtifactRoot(Root root, PathFragment execPath, RootType rootType) {
        this.root = Preconditions.checkNotNull(root);
        this.execPath = execPath;
        this.rootType = rootType;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public Root getRoot() {
        return this.root;
    }

    public PathFragment getExecPath() {
        return this.execPath;
    }

    @Override
    public String getExecPathString() {
        return this.execPath.getPathString();
    }

    public boolean isSourceRoot() {
        return this.rootType == RootType.MainSource || this.rootType == RootType.ExternalSource;
    }

    private static boolean isOutputRootType(RootType rootType) {
        return rootType == RootType.SiblingMainOutput || rootType == RootType.SiblingExternalOutput || rootType == RootType.Output;
    }

    private static boolean isMiddlemanRootType(RootType rootType) {
        return rootType == RootType.SiblingMainMiddleman || rootType == RootType.SiblingExternalMiddleman || rootType == RootType.Middleman;
    }

    boolean isMiddlemanRoot() {
        return ArtifactRoot.isMiddlemanRootType(this.rootType);
    }

    public boolean isExternal() {
        return this.rootType == RootType.ExternalSource || this.rootType == RootType.SiblingExternalOutput || this.rootType == RootType.SiblingExternalMiddleman;
    }

    public boolean isLegacy() {
        return this.rootType == RootType.Output || this.rootType == RootType.Middleman;
    }

    @Override
    public int compareTo(ArtifactRoot o) {
        return this.root.compareTo(o.root);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.root, this.execPath, this.rootType});
    }

    Root getRootForSerialization() {
        if (!ArtifactRoot.isOutputRootType(this.rootType)) {
            return this.root;
        }
        PathFragment rootFragment = this.root.asPath().asFragment();
        return Root.fromPath(this.root.asPath().getFileSystem().getPath(rootFragment.subFragment(0, rootFragment.segmentCount() - this.execPath.segmentCount())));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactRoot)) {
            return false;
        }
        ArtifactRoot r = (ArtifactRoot)o;
        return this.root.equals(r.root) && this.execPath.equals(r.execPath) && this.rootType == r.rootType;
    }

    public String toString() {
        return this.root + (this.isSourceRoot() ? "[source]" : "[derived]");
    }

    @Override
    public void repr(Printer printer) {
        printer.append(this.isSourceRoot() ? "<source root>" : "<derived root>");
    }

    public static enum RootType {
        MainSource,
        ExternalSource,
        Output,
        Middleman,
        SiblingMainOutput,
        SiblingMainMiddleman,
        SiblingExternalOutput,
        SiblingExternalMiddleman;

    }
}

