/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.skyframe.DetailedException;
import com.google.devtools.build.lib.util.DetailedExitCode;
import com.google.devtools.build.lib.vfs.PathFragment;

public class ArtifactPrefixConflictException
extends Exception
implements DetailedException {
    private final Label firstOwner;

    public ArtifactPrefixConflictException(PathFragment firstPath, PathFragment secondPath, Label firstOwner, Label secondOwner) {
        super(String.format("One of the output paths '%s' (belonging to %s) and '%s' (belonging to %s) is a prefix of the other. These actions cannot be simultaneously present; please rename one of the output files or build just one of them", firstPath, firstOwner, secondPath, secondOwner));
        this.firstOwner = firstOwner;
    }

    public Label getFirstOwner() {
        return this.firstOwner;
    }

    @Override
    public DetailedExitCode getDetailedExitCode() {
        return DetailedExitCode.of(FailureDetails.FailureDetail.newBuilder().setMessage(this.getMessage()).setAnalysis(FailureDetails.Analysis.newBuilder().setCode(FailureDetails.Analysis.Code.ARTIFACT_PREFIX_CONFLICT)).build());
    }
}

