/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.actions.ActionInput;
import com.google.devtools.build.lib.actions.Artifact;
import com.google.devtools.build.lib.vfs.FileSystem;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.Root;
import javax.annotation.Nullable;

public interface ArtifactPathResolver {
    public static final ArtifactPathResolver IDENTITY = new IdentityResolver(null);

    public Path toPath(ActionInput var1);

    public Path convertPath(Path var1);

    public Root transformRoot(Root var1);

    public static ArtifactPathResolver forExecRoot(Path execRoot) {
        return new IdentityResolver(execRoot);
    }

    public static ArtifactPathResolver withTransformedFileSystem(Path execRoot) {
        return new TransformResolver(execRoot);
    }

    public static ArtifactPathResolver createPathResolver(@Nullable FileSystem fileSystem, Path execRoot) {
        if (fileSystem == null) {
            return ArtifactPathResolver.forExecRoot(execRoot);
        }
        return ArtifactPathResolver.withTransformedFileSystem(fileSystem.getPath(execRoot.asFragment()));
    }

    public static class TransformResolver
    implements ArtifactPathResolver {
        private final FileSystem fileSystem;
        private final Path execRoot;

        private TransformResolver(Path execRoot) {
            this.execRoot = execRoot;
            this.fileSystem = Preconditions.checkNotNull(execRoot.getFileSystem());
        }

        @Override
        public Path toPath(ActionInput input) {
            if (input instanceof Artifact) {
                return this.fileSystem.getPath(((Artifact)input).getPath().asFragment());
            }
            return this.execRoot.getRelative(input.getExecPath());
        }

        @Override
        public Root transformRoot(Root root) {
            return Root.toFileSystem(Preconditions.checkNotNull(root), this.fileSystem);
        }

        @Override
        public Path convertPath(Path path) {
            return this.fileSystem.getPath(path.asFragment());
        }
    }

    public static class IdentityResolver
    implements ArtifactPathResolver {
        private final Path execRoot;

        private IdentityResolver(Path execRoot) {
            this.execRoot = execRoot;
        }

        @Override
        public Path toPath(ActionInput actionInput) {
            if (actionInput instanceof Artifact) {
                return ((Artifact)actionInput).getPath();
            }
            return this.execRoot.getRelative(actionInput.getExecPath());
        }

        @Override
        public Root transformRoot(Root root) {
            return Preconditions.checkNotNull(root);
        }

        @Override
        public Path convertPath(Path path) {
            return path;
        }
    }
}

