/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.actions.ActionLookupKeyOrProxy;
import com.google.devtools.build.lib.actions.Artifact;
import com.google.devtools.build.lib.actions.ArtifactOwner;
import com.google.devtools.build.lib.actions.ArtifactResolver;
import com.google.devtools.build.lib.actions.ArtifactRoot;
import com.google.devtools.build.lib.actions.PackageRootResolver;
import com.google.devtools.build.lib.actions.PackageRoots;
import com.google.devtools.build.lib.cmdline.LabelConstants;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.util.Pair;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.lib.vfs.Root;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class ArtifactFactory
implements ArtifactResolver {
    private final Path execRootParent;
    private final Path externalSourceBase;
    private final PathFragment derivedPathPrefix;
    private boolean siblingRepositoryLayout = false;
    private final SourceArtifactCache sourceArtifactCache = new SourceArtifactCache();
    private PackageRoots.PackageRootLookup packageRoots;

    public ArtifactFactory(Path execRootParent, String derivedPathPrefix) {
        this.execRootParent = execRootParent;
        this.externalSourceBase = execRootParent.getParentDirectory().getRelative(LabelConstants.EXTERNAL_REPOSITORY_LOCATION);
        this.derivedPathPrefix = PathFragment.create(derivedPathPrefix);
    }

    public synchronized void clear() {
        this.packageRoots = null;
        this.sourceArtifactCache.clear();
    }

    public void setSiblingRepositoryLayout(boolean siblingRepositoryLayout) {
        this.siblingRepositoryLayout = siblingRepositoryLayout;
    }

    public synchronized void setPackageRoots(PackageRoots.PackageRootLookup packageRoots) {
        this.packageRoots = packageRoots;
    }

    public synchronized void noteAnalysisStarting() {
        this.sourceArtifactCache.newBuild();
    }

    @Override
    public Artifact.SourceArtifact getSourceArtifact(PathFragment execPath, Root root, ArtifactOwner owner) {
        Preconditions.checkArgument(execPath.isAbsolute() == root.isAbsolute(), "%s %s %s", (Object)execPath, (Object)root, (Object)owner);
        Preconditions.checkNotNull(owner, "%s %s", (Object)execPath, (Object)root);
        ArtifactRoot artifactRoot = root.asPath() != null && root.asPath().startsWith(this.externalSourceBase) ? ArtifactRoot.asExternalSourceRoot(root) : ArtifactRoot.asSourceRoot(root);
        return (Artifact.SourceArtifact)this.getArtifact(artifactRoot, execPath, owner, null, false);
    }

    @Override
    public Artifact.SourceArtifact getSourceArtifact(PathFragment execPath, Root root) {
        return this.getSourceArtifact(execPath, root, ArtifactOwner.NULL_OWNER);
    }

    private void validatePath(PathFragment rootRelativePath, ArtifactRoot root) {
        Preconditions.checkArgument(!root.isSourceRoot());
        Preconditions.checkArgument(rootRelativePath.isAbsolute() == root.getRoot().isAbsolute(), rootRelativePath);
        Preconditions.checkArgument(!rootRelativePath.containsUplevelReferences(), rootRelativePath);
        Preconditions.checkArgument(root.getRoot().asPath().startsWith(this.execRootParent), "%s must start with %s, root = %s, root fs = %s, execRootParent fs = %s", root.getRoot(), this.execRootParent, root, root.getRoot().asPath().getFileSystem(), this.execRootParent.getFileSystem());
        Preconditions.checkArgument(!root.getRoot().asPath().equals(this.execRootParent), "%s %s %s", (Object)root.getRoot(), (Object)this.execRootParent, (Object)root);
    }

    public Artifact.DerivedArtifact getDerivedArtifact(PathFragment rootRelativePath, ArtifactRoot root, ArtifactOwner owner) {
        return this.getDerivedArtifact(rootRelativePath, root, owner, false);
    }

    public Artifact.DerivedArtifact getDerivedArtifact(PathFragment rootRelativePath, ArtifactRoot root, ArtifactOwner owner, boolean contentBasedPath) {
        this.validatePath(rootRelativePath, root);
        return (Artifact.DerivedArtifact)this.getArtifact(root, root.getExecPath().getRelative(rootRelativePath), owner, null, contentBasedPath);
    }

    public Artifact.DerivedArtifact getFilesetArtifact(PathFragment rootRelativePath, ArtifactRoot root, ArtifactOwner owner) {
        this.validatePath(rootRelativePath, root);
        return (Artifact.DerivedArtifact)this.getArtifact(root, root.getExecPath().getRelative(rootRelativePath), owner, Artifact.SpecialArtifactType.FILESET, false);
    }

    public Artifact.SpecialArtifact getTreeArtifact(PathFragment rootRelativePath, ArtifactRoot root, ArtifactOwner owner) {
        this.validatePath(rootRelativePath, root);
        return (Artifact.SpecialArtifact)this.getArtifact(root, root.getExecPath().getRelative(rootRelativePath), owner, Artifact.SpecialArtifactType.TREE, false);
    }

    public Artifact.SpecialArtifact getSymlinkArtifact(PathFragment rootRelativePath, ArtifactRoot root, ArtifactOwner owner) {
        this.validatePath(rootRelativePath, root);
        return (Artifact.SpecialArtifact)this.getArtifact(root, root.getExecPath().getRelative(rootRelativePath), owner, Artifact.SpecialArtifactType.UNRESOLVED_SYMLINK, false);
    }

    public Artifact.DerivedArtifact getConstantMetadataArtifact(PathFragment rootRelativePath, ArtifactRoot root, ArtifactOwner owner) {
        this.validatePath(rootRelativePath, root);
        return (Artifact.DerivedArtifact)this.getArtifact(root, root.getExecPath().getRelative(rootRelativePath), owner, Artifact.SpecialArtifactType.CONSTANT_METADATA, false);
    }

    private Artifact getArtifact(ArtifactRoot root, PathFragment execPath, ArtifactOwner owner, @Nullable Artifact.SpecialArtifactType type, boolean contentBasedPath) {
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(execPath);
        if (!root.isSourceRoot()) {
            return ArtifactFactory.createArtifact(root, execPath, owner, type, contentBasedPath);
        }
        Artifact.SourceArtifact firstArtifact = this.sourceArtifactCache.getArtifact(execPath);
        if (firstArtifact != null && !firstArtifact.differentOwnerOrRoot(owner, root)) {
            return firstArtifact;
        }
        SourceArtifactCache.Entry newEntry = this.sourceArtifactCache.pathToSourceArtifact.compute(execPath, (k, entry) -> {
            if (entry == null || entry.getArtifact() == null || entry.getArtifact().differentOwnerOrRoot(owner, root)) {
                SourceArtifactCache sourceArtifactCache = this.sourceArtifactCache;
                Objects.requireNonNull(sourceArtifactCache);
                return sourceArtifactCache.new SourceArtifactCache.Entry((Artifact.SourceArtifact)ArtifactFactory.createArtifact(root, execPath, owner, type, false));
            }
            return entry;
        });
        return newEntry.getArtifact();
    }

    private static Artifact createArtifact(ArtifactRoot root, PathFragment execPath, ArtifactOwner owner, @Nullable Artifact.SpecialArtifactType type, boolean contentBasedPath) {
        Preconditions.checkNotNull(owner);
        if (type == null) {
            return root.isSourceRoot() ? new Artifact.SourceArtifact(root, execPath, owner) : Artifact.DerivedArtifact.create(root, execPath, (ActionLookupKeyOrProxy)owner, contentBasedPath);
        }
        return Artifact.SpecialArtifact.create(root, execPath, (ActionLookupKeyOrProxy)owner, type);
    }

    @Nullable
    public Artifact.SourceArtifact resolveSourceArtifactWithAncestor(PathFragment relativePath, PathFragment baseExecPath, ArtifactRoot baseRoot, RepositoryName repositoryName) {
        PathFragment execPath;
        Preconditions.checkState(baseExecPath == null == (baseRoot == null), "%s %s %s", (Object)relativePath, (Object)baseExecPath, (Object)baseRoot);
        Preconditions.checkState(!relativePath.isEmpty(), "%s %s %s", (Object)relativePath, (Object)baseExecPath, (Object)baseRoot);
        PathFragment pathFragment = execPath = baseExecPath != null ? baseExecPath.getRelative(relativePath) : relativePath;
        if (this.siblingRepositoryLayout ? execPath.subFragment(1).containsUplevelReferences() : execPath.containsUplevelReferences()) {
            return null;
        }
        if (this.isDerivedArtifact(execPath)) {
            return null;
        }
        Artifact.SourceArtifact artifact = this.sourceArtifactCache.getArtifactIfValid(execPath);
        if (artifact != null) {
            return artifact;
        }
        Root sourceRoot = this.findSourceRoot(execPath, baseExecPath, baseRoot == null ? null : baseRoot.getRoot(), repositoryName);
        return this.createArtifactIfNotValid(sourceRoot, execPath);
    }

    @Nullable
    private Root findSourceRoot(PathFragment execPath, @Nullable PathFragment baseExecPath, @Nullable Root baseRoot, RepositoryName repositoryName) {
        PathFragment dir = execPath.getParentDirectory();
        if (dir == null) {
            return null;
        }
        Pair<RepositoryName, PathFragment> repo = RepositoryName.fromPathFragment(dir, this.siblingRepositoryLayout);
        if (repo != null) {
            repositoryName = repo.getFirst();
            dir = repo.getSecond();
        }
        while (dir != null && !dir.equals(baseExecPath)) {
            Root sourceRoot = this.packageRoots.getRootForPackage(PackageIdentifier.create(repositoryName, dir));
            if (sourceRoot != null) {
                return sourceRoot;
            }
            dir = dir.getParentDirectory();
        }
        return dir != null && dir.equals(baseExecPath) ? baseRoot : null;
    }

    @Override
    public Artifact.SourceArtifact resolveSourceArtifact(PathFragment execPath, RepositoryName repositoryName) {
        return this.resolveSourceArtifactWithAncestor(execPath, null, null, repositoryName);
    }

    @Override
    @Nullable
    public Map<PathFragment, Artifact.SourceArtifact> resolveSourceArtifacts(Iterable<PathFragment> execPaths, PackageRootResolver resolver) throws PackageRootResolver.PackageRootException, InterruptedException {
        HashMap<PathFragment, Artifact.SourceArtifact> result = new HashMap<PathFragment, Artifact.SourceArtifact>();
        ArrayList<PathFragment> unresolvedPaths = new ArrayList<PathFragment>();
        for (PathFragment execPath : execPaths) {
            if (execPath.containsUplevelReferences()) {
                result.put(execPath, null);
                continue;
            }
            if (this.isDerivedArtifact(execPath)) {
                result.put(execPath, null);
                continue;
            }
            Artifact.SourceArtifact a = this.sourceArtifactCache.getArtifactIfValid(execPath);
            if (a != null) {
                result.put(execPath, a);
                continue;
            }
            unresolvedPaths.add(execPath);
        }
        Map<PathFragment, Root> sourceRoots = resolver.findPackageRootsForFiles(unresolvedPaths);
        if (sourceRoots == null) {
            return null;
        }
        for (PathFragment path : unresolvedPaths) {
            result.put(path, this.createArtifactIfNotValid(sourceRoots.get(path), path));
        }
        return result;
    }

    @Override
    public Path getPathFromSourceExecPath(Path execRoot, PathFragment execPath) {
        Preconditions.checkState(!execPath.startsWith(this.derivedPathPrefix), "%s is derived: %s", (Object)execPath, (Object)this.derivedPathPrefix);
        Root sourceRoot = this.packageRoots.getRootForPackage(PackageIdentifier.create(RepositoryName.MAIN, execPath));
        if (sourceRoot != null) {
            return sourceRoot.getRelative(execPath);
        }
        return execRoot.getRelative(execPath);
    }

    @Nullable
    private Artifact.SourceArtifact createArtifactIfNotValid(Root sourceRoot, PathFragment execPath) {
        if (sourceRoot == null) {
            return null;
        }
        Artifact.SourceArtifact artifact = this.sourceArtifactCache.getArtifact(execPath);
        if (artifact != null && sourceRoot.equals(((ArtifactRoot)artifact.getRoot()).getRoot())) {
            this.sourceArtifactCache.pathToSourceArtifact.compute(execPath, (k, cacheEntry) -> {
                Artifact.SourceArtifact validArtifact = cacheEntry.getArtifact();
                if (!cacheEntry.isArtifactValid()) {
                    SourceArtifactCache sourceArtifactCache = this.sourceArtifactCache;
                    Objects.requireNonNull(sourceArtifactCache);
                    return sourceArtifactCache.new SourceArtifactCache.Entry(validArtifact);
                }
                Preconditions.checkState(artifact.equals(validArtifact), "Mismatched artifacts: %s %s", (Object)artifact, (Object)validArtifact);
                return cacheEntry;
            });
            return artifact;
        }
        return this.getSourceArtifact(execPath, sourceRoot, ArtifactOwner.NULL_OWNER);
    }

    @VisibleForTesting
    boolean isDerivedArtifact(PathFragment execPath) {
        return execPath.startsWith(this.derivedPathPrefix);
    }

    private static class SourceArtifactCache {
        private static final int CONCURRENCY_LEVEL = Runtime.getRuntime().availableProcessors();
        private final ConcurrentMap<PathFragment, Entry> pathToSourceArtifact = new ConcurrentHashMap<PathFragment, Entry>(16, 0.75f, CONCURRENCY_LEVEL);
        private int buildId = -1;

        private SourceArtifactCache() {
        }

        @Nullable
        Artifact.SourceArtifact getArtifact(PathFragment execPath) {
            Entry cacheEntry = (Entry)this.pathToSourceArtifact.get(execPath);
            return cacheEntry == null ? null : cacheEntry.getArtifact();
        }

        @Nullable
        Artifact.SourceArtifact getArtifactIfValid(PathFragment execPath) {
            Entry cacheEntry = (Entry)this.pathToSourceArtifact.get(execPath);
            return cacheEntry == null || !cacheEntry.isArtifactValid() ? null : cacheEntry.getArtifact();
        }

        void newBuild() {
            ++this.buildId;
        }

        void clear() {
            this.pathToSourceArtifact.clear();
            this.buildId = -1;
        }

        private class Entry {
            private final Artifact.SourceArtifact artifact;
            private final int idOfBuild;

            Entry(Artifact.SourceArtifact artifact) {
                this.artifact = artifact;
                this.idOfBuild = SourceArtifactCache.this.buildId;
            }

            Artifact.SourceArtifact getArtifact() {
                return this.artifact;
            }

            boolean isArtifactValid() {
                return this.idOfBuild == SourceArtifactCache.this.buildId;
            }
        }
    }
}

