/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.devtools.build.lib.actions.ActionInput;
import com.google.devtools.build.lib.actions.ActionLookupData;
import com.google.devtools.build.lib.actions.ActionLookupKey;
import com.google.devtools.build.lib.actions.ActionLookupKeyOrProxy;
import com.google.devtools.build.lib.actions.ArtifactOwner;
import com.google.devtools.build.lib.actions.ArtifactRoot;
import com.google.devtools.build.lib.actions.CommandLineItem;
import com.google.devtools.build.lib.actions.FilesetOutputSymlink;
import com.google.devtools.build.lib.actions.PathStrippable;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelConstants;
import com.google.devtools.build.lib.collect.nestedset.Depset;
import com.google.devtools.build.lib.collect.nestedset.NestedSet;
import com.google.devtools.build.lib.skyframe.SkyFunctions;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.starlarkbuildapi.FileApi;
import com.google.devtools.build.lib.starlarkbuildapi.FileRootApi;
import com.google.devtools.build.lib.util.FileType;
import com.google.devtools.build.lib.util.FileTypeSet;
import com.google.devtools.build.lib.util.HashCodes;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.lib.vfs.Root;
import com.google.devtools.build.skyframe.ExecutionPhaseSkyKey;
import com.google.devtools.build.skyframe.SkyFunctionName;
import com.google.devtools.build.skyframe.SkyKey;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;

public abstract class Artifact
implements FileType.HasFileType,
ActionInput,
FileApi,
Comparable<Artifact>,
CommandLineItem,
ExecutionPhaseSkyKey {
    public static final Depset.ElementType TYPE = Depset.ElementType.of(Artifact.class);
    @SerializationConstant
    public static final Comparator<Artifact> EXEC_PATH_COMPARATOR = (a, b) -> {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.execPath.compareTo(b.execPath);
    };
    public static final Comparator<Artifact> ROOT_RELATIVE_PATH_COMPARATOR = (a, b) -> {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int result = a.getRootRelativePath().compareTo(b.getRootRelativePath());
        if (result == 0) {
            return a.execPath.compareTo(b.execPath);
        }
        return result;
    };
    public static final SkyFunctionName ARTIFACT = SkyFunctionName.createHermetic("ARTIFACT");
    public static final Predicate<Artifact> MIDDLEMAN_FILTER = input -> !input.isMiddlemanArtifact();
    private final ArtifactRoot root;
    private final int hashCode;
    private final PathFragment execPath;
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final Object OMITTED_FOR_SERIALIZATION = new Object(){

        public String toString() {
            return "OMITTED_FOR_SERIALIZATION";
        }
    };
    public static final Function<Artifact, String> ROOT_RELATIVE_PATH_STRING = artifact -> artifact.getRootRelativePath().getPathString();
    public static final Function<Artifact, String> RUNFILES_PATH_STRING = artifact -> artifact.getRunfilesPath().getPathString();

    public static SkyKey key(Artifact artifact) {
        if (artifact.isTreeArtifact() || artifact.isMiddlemanArtifact() || !artifact.hasKnownGeneratingAction()) {
            return artifact;
        }
        return ((DerivedArtifact)artifact).getGeneratingActionKey();
    }

    public static Collection<SkyKey> keys(Collection<Artifact> artifacts) {
        return artifacts instanceof List ? Artifact.keys((List)artifacts) : Collections2.transform(artifacts, Artifact::key);
    }

    public static List<SkyKey> keys(List<Artifact> artifacts) {
        return Lists.transform(artifacts, Artifact::key);
    }

    @Override
    public int compareTo(Artifact o) {
        return EXEC_PATH_COMPARATOR.compare(this, o);
    }

    private Artifact(ArtifactRoot root, PathFragment execPath, int hashCodeWithOwner) {
        Preconditions.checkNotNull(root);
        this.hashCode = hashCodeWithOwner;
        this.root = root;
        this.execPath = execPath;
    }

    private static Object getGeneratingActionKeyForSerialization(DerivedArtifact artifact, SerializationContext context) {
        return context.getDependency(ArtifactSerializationContext.class).includeGeneratingActionKey(artifact) ? artifact.getGeneratingActionKey() : OMITTED_FOR_SERIALIZATION;
    }

    private static PathFragment getExecPathForDeserialization(ArtifactRoot root, PathFragment rootRelativePath, Object generatingActionKey) {
        Preconditions.checkArgument(!root.isSourceRoot(), "Root not derived: %s (rootRelativePath=%s, generatingActionKey=%s)", (Object)root, (Object)rootRelativePath, generatingActionKey);
        Preconditions.checkArgument(root.getRoot().isAbsolute() == rootRelativePath.isAbsolute(), "Illegal root relative path: %s (root=%s, generatingActionKey=%s)", (Object)rootRelativePath, (Object)root, generatingActionKey);
        return root.getExecPath().getRelative(rootRelativePath);
    }

    public final Path getPath() {
        return this.root.getRoot().getRelative(this.getRootRelativePath());
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    @Nullable
    public SpecialArtifact getParent() {
        return null;
    }

    @Override
    public final String getDirname() {
        PathFragment parent = this.execPath.getParentDirectory();
        return parent == null ? "/" : parent.getSafePathString();
    }

    @Override
    public final String getFilename() {
        return this.execPath.getBaseName();
    }

    @Override
    public final String getExtension() {
        return this.execPath.getFileExtension();
    }

    public boolean isFileType(FileType fileType) {
        return fileType.matches(this);
    }

    public boolean isFileType(FileTypeSet fileTypeSet) {
        return fileTypeSet.matches(this.filePathForFileTypeMatcher());
    }

    @Override
    public final String filePathForFileTypeMatcher() {
        return this.execPath.filePathForFileTypeMatcher();
    }

    @Override
    public final String expandToCommandLine() {
        return this.getExecPathString();
    }

    @Nullable
    public final Label getOwner() {
        return this.getOwnerLabel();
    }

    public abstract ArtifactOwner getArtifactOwner();

    @Override
    public final ArtifactRoot getRoot() {
        return this.root;
    }

    @Override
    public final PathFragment getExecPath() {
        return this.execPath;
    }

    public abstract PathFragment getRootRelativePath();

    @Deprecated
    public PathFragment getPathForLocationExpansion() {
        return this.getRootRelativePath();
    }

    public PathFragment getOutputDirRelativePath(boolean siblingRepositoryLayout) {
        return this.getRootRelativePath();
    }

    public PathFragment getRepositoryRelativePath() {
        PathFragment relativePath = this.getRootRelativePath();
        if (this.root.isLegacy() && relativePath.startsWith(LabelConstants.EXTERNAL_PATH_PREFIX)) {
            relativePath = relativePath.subFragment(2);
        }
        return relativePath;
    }

    @Override
    public final String getExecPathString() {
        return this.execPath.getPathString();
    }

    public final String getRootRelativePathString() {
        return this.getRootRelativePath().getPathString();
    }

    public final String getRepositoryRelativePathString() {
        return this.getRepositoryRelativePath().getPathString();
    }

    @Override
    public boolean isSymlink() {
        return false;
    }

    public PathFragment getParentRelativePath() {
        return PathFragment.EMPTY_FRAGMENT;
    }

    @Override
    public String getTreeRelativePathString() throws EvalException {
        throw Starlark.errorf("tree_relative_path not allowed for files that are not tree artifact files.", new Object[0]);
    }

    @Override
    public final boolean isSourceArtifact() {
        return this.root.isSourceRoot();
    }

    public boolean hasKnownGeneratingAction() {
        return !this.isSourceArtifact();
    }

    public final boolean isMiddlemanArtifact() {
        return this.root.isMiddlemanRoot();
    }

    public boolean isTreeArtifact() {
        return false;
    }

    public boolean isChildOfDeclaredDirectory() {
        return false;
    }

    public boolean isFileset() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.isTreeArtifact() || this.isFileset();
    }

    public boolean isConstantMetadata() {
        return false;
    }

    public final PathFragment getRunfilesPath() {
        PathFragment relativePath = this.getRootRelativePath();
        if (this.root.isLegacy()) {
            if (relativePath.startsWith(LabelConstants.EXTERNAL_PATH_PREFIX)) {
                relativePath = relativePath.relativeTo(LabelConstants.EXTERNAL_PATH_PREFIX);
                relativePath = LabelConstants.EXTERNAL_RUNFILES_PATH_PREFIX.getRelative(relativePath);
            }
        } else if (this.root.isExternal()) {
            String repoName = this.execPath.getSegment(1);
            relativePath = LabelConstants.EXTERNAL_RUNFILES_PATH_PREFIX.getRelative(repoName).getRelative(relativePath);
        }
        return relativePath;
    }

    @Override
    public final String getRunfilesPathString() {
        return this.getRunfilesPath().getPathString();
    }

    public final String prettyPrint() {
        return this.getRootRelativePath().toString();
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Artifact)) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Artifact that = (Artifact)other;
        return this.equalsWithoutOwner(that) && this.ownersEqual(that);
    }

    final int hashCodeWithoutOwner() {
        return HashCodes.hashObjects(this.execPath, this.root);
    }

    final boolean equalsWithoutOwner(Artifact other) {
        return this.execPath.equals(other.execPath) && this.root.equals(other.root);
    }

    abstract boolean ownersEqual(Artifact var1);

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return "File:" + this.toDetailString();
    }

    public final String toDetailString() {
        if (this.isSourceArtifact()) {
            return "[" + this.root + "]" + this.getRootRelativePathString();
        }
        return "[[<execution_root>]" + this.root.getExecPath() + "]" + this.getRootRelativePathString();
    }

    public String toDebugString() {
        if (this.getOwner() == null || this.getOwner().toPathFragment().equals(this.execPath)) {
            return this.toDetailString();
        }
        return this.toDetailString() + " (" + this.getArtifactOwner() + ")";
    }

    @Override
    public final SkyFunctionName functionName() {
        return ARTIFACT;
    }

    public static void addExecPaths(Iterable<Artifact> artifacts, Collection<String> output) {
        Artifact.addNonMiddlemanArtifacts(artifacts, output, ActionInput::getExecPathString);
    }

    public static <E> void addNonMiddlemanArtifacts(Iterable<Artifact> artifacts, Collection<? super E> output, Function<? super Artifact, E> outputFormatter) {
        for (Artifact artifact : artifacts) {
            if (!MIDDLEMAN_FILTER.apply(artifact)) continue;
            output.add(outputFormatter.apply(artifact));
        }
    }

    public static Iterable<String> toRootRelativePaths(NestedSet<Artifact> artifacts) {
        return Artifact.toRootRelativePaths(artifacts.toList());
    }

    public static Iterable<String> toRootRelativePaths(Iterable<Artifact> artifacts) {
        return Iterables.transform(Iterables.filter(artifacts, MIDDLEMAN_FILTER), artifact -> artifact.getRootRelativePath().getPathString());
    }

    public static Iterable<String> toExecPaths(Iterable<Artifact> artifacts) {
        return Iterables.transform(Iterables.filter(artifacts, MIDDLEMAN_FILTER), ActionInput::getExecPathString);
    }

    @VisibleForTesting
    public static List<String> asExecPaths(NestedSet<Artifact> artifacts) {
        return Artifact.asExecPaths(artifacts.toList());
    }

    public static List<String> asExecPaths(Iterable<Artifact> artifacts) {
        return ImmutableList.copyOf(Artifact.toExecPaths(artifacts));
    }

    public static String joinExecPaths(String delimiter, Iterable<Artifact> artifacts) {
        return Joiner.on(delimiter).join(Artifact.toExecPaths(artifacts));
    }

    public static String joinRootRelativePaths(String delimiter, Iterable<Artifact> artifacts) {
        return Joiner.on(delimiter).join(Artifact.toRootRelativePaths(artifacts));
    }

    static void addExpandedArtifact(Artifact artifact, Collection<? super Artifact> output, ArtifactExpander artifactExpander, boolean keepEmptyTreeArtifacts) {
        if (artifact.isMiddlemanArtifact() || artifact.isTreeArtifact()) {
            ArrayList expandedArtifacts = new ArrayList();
            artifactExpander.expand(artifact, expandedArtifacts);
            output.addAll(expandedArtifacts);
            if (keepEmptyTreeArtifacts && artifact.isTreeArtifact() && expandedArtifacts.isEmpty()) {
                output.add(artifact);
            }
        } else {
            output.add(artifact);
        }
    }

    public static List<Artifact> filterFiles(Iterable<Artifact> artifacts, FileType allowedType) {
        ArrayList<Artifact> filesToBuild = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!allowedType.apply(artifact.getFilename())) continue;
            filesToBuild.add(artifact);
        }
        return filesToBuild;
    }

    public static List<PathFragment> asPathFragments(Iterable<? extends Artifact> artifacts) {
        return Streams.stream(artifacts).map(Artifact::getExecPath).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<PathFragment> asSortedPathFragments(Iterable<Artifact> input) {
        return Streams.stream(input).map(Artifact::getExecPath).sorted().collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public void repr(Printer printer) {
        if (this.isSourceArtifact()) {
            printer.append("<source file " + this.getRootRelativePathString() + ">");
        } else {
            printer.append("<generated file " + this.getRootRelativePathString() + ">");
        }
    }

    public static final class OwnerlessArtifactWrapper {
        private final Artifact artifact;
        private final int hashCode;

        public OwnerlessArtifactWrapper(Artifact artifact) {
            this.artifact = artifact;
            this.hashCode = artifact.hashCodeWithoutOwner();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof OwnerlessArtifactWrapper && this.artifact.equalsWithoutOwner(((OwnerlessArtifactWrapper)obj).artifact);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("artifact", this.artifact.toDebugString()).toString();
        }
    }

    private static final class TreeFileArtifactCodec
    implements ObjectCodec<TreeFileArtifact> {
        private TreeFileArtifactCodec() {
        }

        @Override
        public Class<TreeFileArtifact> getEncodedClass() {
            return TreeFileArtifact.class;
        }

        @Override
        public void serialize(SerializationContext context, TreeFileArtifact obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            context.serialize(obj.parent, codedOut);
            context.serialize(obj.parentRelativePath, codedOut);
            context.serialize(Artifact.getGeneratingActionKeyForSerialization(obj, context), codedOut);
        }

        @Override
        public TreeFileArtifact deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            SpecialArtifact parent = (SpecialArtifact)context.deserialize(codedIn);
            PathFragment parentRelativePath = (PathFragment)context.deserialize(codedIn);
            Object generatingActionKey = context.deserialize(codedIn);
            return new TreeFileArtifact(parent, parentRelativePath, generatingActionKey);
        }
    }

    public static final class TreeFileArtifact
    extends DerivedArtifact {
        private final SpecialArtifact parent;
        private final PathFragment parentRelativePath;

        public static TreeFileArtifact createTreeOutput(SpecialArtifact parent, PathFragment parentRelativePath) {
            Preconditions.checkArgument(parent.hasGeneratingActionKey(), "%s has no generating action key (parent owner: %s, parent relative path: %s)", (Object)parent, (Object)parent.getArtifactOwner(), (Object)parentRelativePath);
            ActionLookupData generatingActionKey = parent.getGeneratingActionKey();
            Preconditions.checkArgument(!TreeFileArtifact.isActionTemplateExpansionKey(generatingActionKey.getActionLookupKey()), "%s owned by action template expansion %s (parent relative path: %s)", (Object)parent, (Object)generatingActionKey.getActionLookupKey(), (Object)parentRelativePath);
            return new TreeFileArtifact(parent, parentRelativePath, generatingActionKey);
        }

        public static TreeFileArtifact createTreeOutput(SpecialArtifact parent, String parentRelativePath) {
            return TreeFileArtifact.createTreeOutput(parent, PathFragment.create(parentRelativePath));
        }

        public static TreeFileArtifact createTemplateExpansionOutput(SpecialArtifact parent, PathFragment parentRelativePath, ActionLookupKey owner) {
            Preconditions.checkArgument(TreeFileArtifact.isActionTemplateExpansionKey(owner), "Template expansion outputs must be owned by an action template expansion key, but %s is owned by %s (parent relative path: %s)", (Object)parent, (Object)owner, (Object)parentRelativePath);
            return new TreeFileArtifact(parent, parentRelativePath, owner);
        }

        public static TreeFileArtifact createTemplateExpansionOutput(SpecialArtifact parent, String parentRelativePath, ActionLookupKey owner) {
            return TreeFileArtifact.createTemplateExpansionOutput(parent, PathFragment.create(parentRelativePath), owner);
        }

        private TreeFileArtifact(SpecialArtifact parent, PathFragment parentRelativePath, Object owner) {
            super((ArtifactRoot)parent.getRoot(), parent.getExecPath().getRelative(parentRelativePath), owner);
            Preconditions.checkArgument(parent.isTreeArtifact(), "The parent of TreeFileArtifact (parent-relative path: %s) is not a TreeArtifact: %s", (Object)parentRelativePath, (Object)parent);
            Preconditions.checkArgument(!parentRelativePath.containsUplevelReferences() && !parentRelativePath.isAbsolute(), "%s is not a proper normalized relative path", (Object)parentRelativePath);
            this.parent = parent;
            this.parentRelativePath = parentRelativePath;
        }

        @Override
        public SpecialArtifact getParent() {
            return this.parent;
        }

        @Override
        public PathFragment getParentRelativePath() {
            return this.parentRelativePath;
        }

        @Override
        public String getTreeRelativePathString() {
            return this.parentRelativePath.getPathString();
        }

        @Override
        public boolean isChildOfDeclaredDirectory() {
            return !TreeFileArtifact.isActionTemplateExpansionKey(this.getArtifactOwner());
        }

        private static boolean isActionTemplateExpansionKey(ActionLookupKeyOrProxy key) {
            return SkyFunctions.ACTION_TEMPLATE_EXPANSION.equals(key.toKey().functionName());
        }
    }

    private static final class ArchivedTreeArtifactCodec
    implements ObjectCodec<ArchivedTreeArtifact> {
        private ArchivedTreeArtifactCodec() {
        }

        @Override
        public Class<ArchivedTreeArtifact> getEncodedClass() {
            return ArchivedTreeArtifact.class;
        }

        @Override
        public void serialize(SerializationContext context, ArchivedTreeArtifact obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            PathFragment derivedTreeRoot = ((ArtifactRoot)obj.getRoot()).getExecPath().subFragment(1, 2);
            context.serialize(obj.getParent(), codedOut);
            context.serialize(derivedTreeRoot, codedOut);
            context.serialize(obj.getRootRelativePath(), codedOut);
        }

        @Override
        public ArchivedTreeArtifact deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            SpecialArtifact treeArtifact = (SpecialArtifact)context.deserialize(codedIn);
            PathFragment derivedTreeRoot = (PathFragment)context.deserialize(codedIn);
            PathFragment rootRelativePath = (PathFragment)context.deserialize(codedIn);
            Object generatingActionKey = treeArtifact.hasGeneratingActionKey() ? treeArtifact.getGeneratingActionKey() : OMITTED_FOR_SERIALIZATION;
            return ArchivedTreeArtifact.createInternal(treeArtifact, derivedTreeRoot, rootRelativePath, generatingActionKey);
        }
    }

    public static final class ArchivedTreeArtifact
    extends DerivedArtifact {
        private static final PathFragment DEFAULT_DERIVED_TREE_ROOT = PathFragment.create(":archived_tree_artifacts");
        private final SpecialArtifact treeArtifact;

        private ArchivedTreeArtifact(SpecialArtifact treeArtifact, ArtifactRoot root, PathFragment execPath, Object generatingActionKey) {
            super(root, execPath, generatingActionKey);
            Preconditions.checkArgument(treeArtifact.isTreeArtifact(), "Not a tree artifact: %s", (Object)treeArtifact);
            this.treeArtifact = treeArtifact;
        }

        @Override
        public SpecialArtifact getParent() {
            return this.treeArtifact;
        }

        public static ArchivedTreeArtifact createForTree(SpecialArtifact treeArtifact) {
            return ArchivedTreeArtifact.createInternal(treeArtifact, DEFAULT_DERIVED_TREE_ROOT, treeArtifact.getRootRelativePath().replaceName(treeArtifact.getFilename() + ".zip"), treeArtifact.getGeneratingActionKey());
        }

        public static ArchivedTreeArtifact createWithCustomDerivedTreeRoot(SpecialArtifact treeArtifact, PathFragment derivedTreeRoot, PathFragment rootRelativePath) {
            return ArchivedTreeArtifact.createInternal(treeArtifact, derivedTreeRoot, rootRelativePath, treeArtifact.getGeneratingActionKey());
        }

        private static ArchivedTreeArtifact createInternal(SpecialArtifact treeArtifact, PathFragment derivedTreeRoot, PathFragment rootRelativePath, Object generatingActionKey) {
            FileRootApi treeRoot = treeArtifact.getRoot();
            PathFragment archiveRoot = ArchivedTreeArtifact.embedDerivedTreeRoot(((ArtifactRoot)treeRoot).getExecPath(), derivedTreeRoot);
            return new ArchivedTreeArtifact(treeArtifact, ArtifactRoot.asDerivedRoot(ArchivedTreeArtifact.getExecRoot((ArtifactRoot)treeRoot), ArtifactRoot.RootType.Output, archiveRoot), archiveRoot.getRelative(rootRelativePath), generatingActionKey);
        }

        public static PathFragment getExecPathWithinArchivedArtifactsTree(PathFragment execPath) {
            return ArchivedTreeArtifact.embedDerivedTreeRoot(execPath, DEFAULT_DERIVED_TREE_ROOT);
        }

        private static PathFragment embedDerivedTreeRoot(PathFragment execPath, PathFragment derivedTreeRoot) {
            return execPath.subFragment(0, 1).getRelative(derivedTreeRoot).getRelative(execPath.subFragment(1));
        }

        private static Path getExecRoot(ArtifactRoot artifactRoot) {
            Path rootPath = artifactRoot.getRoot().asPath();
            PathFragment rootPathFragment = rootPath.asFragment();
            PathFragment execRootPath = rootPathFragment.subFragment(0, rootPathFragment.segmentCount() - artifactRoot.getExecPath().segmentCount());
            return rootPath.getFileSystem().getPath(execRootPath);
        }
    }

    private static final class SpecialArtifactCodec
    implements ObjectCodec<SpecialArtifact> {
        private SpecialArtifactCodec() {
        }

        @Override
        public Class<SpecialArtifact> getEncodedClass() {
            return SpecialArtifact.class;
        }

        @Override
        public void serialize(SerializationContext context, SpecialArtifact obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            context.serialize(obj.getRoot(), codedOut);
            context.serialize(obj.getRootRelativePath(), codedOut);
            context.serialize(Artifact.getGeneratingActionKeyForSerialization(obj, context), codedOut);
            context.serialize((Object)obj.type, codedOut);
        }

        @Override
        public SpecialArtifact deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            ArtifactRoot root = (ArtifactRoot)context.deserialize(codedIn);
            PathFragment rootRelativePath = (PathFragment)context.deserialize(codedIn);
            Object generatingActionKey = context.deserialize(codedIn);
            SpecialArtifactType type = (SpecialArtifactType)((Object)context.deserialize(codedIn));
            SpecialArtifact artifact = new SpecialArtifact(root, Artifact.getExecPathForDeserialization(root, rootRelativePath, generatingActionKey), generatingActionKey, type);
            return (SpecialArtifact)context.getDependency(ArtifactSerializationContext.class).intern(artifact);
        }
    }

    public static final class SpecialArtifact
    extends DerivedArtifact {
        private final SpecialArtifactType type;

        @VisibleForTesting
        public static SpecialArtifact create(ArtifactRoot root, PathFragment execPath, ActionLookupKeyOrProxy owner, SpecialArtifactType type) {
            return new SpecialArtifact(root, execPath, owner, type);
        }

        private SpecialArtifact(ArtifactRoot root, PathFragment execPath, Object owner, SpecialArtifactType type) {
            super(root, execPath, owner);
            this.type = type;
        }

        @Override
        public boolean isFileset() {
            return this.type == SpecialArtifactType.FILESET;
        }

        @Override
        public boolean isConstantMetadata() {
            return this.type == SpecialArtifactType.CONSTANT_METADATA;
        }

        @Override
        public boolean isTreeArtifact() {
            return this.type == SpecialArtifactType.TREE;
        }

        @Override
        public boolean isSymlink() {
            return this.type == SpecialArtifactType.UNRESOLVED_SYMLINK;
        }

        @Override
        public boolean hasParent() {
            return false;
        }

        @Override
        @Nullable
        public PathFragment getParentRelativePath() {
            return null;
        }

        @Override
        public boolean valueIsShareable() {
            return !this.isConstantMetadata();
        }
    }

    @VisibleForTesting
    public static enum SpecialArtifactType {
        FILESET,
        UNRESOLVED_SYMLINK,
        TREE,
        CONSTANT_METADATA;

    }

    private static final class SourceArtifactCodec
    implements ObjectCodec<SourceArtifact> {
        private SourceArtifactCodec() {
        }

        @Override
        public Class<SourceArtifact> getEncodedClass() {
            return SourceArtifact.class;
        }

        @Override
        public void serialize(SerializationContext context, SourceArtifact obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            context.serialize(obj.getExecPath(), codedOut);
            context.serialize(obj.getRoot(), codedOut);
            context.serialize(obj.getArtifactOwner(), codedOut);
        }

        @Override
        public SourceArtifact deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            PathFragment execPath = (PathFragment)context.deserialize(codedIn);
            ArtifactRoot artifactRoot = (ArtifactRoot)context.deserialize(codedIn);
            ArtifactOwner owner = (ArtifactOwner)context.deserialize(codedIn);
            return context.getDependency(ArtifactSerializationContext.class).getSourceArtifact(execPath, artifactRoot.getRoot(), owner);
        }
    }

    public static final class SourceArtifact
    extends Artifact {
        private final ArtifactOwner owner;

        @VisibleForTesting
        public SourceArtifact(ArtifactRoot root, PathFragment execPath, ArtifactOwner owner) {
            super(root, execPath, execPath.hashCode());
            this.owner = owner;
        }

        @Override
        boolean ownersEqual(Artifact other) {
            return true;
        }

        @Override
        public PathFragment getRootRelativePath() {
            return ((ArtifactRoot)this.getRoot()).isExternal() ? this.getExecPath().subFragment(2) : this.getExecPath();
        }

        @Override
        public PathFragment getPathForLocationExpansion() {
            return this.getExecPath();
        }

        @Override
        public PathFragment getOutputDirRelativePath(boolean siblingRepositoryLayout) {
            return siblingRepositoryLayout ? this.getRepositoryRelativePath() : this.getExecPath();
        }

        @Override
        public PathFragment getRepositoryRelativePath() {
            return this.getRootRelativePath();
        }

        @Override
        public ArtifactOwner getArtifactOwner() {
            return this.owner;
        }

        @Override
        public Label getOwnerLabel() {
            return this.owner.getLabel();
        }

        boolean differentOwnerOrRoot(ArtifactOwner owner, ArtifactRoot root) {
            return !this.owner.equals(owner) || !((ArtifactRoot)this.getRoot()).equals(root);
        }
    }

    private static final class DerivedArtifactCodec
    implements ObjectCodec<DerivedArtifact> {
        private DerivedArtifactCodec() {
        }

        @Override
        public Class<DerivedArtifact> getEncodedClass() {
            return DerivedArtifact.class;
        }

        @Override
        public void serialize(SerializationContext context, DerivedArtifact obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            context.serialize(obj.getRoot(), codedOut);
            context.serialize(obj.getRootRelativePath(), codedOut);
            context.serialize(Artifact.getGeneratingActionKeyForSerialization(obj, context), codedOut);
        }

        @Override
        public DerivedArtifact deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            ArtifactRoot root = (ArtifactRoot)context.deserialize(codedIn);
            PathFragment rootRelativePath = (PathFragment)context.deserialize(codedIn);
            Object generatingActionKey = context.deserialize(codedIn);
            DerivedArtifact artifact = new DerivedArtifact(root, Artifact.getExecPathForDeserialization(root, rootRelativePath, generatingActionKey), generatingActionKey);
            return context.getDependency(ArtifactSerializationContext.class).intern(artifact);
        }
    }

    public static interface ArtifactSerializationContext {
        public SourceArtifact getSourceArtifact(PathFragment var1, Root var2, ArtifactOwner var3);

        default public boolean includeGeneratingActionKey(DerivedArtifact artifact) {
            return true;
        }

        default public DerivedArtifact intern(DerivedArtifact original) {
            return original;
        }
    }

    public static class DerivedArtifact
    extends Artifact
    implements PathStrippable {
        private Object owner;
        private final boolean contentBasedPath;

        public static DerivedArtifact create(ArtifactRoot root, PathFragment execPath, ActionLookupKeyOrProxy owner) {
            return DerivedArtifact.create(root, execPath, owner, false);
        }

        public static DerivedArtifact create(ArtifactRoot root, PathFragment execPath, ActionLookupKeyOrProxy owner, boolean contentBasedPath) {
            return new DerivedArtifact(root, execPath, owner, contentBasedPath);
        }

        private DerivedArtifact(ArtifactRoot root, PathFragment execPath, Object owner) {
            this(root, execPath, owner, false);
        }

        private DerivedArtifact(ArtifactRoot root, PathFragment execPath, Object owner, boolean contentBasedPath) {
            super(root, execPath, HashCodes.hashObjects(execPath, DerivedArtifact.getOwnerToUseForHashCode(owner)));
            Preconditions.checkState(!root.getExecPath().isEmpty(), "Derived root has no exec path: %s, %s", (Object)root, (Object)execPath);
            this.owner = Preconditions.checkNotNull(owner);
            this.contentBasedPath = contentBasedPath;
        }

        @VisibleForTesting
        public final void setGeneratingActionKey(ActionLookupData generatingActionKey) {
            Preconditions.checkState(this.owner != OMITTED_FOR_SERIALIZATION, "Owner was omitted for serialization: %s", (Object)this);
            Preconditions.checkState(this.owner instanceof ActionLookupKeyOrProxy, "Already set generating action key: %s (%s %s)", (Object)this, this.owner, (Object)generatingActionKey);
            Preconditions.checkState(Preconditions.checkNotNull(generatingActionKey, this).getActionLookupKey().equals(this.owner), "Owner of generating action key not same as artifact's owner: %s (%s %s)", (Object)this, this.owner, (Object)generatingActionKey);
            this.owner = generatingActionKey;
        }

        @VisibleForTesting
        public final boolean hasGeneratingActionKey() {
            return this.owner instanceof ActionLookupData;
        }

        public final ActionLookupData getGeneratingActionKey() {
            Preconditions.checkState(this.owner instanceof ActionLookupData, "Bad owner: %s %s", (Object)this, this.owner);
            return (ActionLookupData)this.owner;
        }

        @Override
        public final ActionLookupKeyOrProxy getArtifactOwner() {
            Preconditions.checkState(this.owner != OMITTED_FOR_SERIALIZATION, "Owner was omitted for serialization: %s", (Object)this);
            return this.owner instanceof ActionLookupData ? this.getGeneratingActionKey().getActionLookupKey() : (ActionLookupKeyOrProxy)this.owner;
        }

        private static Object getOwnerToUseForHashCode(Object owner) {
            return owner instanceof ActionLookupData ? ((ActionLookupData)owner).getActionLookupKey() : owner;
        }

        @Override
        public final Label getOwnerLabel() {
            return this.getArtifactOwner().getLabel();
        }

        @Override
        public final String toDebugString() {
            if (this.hasGeneratingActionKey() || this.owner == OMITTED_FOR_SERIALIZATION) {
                return super.toDetailString() + " (" + this.owner + ")";
            }
            return super.toDebugString();
        }

        @Override
        public final PathFragment getRootRelativePath() {
            return this.getExecPath().relativeTo(((ArtifactRoot)this.getRoot()).getExecPath());
        }

        @Override
        final boolean ownersEqual(Artifact other) {
            DerivedArtifact that = (DerivedArtifact)other;
            if (!(this.owner instanceof ActionLookupData) || !(that.owner instanceof ActionLookupData)) {
                return this.getArtifactOwner().equals(that.getArtifactOwner());
            }
            return this.owner.equals(that.owner);
        }

        @Override
        public boolean contentBasedPath() {
            return this.contentBasedPath;
        }

        @Override
        public String expand(UnaryOperator<PathFragment> stripPaths) {
            return ((PathFragment)stripPaths.apply(this.getExecPath())).getPathString();
        }
    }

    public static class ArtifactExpanderImpl
    implements ArtifactExpander {
        private final Map<Artifact, ImmutableCollection<? extends Artifact>> expandedInputs;
        private final Map<SpecialArtifact, ArchivedTreeArtifact> archivedTreeArtifacts;
        private final Map<Artifact, ImmutableList<FilesetOutputSymlink>> expandedFilesets;

        public ArtifactExpanderImpl(Map<Artifact, ImmutableCollection<? extends Artifact>> expandedInputs, Map<SpecialArtifact, ArchivedTreeArtifact> archivedTreeArtifacts, Map<Artifact, ImmutableList<FilesetOutputSymlink>> expandedFilesets) {
            this.expandedInputs = expandedInputs;
            this.archivedTreeArtifacts = archivedTreeArtifacts;
            this.expandedFilesets = expandedFilesets;
        }

        @Override
        public void expand(Artifact artifact, Collection<? super Artifact> output) {
            Preconditions.checkState(artifact.isMiddlemanArtifact() || artifact.isTreeArtifact(), artifact);
            ImmutableCollection<? extends Artifact> result = this.expandedInputs.get(artifact);
            if (result != null) {
                output.addAll(result);
            }
        }

        @Override
        public ImmutableList<FilesetOutputSymlink> getFileset(Artifact artifact) throws MissingExpansionException {
            Preconditions.checkState(artifact.isFileset());
            ImmutableList<FilesetOutputSymlink> filesetLinks = this.expandedFilesets.get(artifact);
            if (filesetLinks == null) {
                throw new MissingExpansionException("Missing expansion for fileset: " + artifact);
            }
            return filesetLinks;
        }

        @Override
        public ArchivedTreeArtifact getArchivedTreeArtifact(SpecialArtifact treeArtifact) {
            return this.archivedTreeArtifacts.get(treeArtifact);
        }
    }

    public static final class MissingExpansionException
    extends Exception {
        public MissingExpansionException(String message) {
            super(message);
        }
    }

    public static interface ArtifactExpander {
        public void expand(Artifact var1, Collection<? super Artifact> var2);

        default public ImmutableList<FilesetOutputSymlink> getFileset(Artifact artifact) throws MissingExpansionException {
            throw new MissingExpansionException("Cannot expand fileset " + artifact);
        }

        @Nullable
        default public ArchivedTreeArtifact getArchivedTreeArtifact(SpecialArtifact treeArtifact) {
            return null;
        }
    }
}

