/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.actions.ActionLookupKeyOrProxy;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.skyframe.SkyFunctions;
import com.google.devtools.build.skyframe.ExecutionPhaseSkyKey;
import com.google.devtools.build.skyframe.SkyFunctionName;

public abstract class ActionLookupData
implements ExecutionPhaseSkyKey {
    private final ActionLookupKeyOrProxy actionLookupKey;

    public static ActionLookupData create(ActionLookupKeyOrProxy actionLookupKey, int actionIndex) {
        if (!actionLookupKey.mayOwnShareableActions()) {
            return ActionLookupData.createUnshareable(actionLookupKey, actionIndex);
        }
        switch (actionIndex) {
            case 0: {
                return new ActionLookupData0(actionLookupKey);
            }
            case 1: {
                return new ActionLookupData1(actionLookupKey);
            }
            case 2: {
                return new ActionLookupData2(actionLookupKey);
            }
            case 3: {
                return new ActionLookupData3(actionLookupKey);
            }
            case 4: {
                return new ActionLookupData4(actionLookupKey);
            }
            case 5: {
                return new ActionLookupData5(actionLookupKey);
            }
            case 6: {
                return new ActionLookupData6(actionLookupKey);
            }
            case 7: {
                return new ActionLookupData7(actionLookupKey);
            }
            case 8: {
                return new ActionLookupData8(actionLookupKey);
            }
            case 9: {
                return new ActionLookupData9(actionLookupKey);
            }
        }
        return new ActionLookupDataN(actionLookupKey, actionIndex);
    }

    public static ActionLookupData createUnshareable(ActionLookupKeyOrProxy actionLookupKey, int actionIndex) {
        return new UnshareableActionLookupData(actionLookupKey, actionIndex);
    }

    private ActionLookupData(ActionLookupKeyOrProxy actionLookupKey) {
        this.actionLookupKey = Preconditions.checkNotNull(actionLookupKey);
    }

    public ActionLookupKeyOrProxy getActionLookupKey() {
        return this.actionLookupKey;
    }

    public abstract int getActionIndex();

    public final Label getLabel() {
        return this.actionLookupKey.getLabel();
    }

    public final int hashCode() {
        int hash = 1;
        hash = 37 * hash + this.actionLookupKey.hashCode();
        hash = 37 * hash + Integer.hashCode(this.getActionIndex());
        hash = 37 * hash + Boolean.hashCode(this.valueIsShareable());
        return hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ActionLookupData)) {
            return false;
        }
        ActionLookupData that = (ActionLookupData)obj;
        return this.getActionIndex() == that.getActionIndex() && this.actionLookupKey.equals(that.actionLookupKey) && this.valueIsShareable() == that.valueIsShareable();
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("actionLookupKey", this.actionLookupKey).add("actionIndex", this.getActionIndex()).toString();
    }

    @Override
    public final SkyFunctionName functionName() {
        return SkyFunctions.ACTION_EXECUTION;
    }

    private static final class UnshareableActionLookupData
    extends ActionLookupDataN {
        private UnshareableActionLookupData(ActionLookupKeyOrProxy actionLookupKey, int actionIndex) {
            super(actionLookupKey, actionIndex);
        }

        @Override
        public boolean valueIsShareable() {
            return false;
        }
    }

    private static class ActionLookupDataN
    extends ActionLookupData {
        private final int actionIndex;

        private ActionLookupDataN(ActionLookupKeyOrProxy actionLookupKey, int actionIndex) {
            super(actionLookupKey);
            this.actionIndex = actionIndex;
        }

        @Override
        public final int getActionIndex() {
            return this.actionIndex;
        }
    }

    private static final class ActionLookupData9
    extends ActionLookupData {
        private ActionLookupData9(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 9;
        }
    }

    private static final class ActionLookupData8
    extends ActionLookupData {
        private ActionLookupData8(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 8;
        }
    }

    private static final class ActionLookupData7
    extends ActionLookupData {
        private ActionLookupData7(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 7;
        }
    }

    private static final class ActionLookupData6
    extends ActionLookupData {
        private ActionLookupData6(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 6;
        }
    }

    private static final class ActionLookupData5
    extends ActionLookupData {
        private ActionLookupData5(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 5;
        }
    }

    private static final class ActionLookupData4
    extends ActionLookupData {
        private ActionLookupData4(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 4;
        }
    }

    private static final class ActionLookupData3
    extends ActionLookupData {
        private ActionLookupData3(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 3;
        }
    }

    private static final class ActionLookupData2
    extends ActionLookupData {
        private ActionLookupData2(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 2;
        }
    }

    private static final class ActionLookupData1
    extends ActionLookupData {
        private ActionLookupData1(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 1;
        }
    }

    private static final class ActionLookupData0
    extends ActionLookupData {
        private ActionLookupData0(ActionLookupKeyOrProxy actionLookupKey) {
            super(actionLookupKey);
        }

        @Override
        public int getActionIndex() {
            return 0;
        }
    }
}

