/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.docgen.annot;

import com.google.common.base.Ascii;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GlobalMethods {
    public Environment[] environment();

    public static enum Environment {
        BUILD("BUILD files", "This page contains global methods available in BUILD files. See also the Build Encyclopedia for extra <a href=\"${link functions}\">functions</a> and build rules, which can also be used in BUILD files."),
        WORKSPACE("WORKSPACE files", "This page contains global methods available in WORKSPACE files."),
        MODULE("MODULE.bazel files", "This page contains global methods available in MODULE.bazel files."),
        BZL(".bzl files", "This page contains global methods available in all .bzl files."),
        ALL("All Starlark files", "This page contains global methods available in all Starlark files, including BUILD, WORKSPACE, MODULE.bazel, and all .bzl files.");

        private final String title;
        private final String description;

        private Environment(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPath() {
            return Ascii.toLowerCase(this.name());
        }
    }
}

