/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.util;

public class Checks {
    private Checks() {
    }

    public static <T> T checkNotNull(T value, String name) {
        if (value == null) {
            throw new NullPointerException(name + " must not be null");
        }
        return value;
    }

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static String checkMetadataIdentifier(String s2) {
        if (s2.isEmpty()) {
            throw new IllegalArgumentException("identifier must not be empty");
        }
        if (!Checks.isLetter(s2.charAt(0))) {
            throw new IllegalArgumentException("identifier must start with an ASCII letter: " + s2);
        }
        for (int n = 1; n < s2.length(); ++n) {
            char c = s2.charAt(n);
            if (Checks.isLetter(c) || c >= '0' && c <= '9' || c == '_') continue;
            throw new IllegalArgumentException("identifier must contain only ASCII letters, digits or underscore: " + s2);
        }
        return s2;
    }

    private static boolean isLetter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }
}

