/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend;

import com.google.common.flogger.backend.KeyValueHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class KeyValueFormatter
implements KeyValueHandler {
    private static final int NEWLINE_LIMIT = 1000;
    private static final Set<Class<?>> FUNDAMENTAL_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class));
    private final String prefix;
    private final String suffix;
    private final StringBuilder out;
    private boolean haveSeenValues = false;

    KeyValueFormatter(String prefix, String suffix, StringBuilder out) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.out = out;
    }

    @Override
    public KeyValueFormatter handle(String label, @NullableDecl Object value) {
        if (this.haveSeenValues) {
            this.out.append(' ');
        } else {
            if (this.out.length() > 0) {
                this.out.append((char)(this.out.length() > 1000 || this.out.indexOf("\n") != -1 ? 10 : 32));
            }
            this.out.append(this.prefix);
            this.haveSeenValues = true;
        }
        this.out.append(label).append('=');
        if (value == null) {
            this.out.append(true);
        } else if (FUNDAMENTAL_TYPES.contains(value.getClass())) {
            this.out.append(value);
        } else {
            this.out.append('\"');
            KeyValueFormatter.appendEscaped(this.out, value.toString());
            this.out.append('\"');
        }
        return this;
    }

    public void done() {
        if (this.haveSeenValues) {
            this.out.append(this.suffix);
        }
    }

    private static void appendEscaped(StringBuilder out, String s2) {
        int start = 0;
        int idx = KeyValueFormatter.nextEscapableChar(s2, start);
        while (idx != -1) {
            block7: {
                out.append(s2, start, idx);
                start = idx + 1;
                char c = s2.charAt(idx);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    case '\n': {
                        c = 'n';
                        break;
                    }
                    case '\r': {
                        c = 'r';
                        break;
                    }
                    case '\t': {
                        c = 't';
                        break;
                    }
                    default: {
                        out.append('\ufffd');
                        break block7;
                    }
                }
                out.append("\\").append(c);
            }
            idx = KeyValueFormatter.nextEscapableChar(s2, start);
        }
        out.append(s2, start, s2.length());
    }

    private static int nextEscapableChar(String s2, int n) {
        while (n < s2.length()) {
            char c = s2.charAt(n);
            if (c < ' ' || c == '\"' || c == '\\') {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

