/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.TokenKind;

public final class UnaryOperatorExpression
extends Expression {
    private final TokenKind op;
    private final int opOffset;
    private final Expression x;

    UnaryOperatorExpression(FileLocations locs, TokenKind op, int opOffset, Expression x) {
        super(locs, Expression.Kind.UNARY_OPERATOR);
        this.op = op;
        this.opOffset = opOffset;
        this.x = x;
    }

    public TokenKind getOperator() {
        return this.op;
    }

    @Override
    public int getStartOffset() {
        return this.opOffset;
    }

    @Override
    public int getEndOffset() {
        return this.x.getEndOffset();
    }

    public Expression getX() {
        return this.x;
    }

    @Override
    public String toString() {
        return (this.op == TokenKind.NOT ? "not " : this.op.toString()) + this.x;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

