/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import java.util.ArrayList;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Lexer;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.ParserInput;
import net.starlark.java.syntax.SyntaxError;
import net.starlark.java.syntax.TokenKind;

public final class StringLiteral
extends Expression {
    private final int startOffset;
    private final String value;
    private final int endOffset;

    StringLiteral(FileLocations locs, int startOffset, String value, int endOffset) {
        super(locs, Expression.Kind.STRING_LITERAL);
        this.startOffset = startOffset;
        this.value = value;
        this.endOffset = endOffset;
    }

    public String getValue() {
        return this.value;
    }

    public Location getLocation() {
        return this.locs.getLocation(this.startOffset);
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public Object getFileLocations() {
        return this.locs;
    }

    public static String unquote(String s2) {
        ArrayList<SyntaxError> errors = new ArrayList<SyntaxError>();
        Lexer lexer = new Lexer(ParserInput.fromLines(s2), errors);
        lexer.nextToken();
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(errors.get(0).message());
        }
        if (lexer.start != 0 || lexer.end != s2.length() || lexer.kind != TokenKind.STRING) {
            throw new IllegalArgumentException("invalid syntax");
        }
        return (String)lexer.value;
    }

    public static StringLiteral fromSerialization(Object fileLocations, int startOffset, String value, int endOffset) {
        return new StringLiteral((FileLocations)fileLocations, startOffset, value, endOffset);
    }
}

