/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.starlark.java.syntax.Comment;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.FileOptions;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Parser;
import net.starlark.java.syntax.ParserInput;
import net.starlark.java.syntax.Resolver;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.SyntaxError;

public final class StarlarkFile
extends Node {
    private final ImmutableList<Statement> statements;
    private final FileOptions options;
    private final ImmutableList<Comment> comments;
    final List<SyntaxError> errors;
    @Nullable
    private Resolver.Function resolved;

    @Override
    public int getStartOffset() {
        return 0;
    }

    @Override
    public int getEndOffset() {
        return this.locs.size();
    }

    private StarlarkFile(FileLocations locs, ImmutableList<Statement> statements, FileOptions options, ImmutableList<Comment> comments, List<SyntaxError> errors) {
        super(locs);
        this.statements = statements;
        this.options = options;
        this.comments = comments;
        this.errors = errors;
    }

    @Deprecated
    public StarlarkFile subTree(int start, int end) {
        return new StarlarkFile(this.locs, (ImmutableList<Statement>)this.statements.subList(start, end), this.options, ImmutableList.of(), this.errors);
    }

    public List<SyntaxError> errors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean ok() {
        return this.errors.isEmpty();
    }

    public ImmutableList<Statement> getStatements() {
        return this.statements;
    }

    public ImmutableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public String toString() {
        return "<StarlarkFile with " + this.statements.size() + " statements>";
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    void setResolvedFunction(Resolver.Function resolved) {
        this.resolved = resolved;
    }

    @Nullable
    public Resolver.Function getResolvedFunction() {
        return this.resolved;
    }

    public static StarlarkFile parse(ParserInput input, FileOptions options) {
        Parser.ParseResult result = Parser.parseFile(input);
        return new StarlarkFile(result.locs, result.statements, options, result.comments, result.errors);
    }

    public static StarlarkFile parse(ParserInput input) {
        return StarlarkFile.parse(input, FileOptions.DEFAULT);
    }

    public FileOptions getOptions() {
        return this.options;
    }

    public String getName() {
        return this.locs.file();
    }

    public static void setParseProfiler(@Nullable ParseProfiler p) {
        Parser.profiler = p;
    }

    public static interface ParseProfiler {
        public Object start(String var1);

        public void end(Object var1);
    }
}

