/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import javax.annotation.Nullable;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.NodeVisitor;

public final class SliceExpression
extends Expression {
    private final Expression object;
    private final int lbracketOffset;
    @Nullable
    private final Expression start;
    @Nullable
    private final Expression stop;
    @Nullable
    private final Expression step;
    private final int rbracketOffset;

    SliceExpression(FileLocations locs, Expression object, int lbracketOffset, Expression start, Expression stop, Expression step, int rbracketOffset) {
        super(locs, Expression.Kind.SLICE);
        this.object = object;
        this.lbracketOffset = lbracketOffset;
        this.start = start;
        this.stop = stop;
        this.step = step;
        this.rbracketOffset = rbracketOffset;
    }

    public Expression getObject() {
        return this.object;
    }

    @Nullable
    public Expression getStart() {
        return this.start;
    }

    @Nullable
    public Expression getStop() {
        return this.stop;
    }

    @Nullable
    public Expression getStep() {
        return this.step;
    }

    @Override
    public int getStartOffset() {
        return this.object.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.rbracketOffset + 1;
    }

    public Location getLbracketLocation() {
        return this.locs.getLocation(this.lbracketOffset);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

