/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.starlark.java.syntax.Argument;
import net.starlark.java.syntax.AssignmentStatement;
import net.starlark.java.syntax.BinaryOperatorExpression;
import net.starlark.java.syntax.CallExpression;
import net.starlark.java.syntax.Comment;
import net.starlark.java.syntax.Comprehension;
import net.starlark.java.syntax.ConditionalExpression;
import net.starlark.java.syntax.DefStatement;
import net.starlark.java.syntax.DictExpression;
import net.starlark.java.syntax.DotExpression;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.ExpressionStatement;
import net.starlark.java.syntax.FloatLiteral;
import net.starlark.java.syntax.FlowStatement;
import net.starlark.java.syntax.ForStatement;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.IfStatement;
import net.starlark.java.syntax.IndexExpression;
import net.starlark.java.syntax.IntLiteral;
import net.starlark.java.syntax.LambdaExpression;
import net.starlark.java.syntax.ListExpression;
import net.starlark.java.syntax.LoadStatement;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.Parameter;
import net.starlark.java.syntax.ReturnStatement;
import net.starlark.java.syntax.SliceExpression;
import net.starlark.java.syntax.StarlarkFile;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.StringLiteral;
import net.starlark.java.syntax.TokenKind;
import net.starlark.java.syntax.UnaryOperatorExpression;

final class NodePrinter {
    private final StringBuilder buf;
    private int indent;

    NodePrinter(StringBuilder buf) {
        this.buf = buf;
    }

    NodePrinter(StringBuilder buf, int indent) {
        this.buf = buf;
        this.indent = indent;
    }

    void printNode(Node n) {
        if (n instanceof Expression) {
            this.printExpr((Expression)n);
        } else if (n instanceof Statement) {
            this.printStmt((Statement)n);
        } else if (n instanceof StarlarkFile) {
            StarlarkFile file = (StarlarkFile)n;
            for (Statement stmt : file.getStatements()) {
                this.printStmt(stmt);
            }
        } else if (n instanceof Comment) {
            Comment comment = (Comment)n;
            this.printIndent();
            this.buf.append(comment.getText());
        } else if (n instanceof Argument) {
            this.printArgument((Argument)n);
        } else if (n instanceof Parameter) {
            this.printParameter((Parameter)n);
        } else if (n instanceof DictExpression.Entry) {
            this.printDictEntry((DictExpression.Entry)n);
        } else {
            throw new IllegalArgumentException("unexpected: " + n.getClass());
        }
    }

    private void printSuite(List<Statement> statements) {
        ++this.indent;
        for (Statement stmt : statements) {
            this.printStmt(stmt);
        }
        --this.indent;
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.buf.append("  ");
        }
    }

    private void printArgument(Argument arg) {
        if (!(arg instanceof Argument.Positional)) {
            if (arg instanceof Argument.Keyword) {
                this.buf.append(((Argument.Keyword)arg).getIdentifier().getName());
                this.buf.append(" = ");
            } else if (arg instanceof Argument.Star) {
                this.buf.append('*');
            } else if (arg instanceof Argument.StarStar) {
                this.buf.append("**");
            }
        }
        this.printExpr(arg.getValue());
    }

    private void printParameter(Parameter param) {
        if (param instanceof Parameter.Mandatory) {
            this.buf.append(param.getName());
        } else if (param instanceof Parameter.Optional) {
            this.buf.append(param.getName());
            this.buf.append('=');
            this.printExpr(param.getDefaultValue());
        } else if (param instanceof Parameter.Star) {
            this.buf.append('*');
            if (param.getName() != null) {
                this.buf.append(param.getName());
            }
        } else if (param instanceof Parameter.StarStar) {
            this.buf.append("**");
            this.buf.append(param.getName());
        }
    }

    private void printDictEntry(DictExpression.Entry e) {
        this.printExpr(e.getKey());
        this.buf.append(": ");
        this.printExpr(e.getValue());
    }

    void printDefSignature(DefStatement def) {
        this.buf.append("def ");
        this.printExpr(def.getIdentifier());
        this.buf.append('(');
        String sep = "";
        for (Parameter param : def.getParameters()) {
            this.buf.append(sep);
            this.printParameter(param);
            sep = ", ";
        }
        this.buf.append("):");
    }

    private void printStmt(Statement s2) {
        this.printIndent();
        switch (s2.kind()) {
            case ASSIGNMENT: {
                AssignmentStatement stmt = (AssignmentStatement)s2;
                this.printExpr(stmt.getLHS());
                this.buf.append(' ');
                if (stmt.isAugmented()) {
                    this.buf.append((Object)stmt.getOperator());
                }
                this.buf.append("= ");
                this.printExpr(stmt.getRHS());
                this.buf.append('\n');
                break;
            }
            case EXPRESSION: {
                ExpressionStatement stmt = (ExpressionStatement)s2;
                this.printExpr(stmt.getExpression());
                this.buf.append('\n');
                break;
            }
            case FLOW: {
                FlowStatement stmt = (FlowStatement)s2;
                this.buf.append((Object)stmt.getFlowKind()).append('\n');
                break;
            }
            case FOR: {
                ForStatement stmt = (ForStatement)s2;
                this.buf.append("for ");
                this.printExpr(stmt.getVars());
                this.buf.append(" in ");
                this.printExpr(stmt.getCollection());
                this.buf.append(":\n");
                this.printSuite(stmt.getBody());
                break;
            }
            case DEF: {
                DefStatement stmt = (DefStatement)s2;
                this.printDefSignature(stmt);
                this.buf.append('\n');
                this.printSuite(stmt.getBody());
                break;
            }
            case IF: {
                IfStatement stmt = (IfStatement)s2;
                this.buf.append(stmt.isElif() ? "elif " : "if ");
                this.printExpr(stmt.getCondition());
                this.buf.append(":\n");
                this.printSuite(stmt.getThenBlock());
                ImmutableList<Statement> elseBlock = stmt.getElseBlock();
                if (elseBlock == null) break;
                if (elseBlock.size() == 1 && elseBlock.get(0) instanceof IfStatement && ((IfStatement)elseBlock.get(0)).isElif()) {
                    this.printStmt((Statement)elseBlock.get(0));
                    break;
                }
                this.printIndent();
                this.buf.append("else:\n");
                this.printSuite(elseBlock);
                break;
            }
            case LOAD: {
                LoadStatement stmt = (LoadStatement)s2;
                this.buf.append("load(");
                this.printExpr(stmt.getImport());
                for (LoadStatement.Binding binding : stmt.getBindings()) {
                    this.buf.append(", ");
                    Identifier local = binding.getLocalName();
                    String origName = binding.getOriginalName().getName();
                    if (origName.equals(local.getName())) {
                        this.buf.append('\"');
                        this.printExpr(local);
                        this.buf.append('\"');
                        continue;
                    }
                    this.printExpr(local);
                    this.buf.append("=\"");
                    this.buf.append(origName);
                    this.buf.append('\"');
                }
                this.buf.append(")\n");
                break;
            }
            case RETURN: {
                ReturnStatement stmt = (ReturnStatement)s2;
                this.buf.append("return");
                if (stmt.getResult() != null) {
                    this.buf.append(' ');
                    this.printExpr(stmt.getResult());
                }
                this.buf.append('\n');
                break;
            }
        }
    }

    private void printExpr(Expression expr) {
        switch (expr.kind()) {
            case BINARY_OPERATOR: {
                BinaryOperatorExpression binop = (BinaryOperatorExpression)expr;
                this.buf.append('(');
                this.printExpr(binop.getX());
                this.buf.append(' ');
                this.buf.append((Object)binop.getOperator());
                this.buf.append(' ');
                this.printExpr(binop.getY());
                this.buf.append(')');
                break;
            }
            case COMPREHENSION: {
                Comprehension comp = (Comprehension)expr;
                this.buf.append(comp.isDict() ? (char)'{' : '[');
                this.printNode(comp.getBody());
                for (Comprehension.Clause clause : comp.getClauses()) {
                    this.buf.append(' ');
                    if (clause instanceof Comprehension.For) {
                        Comprehension.For forClause = (Comprehension.For)clause;
                        this.buf.append("for ");
                        this.printExpr(forClause.getVars());
                        this.buf.append(" in ");
                        this.printExpr(forClause.getIterable());
                        continue;
                    }
                    Comprehension.If ifClause = (Comprehension.If)clause;
                    this.buf.append("if ");
                    this.printExpr(ifClause.getCondition());
                }
                this.buf.append(comp.isDict() ? (char)'}' : ']');
                break;
            }
            case CONDITIONAL: {
                ConditionalExpression cond = (ConditionalExpression)expr;
                this.printExpr(cond.getThenCase());
                this.buf.append(" if ");
                this.printExpr(cond.getCondition());
                this.buf.append(" else ");
                this.printExpr(cond.getElseCase());
                break;
            }
            case DICT_EXPR: {
                DictExpression dictexpr = (DictExpression)expr;
                this.buf.append("{");
                String sep = "";
                for (DictExpression.Entry entry : dictexpr.getEntries()) {
                    this.buf.append(sep);
                    this.printDictEntry(entry);
                    sep = ", ";
                }
                this.buf.append("}");
                break;
            }
            case DOT: {
                DotExpression dot = (DotExpression)expr;
                this.printExpr(dot.getObject());
                this.buf.append('.');
                this.printExpr(dot.getField());
                break;
            }
            case CALL: {
                CallExpression call = (CallExpression)expr;
                this.printExpr(call.getFunction());
                this.buf.append('(');
                String sep = "";
                for (Argument arg : call.getArguments()) {
                    this.buf.append(sep);
                    this.printArgument(arg);
                    sep = ", ";
                }
                this.buf.append(')');
                break;
            }
            case IDENTIFIER: {
                this.buf.append(((Identifier)expr).getName());
                break;
            }
            case INDEX: {
                IndexExpression index = (IndexExpression)expr;
                this.printExpr(index.getObject());
                this.buf.append('[');
                this.printExpr(index.getKey());
                this.buf.append(']');
                break;
            }
            case INT_LITERAL: {
                this.buf.append(((IntLiteral)expr).getValue());
                break;
            }
            case FLOAT_LITERAL: {
                this.buf.append(((FloatLiteral)expr).getValue());
                break;
            }
            case LAMBDA: {
                LambdaExpression lambda = (LambdaExpression)expr;
                this.buf.append("lambda");
                String sep = " ";
                for (Parameter param : lambda.getParameters()) {
                    this.buf.append(sep);
                    sep = ", ";
                    this.printParameter(param);
                }
                this.buf.append(": ");
                this.printExpr(lambda.getBody());
                break;
            }
            case LIST_EXPR: {
                ListExpression list = (ListExpression)expr;
                this.buf.append(list.isTuple() ? (char)'(' : '[');
                String sep = "";
                for (Expression e : list.getElements()) {
                    this.buf.append(sep);
                    this.printExpr(e);
                    sep = ", ";
                }
                if (list.isTuple() && list.getElements().size() == 1) {
                    this.buf.append(',');
                }
                this.buf.append(list.isTuple() ? (char)')' : ']');
                break;
            }
            case SLICE: {
                SliceExpression slice = (SliceExpression)expr;
                this.printExpr(slice.getObject());
                this.buf.append('[');
                if (slice.getStart() != null) {
                    this.printExpr(slice.getStart());
                }
                this.buf.append(':');
                if (slice.getStop() != null) {
                    this.printExpr(slice.getStop());
                }
                if (slice.getStep() != null) {
                    this.buf.append(':');
                    this.printExpr(slice.getStep());
                }
                this.buf.append(']');
                break;
            }
            case STRING_LITERAL: {
                StringLiteral literal = (StringLiteral)expr;
                String value = literal.getValue();
                this.buf.append('\"');
                block29: for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    switch (c) {
                        case '\"': {
                            this.buf.append("\\\"");
                            continue block29;
                        }
                        case '\\': {
                            this.buf.append("\\\\");
                            continue block29;
                        }
                        case '\r': {
                            this.buf.append("\\r");
                            continue block29;
                        }
                        case '\n': {
                            this.buf.append("\\n");
                            continue block29;
                        }
                        case '\t': {
                            this.buf.append("\\t");
                            continue block29;
                        }
                        default: {
                            if (c < ' ') {
                                this.buf.append(String.format("\\x%02x", c));
                                continue block29;
                            }
                            this.buf.append(c);
                        }
                    }
                }
                this.buf.append('\"');
                break;
            }
            case UNARY_OPERATOR: {
                UnaryOperatorExpression unop = (UnaryOperatorExpression)expr;
                this.buf.append(unop.getOperator() == TokenKind.NOT ? "not " : unop.getOperator().toString());
                this.buf.append('(');
                this.printExpr(unop.getX());
                this.buf.append(')');
                break;
            }
        }
    }
}

