/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.starlark.java.syntax.Comment;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.IntLiteral;
import net.starlark.java.syntax.ParserInput;
import net.starlark.java.syntax.SyntaxError;
import net.starlark.java.syntax.TokenKind;

final class Lexer {
    private static final Interner<String> identInterner = Interners.newWeakInterner();
    final FileLocations locs;
    TokenKind kind;
    int start;
    int end;
    Object value;
    private final List<SyntaxError> errors;
    private final char[] buffer;
    private int pos;
    private final Stack<Integer> indentStack = new Stack();
    private final ImmutableList.Builder<Comment> comments = ImmutableList.builder();
    private int openParenStackDepth = 0;
    private boolean checkIndentation;
    private int dents;
    private static final ImmutableMap<Character, TokenKind> EQUAL_TOKENS = ImmutableMap.builder().put(Character.valueOf('='), TokenKind.EQUALS_EQUALS).put(Character.valueOf('!'), TokenKind.NOT_EQUALS).put(Character.valueOf('>'), TokenKind.GREATER_EQUALS).put(Character.valueOf('<'), TokenKind.LESS_EQUALS).put(Character.valueOf('+'), TokenKind.PLUS_EQUALS).put(Character.valueOf('-'), TokenKind.MINUS_EQUALS).put(Character.valueOf('*'), TokenKind.STAR_EQUALS).put(Character.valueOf('/'), TokenKind.SLASH_EQUALS).put(Character.valueOf('%'), TokenKind.PERCENT_EQUALS).put(Character.valueOf('^'), TokenKind.CARET_EQUALS).put(Character.valueOf('&'), TokenKind.AMPERSAND_EQUALS).put(Character.valueOf('|'), TokenKind.PIPE_EQUALS).buildOrThrow();
    private static final Map<String, TokenKind> keywordMap = new HashMap<String, TokenKind>();

    Lexer(ParserInput input, List<SyntaxError> errors) {
        this.locs = FileLocations.create(input.getContent(), input.getFile());
        this.buffer = input.getContent();
        this.pos = 0;
        this.errors = errors;
        this.checkIndentation = true;
        this.dents = 0;
        this.indentStack.push(0);
    }

    ImmutableList<Comment> getComments() {
        return this.comments.build();
    }

    void nextToken() {
        boolean afterNewline = this.kind == TokenKind.NEWLINE;
        this.tokenize();
        Preconditions.checkState(this.kind != null);
        if (this.kind == TokenKind.EOF && !afterNewline) {
            this.kind = TokenKind.NEWLINE;
        }
    }

    private void popParen() {
        if (this.openParenStackDepth == 0) {
            this.error("indentation error", this.pos - 1);
        } else {
            --this.openParenStackDepth;
        }
    }

    private void error(String message, int pos) {
        this.errors.add(new SyntaxError(this.locs.getLocation(pos), message));
    }

    private void setToken(TokenKind kind, int start, int end) {
        this.kind = kind;
        this.start = start;
        this.end = end;
        this.value = null;
    }

    private void setValue(Object value) {
        this.value = value;
    }

    String getRaw() {
        return this.bufferSlice(this.start, this.end);
    }

    private void newline() {
        if (this.openParenStackDepth > 0) {
            this.newlineInsideExpression();
        } else {
            this.checkIndentation = true;
            this.setToken(TokenKind.NEWLINE, this.pos - 1, this.pos);
        }
    }

    private void newlineInsideExpression() {
        block3: while (this.pos < this.buffer.length) {
            switch (this.buffer[this.pos]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private void computeIndentation() {
        int peekedIndent;
        int indentLen = 0;
        while (this.pos < this.buffer.length) {
            char c = this.buffer[this.pos];
            if (c == ' ') {
                ++indentLen;
                ++this.pos;
                continue;
            }
            if (c == '\r') {
                ++this.pos;
                continue;
            }
            if (c == '\t') {
                ++indentLen;
                ++this.pos;
                this.error("Tab characters are not allowed for indentation. Use spaces instead.", this.pos);
                continue;
            }
            if (c == '\n') {
                indentLen = 0;
                ++this.pos;
                continue;
            }
            if (c != '#') break;
            int oldPos = this.pos;
            while (this.pos < this.buffer.length && c != '\n') {
                c = this.buffer[this.pos++];
            }
            this.addComment(oldPos, this.pos - 1);
            indentLen = 0;
        }
        if (this.pos == this.buffer.length) {
            indentLen = 0;
        }
        if ((peekedIndent = this.indentStack.peek().intValue()) < indentLen) {
            this.indentStack.push(indentLen);
            ++this.dents;
        } else if (peekedIndent > indentLen) {
            while (peekedIndent > indentLen) {
                this.indentStack.pop();
                --this.dents;
                peekedIndent = this.indentStack.peek();
            }
            if (peekedIndent < indentLen) {
                this.error("indentation error", this.pos - 1);
            }
        }
    }

    private boolean skipTripleQuote(char quot) {
        if (this.peek(0) == quot && this.peek(1) == quot) {
            this.pos += 2;
            return true;
        }
        return false;
    }

    private void escapedStringLiteral(char quot, boolean isRaw) {
        int literalStartPos = isRaw ? this.pos - 2 : this.pos - 1;
        boolean inTriplequote = this.skipTripleQuote(quot);
        StringBuilder literal = new StringBuilder();
        block20: while (this.pos < this.buffer.length) {
            char c = this.buffer[this.pos];
            ++this.pos;
            switch (c) {
                case '\n': {
                    if (inTriplequote) {
                        literal.append(c);
                        continue block20;
                    }
                    this.error("unclosed string literal", literalStartPos);
                    this.setToken(TokenKind.STRING, literalStartPos, this.pos);
                    this.setValue(literal.toString());
                    return;
                }
                case '\\': {
                    if (this.pos == this.buffer.length) {
                        this.error("unclosed string literal", literalStartPos);
                        this.setToken(TokenKind.STRING, literalStartPos, this.pos);
                        this.setValue(literal.toString());
                        return;
                    }
                    if (isRaw) {
                        literal.append('\\');
                        if (this.peek(0) == 13 && this.peek(1) == 10) {
                            literal.append("\n");
                            this.pos += 2;
                            continue block20;
                        }
                        if (this.buffer[this.pos] == '\r' || this.buffer[this.pos] == '\n') {
                            literal.append("\n");
                            ++this.pos;
                            continue block20;
                        }
                        literal.append(this.buffer[this.pos]);
                        ++this.pos;
                        continue block20;
                    }
                    c = this.buffer[this.pos];
                    ++this.pos;
                    switch (c) {
                        case '\r': {
                            if (this.peek(0) != 10) continue block20;
                            ++this.pos;
                            continue block20;
                        }
                        case '\n': {
                            continue block20;
                        }
                        case 'a': {
                            literal.append('\u0007');
                            continue block20;
                        }
                        case 'b': {
                            literal.append('\b');
                            continue block20;
                        }
                        case 'f': {
                            literal.append('\f');
                            continue block20;
                        }
                        case 'n': {
                            literal.append('\n');
                            continue block20;
                        }
                        case 'r': {
                            literal.append('\r');
                            continue block20;
                        }
                        case 't': {
                            literal.append('\t');
                            continue block20;
                        }
                        case 'v': {
                            literal.append('\u000b');
                            continue block20;
                        }
                        case '\\': {
                            literal.append('\\');
                            continue block20;
                        }
                        case '\'': {
                            literal.append('\'');
                            continue block20;
                        }
                        case '\"': {
                            literal.append('\"');
                            continue block20;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int octal = c - 48;
                            if (this.pos < this.buffer.length && (c = this.buffer[this.pos]) >= '0' && c <= '7') {
                                ++this.pos;
                                octal = octal << 3 | c - 48;
                                if (this.pos < this.buffer.length && (c = this.buffer[this.pos]) >= '0' && c <= '7') {
                                    ++this.pos;
                                    octal = octal << 3 | c - 48;
                                }
                            }
                            if (octal > 255) {
                                this.error("octal escape sequence out of range (maximum is \\377)", this.pos - 1);
                            }
                            literal.append((char)(octal & 0xFF));
                            continue block20;
                        }
                    }
                    this.error("invalid escape sequence: \\" + c + ". Use '\\\\' to insert '\\'.", this.pos - 1);
                    literal.append('\\');
                    literal.append(c);
                    continue block20;
                }
                case '\"': 
                case '\'': {
                    if (c != quot || inTriplequote && !this.skipTripleQuote(quot)) {
                        literal.append(c);
                        continue block20;
                    }
                    this.setToken(TokenKind.STRING, literalStartPos, this.pos);
                    this.setValue(literal.toString());
                    return;
                }
            }
            literal.append(c);
        }
        this.error("unclosed string literal", literalStartPos);
        this.setToken(TokenKind.STRING, literalStartPos, this.pos);
        this.setValue(literal.toString());
    }

    private void stringLiteral(char quot, boolean isRaw) {
        int literalStartPos = isRaw ? this.pos - 2 : this.pos - 1;
        int contentStartPos = this.pos;
        if (this.skipTripleQuote(quot)) {
            this.pos -= 2;
            this.escapedStringLiteral(quot, isRaw);
            return;
        }
        while (this.pos < this.buffer.length) {
            char c = this.buffer[this.pos++];
            switch (c) {
                case '\n': {
                    this.error("unclosed string literal", literalStartPos);
                    this.setToken(TokenKind.STRING, literalStartPos, this.pos);
                    this.setValue(this.bufferSlice(contentStartPos, this.pos - 1));
                    return;
                }
                case '\\': {
                    if (isRaw) {
                        if (this.peek(0) == 13 && this.peek(1) == 10) {
                            this.pos = contentStartPos;
                            this.escapedStringLiteral(quot, true);
                            return;
                        }
                        ++this.pos;
                        break;
                    }
                    this.pos = contentStartPos;
                    this.escapedStringLiteral(quot, false);
                    return;
                }
                case '\"': 
                case '\'': {
                    if (c != quot) break;
                    this.setToken(TokenKind.STRING, literalStartPos, this.pos);
                    this.setValue(this.bufferSlice(contentStartPos, this.pos - 1));
                    return;
                }
            }
        }
        if (this.pos > this.buffer.length) {
            this.pos = this.buffer.length;
        }
        this.error("unclosed string literal", literalStartPos);
        this.setToken(TokenKind.STRING, literalStartPos, this.pos);
        this.setValue(this.bufferSlice(contentStartPos, this.pos));
    }

    private void identifierOrKeyword() {
        int oldPos = this.pos - 1;
        String id = identInterner.intern(this.scanIdentifier());
        TokenKind kind = keywordMap.get(id);
        if (kind == null) {
            this.setToken(TokenKind.IDENTIFIER, oldPos, this.pos);
            this.setValue(id);
        } else {
            this.setToken(kind, oldPos, this.pos);
        }
    }

    private String scanIdentifier() {
        int oldPos = this.pos - 1;
        block3: while (this.pos < this.buffer.length) {
            switch (this.buffer[this.pos]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    ++this.pos;
                    continue block3;
                }
            }
            return this.bufferSlice(oldPos, this.pos);
        }
        return this.bufferSlice(oldPos, this.pos);
    }

    private boolean tokenizeTwoChars() {
        if (this.pos + 2 >= this.buffer.length) {
            return false;
        }
        char c1 = this.buffer[this.pos];
        char c2 = this.buffer[this.pos + 1];
        TokenKind tok = null;
        if (c2 == '=') {
            tok = EQUAL_TOKENS.get(Character.valueOf(c1));
        } else if (c2 == '*' && c1 == '*') {
            tok = TokenKind.STAR_STAR;
        }
        if (tok == null) {
            return false;
        }
        this.setToken(tok, this.pos, this.pos + 2);
        return true;
    }

    private int peek(int i) {
        return this.pos + i < this.buffer.length ? this.buffer[this.pos + i] : -1;
    }

    private int next() {
        ++this.pos;
        return this.peek(0);
    }

    private void tokenize() {
        if (this.checkIndentation) {
            this.checkIndentation = false;
            this.computeIndentation();
        }
        if (this.dents != 0) {
            if (this.dents < 0) {
                ++this.dents;
                this.setToken(TokenKind.OUTDENT, this.pos - 1, this.pos);
            } else {
                --this.dents;
                this.setToken(TokenKind.INDENT, this.pos - 1, this.pos);
            }
            return;
        }
        this.kind = null;
        while (this.pos < this.buffer.length) {
            if (this.tokenizeTwoChars()) {
                this.pos += 2;
                return;
            }
            char c = this.buffer[this.pos];
            ++this.pos;
            switch (c) {
                case '{': {
                    this.setToken(TokenKind.LBRACE, this.pos - 1, this.pos);
                    ++this.openParenStackDepth;
                    break;
                }
                case '}': {
                    this.setToken(TokenKind.RBRACE, this.pos - 1, this.pos);
                    this.popParen();
                    break;
                }
                case '(': {
                    this.setToken(TokenKind.LPAREN, this.pos - 1, this.pos);
                    ++this.openParenStackDepth;
                    break;
                }
                case ')': {
                    this.setToken(TokenKind.RPAREN, this.pos - 1, this.pos);
                    this.popParen();
                    break;
                }
                case '[': {
                    this.setToken(TokenKind.LBRACKET, this.pos - 1, this.pos);
                    ++this.openParenStackDepth;
                    break;
                }
                case ']': {
                    this.setToken(TokenKind.RBRACKET, this.pos - 1, this.pos);
                    this.popParen();
                    break;
                }
                case '>': {
                    if (this.peek(0) == 62 && this.peek(1) == 61) {
                        this.setToken(TokenKind.GREATER_GREATER_EQUALS, this.pos - 1, this.pos + 2);
                        this.pos += 2;
                        break;
                    }
                    if (this.peek(0) == 62) {
                        this.setToken(TokenKind.GREATER_GREATER, this.pos - 1, this.pos + 1);
                        ++this.pos;
                        break;
                    }
                    this.setToken(TokenKind.GREATER, this.pos - 1, this.pos);
                    break;
                }
                case '<': {
                    if (this.peek(0) == 60 && this.peek(1) == 61) {
                        this.setToken(TokenKind.LESS_LESS_EQUALS, this.pos - 1, this.pos + 2);
                        this.pos += 2;
                        break;
                    }
                    if (this.peek(0) == 60) {
                        this.setToken(TokenKind.LESS_LESS, this.pos - 1, this.pos + 1);
                        ++this.pos;
                        break;
                    }
                    this.setToken(TokenKind.LESS, this.pos - 1, this.pos);
                    break;
                }
                case ':': {
                    this.setToken(TokenKind.COLON, this.pos - 1, this.pos);
                    break;
                }
                case ',': {
                    this.setToken(TokenKind.COMMA, this.pos - 1, this.pos);
                    break;
                }
                case '+': {
                    this.setToken(TokenKind.PLUS, this.pos - 1, this.pos);
                    break;
                }
                case '-': {
                    this.setToken(TokenKind.MINUS, this.pos - 1, this.pos);
                    break;
                }
                case '|': {
                    this.setToken(TokenKind.PIPE, this.pos - 1, this.pos);
                    break;
                }
                case '=': {
                    this.setToken(TokenKind.EQUALS, this.pos - 1, this.pos);
                    break;
                }
                case '%': {
                    this.setToken(TokenKind.PERCENT, this.pos - 1, this.pos);
                    break;
                }
                case '~': {
                    this.setToken(TokenKind.TILDE, this.pos - 1, this.pos);
                    break;
                }
                case '&': {
                    this.setToken(TokenKind.AMPERSAND, this.pos - 1, this.pos);
                    break;
                }
                case '^': {
                    this.setToken(TokenKind.CARET, this.pos - 1, this.pos);
                    break;
                }
                case '/': {
                    if (this.peek(0) == 47 && this.peek(1) == 61) {
                        this.setToken(TokenKind.SLASH_SLASH_EQUALS, this.pos - 1, this.pos + 2);
                        this.pos += 2;
                        break;
                    }
                    if (this.peek(0) == 47) {
                        this.setToken(TokenKind.SLASH_SLASH, this.pos - 1, this.pos + 1);
                        ++this.pos;
                        break;
                    }
                    this.setToken(TokenKind.SLASH, this.pos - 1, this.pos);
                    break;
                }
                case ';': {
                    this.setToken(TokenKind.SEMI, this.pos - 1, this.pos);
                    break;
                }
                case '*': {
                    this.setToken(TokenKind.STAR, this.pos - 1, this.pos);
                    break;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\\': {
                    if (this.peek(0) == 10) {
                        ++this.pos;
                        break;
                    }
                    if (this.peek(0) == 13 && this.peek(1) == 10) {
                        this.pos += 2;
                        break;
                    }
                    this.setToken(TokenKind.ILLEGAL, this.pos - 1, this.pos);
                    this.setValue(Character.toString(c));
                    break;
                }
                case '\n': {
                    this.newline();
                    break;
                }
                case '#': {
                    int oldPos = this.pos - 1;
                    while (this.pos < this.buffer.length && (c = this.buffer[this.pos]) != '\n') {
                        ++this.pos;
                    }
                    this.addComment(oldPos, this.pos);
                    break;
                }
                case '\"': 
                case '\'': {
                    this.stringLiteral(c, false);
                    break;
                }
                default: {
                    int c0;
                    if (c == 'r' && ((c0 = this.peek(0)) == 39 || c0 == 34)) {
                        ++this.pos;
                        this.stringLiteral((char)c0, true);
                        break;
                    }
                    if (c == '.' || Lexer.isdigit(c)) {
                        --this.pos;
                        this.scanNumberOrDot(c);
                        break;
                    }
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                        this.identifierOrKeyword();
                        break;
                    }
                    this.error("invalid character: '" + c + "'", this.pos - 1);
                }
            }
            if (this.kind == null) continue;
            return;
        }
        if (this.indentStack.size() > 1) {
            this.setToken(TokenKind.NEWLINE, this.pos - 1, this.pos);
            while (this.indentStack.size() > 1) {
                this.indentStack.pop();
                --this.dents;
            }
            return;
        }
        this.setToken(TokenKind.EOF, this.pos, this.pos);
    }

    private void scanNumberOrDot(int c) {
        int start = this.pos++;
        boolean fraction = false;
        boolean exponent = false;
        if (c == 46) {
            if (!Lexer.isdigit(this.peek(1))) {
                this.setToken(TokenKind.DOT, start, this.pos);
                return;
            }
            fraction = true;
        } else if (c == 48) {
            c = this.next();
            if (c == 46) {
                fraction = true;
            } else if (c == 120 || c == 88) {
                c = this.next();
                if (!Lexer.isxdigit(c)) {
                    this.error("invalid hex literal", start);
                }
                while (Lexer.isxdigit(c)) {
                    c = this.next();
                }
            } else if (c == 111 || c == 79) {
                c = this.next();
                while (Lexer.isdigit(c)) {
                    c = this.next();
                }
            } else if (c == 98 || c == 66) {
                c = this.next();
                if (!Lexer.isbdigit(c)) {
                    this.error("invalid binary literal", start);
                }
                while (Lexer.isbdigit(c)) {
                    c = this.next();
                }
            } else {
                while (Lexer.isdigit(c)) {
                    c = this.next();
                }
                if (c == 46) {
                    fraction = true;
                } else if (c == 101 || c == 69) {
                    exponent = true;
                }
            }
        } else {
            while (Lexer.isdigit(c)) {
                c = this.next();
            }
            if (c == 46) {
                fraction = true;
            } else if (c == 101 || c == 69) {
                exponent = true;
            }
        }
        if (fraction) {
            c = this.next();
            while (Lexer.isdigit(c)) {
                c = this.next();
            }
            if (c == 101 || c == 69) {
                exponent = true;
            }
        }
        if (exponent) {
            c = this.next();
            if (c == 43 || c == 45) {
                c = this.next();
            }
            while (Lexer.isdigit(c)) {
                c = this.next();
            }
        }
        if (fraction || exponent) {
            this.setToken(TokenKind.FLOAT, start, this.pos);
            double value = 0.0;
            try {
                value = Double.parseDouble(this.bufferSlice(start, this.pos));
                if (!Double.isFinite(value)) {
                    this.error("floating-point literal too large", start);
                }
            }
            catch (NumberFormatException ex) {
                this.error("invalid float literal", start);
            }
            this.setValue(value);
            return;
        }
        this.setToken(TokenKind.INT, start, this.pos);
        String literal = this.bufferSlice(start, this.pos);
        Number value = 0;
        try {
            value = IntLiteral.scan(literal);
        }
        catch (NumberFormatException ex) {
            this.error(ex.getMessage(), start);
        }
        this.setValue(value);
    }

    private static boolean isdigit(int c) {
        return 48 <= c && c <= 57;
    }

    private static boolean isxdigit(int c) {
        return Lexer.isdigit(c) || 65 <= c && c <= 70 || 97 <= c && c <= 102;
    }

    private static boolean isbdigit(int c) {
        return c == 48 || c == 49;
    }

    String bufferSlice(int start, int end) {
        return new String(this.buffer, start, end - start);
    }

    private void addComment(int start, int end) {
        String content = this.bufferSlice(start, end);
        this.comments.add((Object)new Comment(this.locs, start, content));
    }

    static {
        keywordMap.put("and", TokenKind.AND);
        keywordMap.put("as", TokenKind.AS);
        keywordMap.put("assert", TokenKind.ASSERT);
        keywordMap.put("break", TokenKind.BREAK);
        keywordMap.put("class", TokenKind.CLASS);
        keywordMap.put("continue", TokenKind.CONTINUE);
        keywordMap.put("def", TokenKind.DEF);
        keywordMap.put("del", TokenKind.DEL);
        keywordMap.put("elif", TokenKind.ELIF);
        keywordMap.put("else", TokenKind.ELSE);
        keywordMap.put("except", TokenKind.EXCEPT);
        keywordMap.put("finally", TokenKind.FINALLY);
        keywordMap.put("for", TokenKind.FOR);
        keywordMap.put("from", TokenKind.FROM);
        keywordMap.put("global", TokenKind.GLOBAL);
        keywordMap.put("if", TokenKind.IF);
        keywordMap.put("import", TokenKind.IMPORT);
        keywordMap.put("in", TokenKind.IN);
        keywordMap.put("is", TokenKind.IS);
        keywordMap.put("lambda", TokenKind.LAMBDA);
        keywordMap.put("load", TokenKind.LOAD);
        keywordMap.put("nonlocal", TokenKind.NONLOCAL);
        keywordMap.put("not", TokenKind.NOT);
        keywordMap.put("or", TokenKind.OR);
        keywordMap.put("pass", TokenKind.PASS);
        keywordMap.put("raise", TokenKind.RAISE);
        keywordMap.put("return", TokenKind.RETURN);
        keywordMap.put("try", TokenKind.TRY);
        keywordMap.put("while", TokenKind.WHILE);
        keywordMap.put("with", TokenKind.WITH);
        keywordMap.put("yield", TokenKind.YIELD);
    }
}

