/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.NodeVisitor;

public final class IndexExpression
extends Expression {
    private final Expression object;
    private final int lbracketOffset;
    private final Expression key;
    private final int rbracketOffset;

    IndexExpression(FileLocations locs, Expression object, int lbracketOffset, Expression key, int rbracketOffset) {
        super(locs, Expression.Kind.INDEX);
        this.object = object;
        this.lbracketOffset = lbracketOffset;
        this.key = key;
        this.rbracketOffset = rbracketOffset;
    }

    public Expression getObject() {
        return this.object;
    }

    public Expression getKey() {
        return this.key;
    }

    @Override
    public int getStartOffset() {
        return this.object.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.rbracketOffset + 1;
    }

    public Location getLbracketLocation() {
        return this.locs.getLocation(this.lbracketOffset);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

