/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.TokenKind;

public final class IfStatement
extends Statement {
    private final TokenKind token;
    private final int ifOffset;
    private final Expression condition;
    private final ImmutableList<Statement> thenBlock;
    @Nullable
    ImmutableList<Statement> elseBlock;

    IfStatement(FileLocations locs, TokenKind token, int ifOffset, Expression condition, List<Statement> thenBlock) {
        super(locs, Statement.Kind.IF);
        this.token = token;
        this.ifOffset = ifOffset;
        this.condition = condition;
        this.thenBlock = ImmutableList.copyOf(thenBlock);
    }

    public boolean isElif() {
        return this.token == TokenKind.ELIF;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public ImmutableList<Statement> getThenBlock() {
        return this.thenBlock;
    }

    @Nullable
    public ImmutableList<Statement> getElseBlock() {
        return this.elseBlock;
    }

    void setElseBlock(ImmutableList<Statement> elseBlock) {
        this.elseBlock = elseBlock;
    }

    @Override
    public int getStartOffset() {
        return this.ifOffset;
    }

    @Override
    public int getEndOffset() {
        ImmutableList<Statement> body = this.elseBlock != null ? this.elseBlock : this.thenBlock;
        return body.isEmpty() ? this.condition.getEndOffset() : ((Statement)body.get(body.size() - 1)).getEndOffset();
    }

    @Override
    public String toString() {
        return String.format("if %s: ...\n", this.condition);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

