/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.ListExpression;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Resolver;

public final class Identifier
extends Expression {
    private final String name;
    private final int nameOffset;
    @Nullable
    private Resolver.Binding binding;

    Identifier(FileLocations locs, String name, int nameOffset) {
        super(locs, Expression.Kind.IDENTIFIER);
        this.name = name;
        this.nameOffset = nameOffset;
    }

    @Override
    public int getStartOffset() {
        return this.nameOffset;
    }

    @Override
    public int getEndOffset() {
        return this.nameOffset + this.name.length();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrivate() {
        return this.name.startsWith("_");
    }

    @Nullable
    public Resolver.Binding getBinding() {
        return this.binding;
    }

    void setBinding(Resolver.Binding bind) {
        Preconditions.checkState(this.binding == null);
        this.binding = bind;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public static boolean isValid(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || i > 0 && '0' <= c && c <= '9' || c == '_') continue;
            return false;
        }
        return !name.isEmpty();
    }

    public static ImmutableSet<Identifier> boundIdentifiers(Expression expr) {
        if (expr instanceof Identifier) {
            return ImmutableSet.of((Identifier)expr);
        }
        ImmutableSet.Builder<Identifier> result = ImmutableSet.builder();
        Identifier.collectBoundIdentifiers(expr, result);
        return result.build();
    }

    private static void collectBoundIdentifiers(Expression lhs, ImmutableSet.Builder<Identifier> result) {
        if (lhs instanceof Identifier) {
            result.add((Object)((Identifier)lhs));
            return;
        }
        if (lhs instanceof ListExpression) {
            ListExpression variables = (ListExpression)lhs;
            for (Expression expression : variables.getElements()) {
                Identifier.collectBoundIdentifiers(expression, result);
            }
        }
    }
}

