/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.NodeVisitor;

public final class FloatLiteral
extends Expression {
    private final String raw;
    private final int tokenOffset;
    private final double value;

    FloatLiteral(FileLocations locs, String raw, int tokenOffset, double value) {
        super(locs, Expression.Kind.FLOAT_LITERAL);
        this.raw = raw;
        this.tokenOffset = tokenOffset;
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public String getRaw() {
        return this.raw;
    }

    @Override
    public int getStartOffset() {
        return this.tokenOffset;
    }

    @Override
    public int getEndOffset() {
        return this.tokenOffset + this.raw.length();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

