/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.NodeVisitor;

public final class DictExpression
extends Expression {
    private final int lbraceOffset;
    private final ImmutableList<Entry> entries;
    private final int rbraceOffset;

    DictExpression(FileLocations locs, int lbraceOffset, List<Entry> entries, int rbraceOffset) {
        super(locs, Expression.Kind.DICT_EXPR);
        this.lbraceOffset = lbraceOffset;
        this.entries = ImmutableList.copyOf(entries);
        this.rbraceOffset = rbraceOffset;
    }

    @Override
    public int getStartOffset() {
        return this.lbraceOffset;
    }

    @Override
    public int getEndOffset() {
        return this.rbraceOffset + 1;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public ImmutableList<Entry> getEntries() {
        return this.entries;
    }

    public static final class Entry
    extends Node {
        private final Expression key;
        private final int colonOffset;
        private final Expression value;

        Entry(FileLocations locs, Expression key, int colonOffset, Expression value) {
            super(locs);
            this.key = key;
            this.colonOffset = colonOffset;
            this.value = value;
        }

        public Expression getKey() {
            return this.key;
        }

        public Expression getValue() {
            return this.value;
        }

        @Override
        public int getStartOffset() {
            return this.key.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.value.getEndOffset();
        }

        public Location getColonLocation() {
            return this.locs.getLocation(this.colonOffset);
        }

        @Override
        public void accept(NodeVisitor visitor) {
            visitor.visit(this);
        }
    }
}

