/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.NodePrinter;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Parameter;
import net.starlark.java.syntax.Resolver;
import net.starlark.java.syntax.Statement;

public final class DefStatement
extends Statement {
    private final int defOffset;
    private final Identifier identifier;
    private final ImmutableList<Statement> body;
    private final ImmutableList<Parameter> parameters;
    @Nullable
    private Resolver.Function resolved;

    DefStatement(FileLocations locs, int defOffset, Identifier identifier, ImmutableList<Parameter> parameters, ImmutableList<Statement> body) {
        super(locs, Statement.Kind.DEF);
        this.defOffset = defOffset;
        this.identifier = identifier;
        this.parameters = Preconditions.checkNotNull(parameters);
        this.body = Preconditions.checkNotNull(body);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        new NodePrinter(buf).printDefSignature(this);
        buf.append(" ...\n");
        return buf.toString();
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public ImmutableList<Statement> getBody() {
        return this.body;
    }

    public ImmutableList<Parameter> getParameters() {
        return this.parameters;
    }

    void setResolvedFunction(Resolver.Function resolved) {
        this.resolved = resolved;
    }

    @Nullable
    public Resolver.Function getResolvedFunction() {
        return this.resolved;
    }

    @Override
    public int getStartOffset() {
        return this.defOffset;
    }

    @Override
    public int getEndOffset() {
        return this.body.isEmpty() ? this.identifier.getEndOffset() : ((Statement)this.body.get(this.body.size() - 1)).getEndOffset();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

