/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.collect.ImmutableList;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.NodeVisitor;

public final class Comprehension
extends Expression {
    private final boolean isDict;
    private final int lbracketOffset;
    private final Node body;
    private final ImmutableList<Clause> clauses;
    private final int rbracketOffset;

    Comprehension(FileLocations locs, boolean isDict, int lbracketOffset, Node body, ImmutableList<Clause> clauses, int rbracketOffset) {
        super(locs, Expression.Kind.COMPREHENSION);
        this.isDict = isDict;
        this.lbracketOffset = lbracketOffset;
        this.body = body;
        this.clauses = clauses;
        this.rbracketOffset = rbracketOffset;
    }

    public boolean isDict() {
        return this.isDict;
    }

    public Node getBody() {
        return this.body;
    }

    public ImmutableList<Clause> getClauses() {
        return this.clauses;
    }

    @Override
    public int getStartOffset() {
        return this.lbracketOffset;
    }

    @Override
    public int getEndOffset() {
        return this.rbracketOffset + 1;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public static final class If
    extends Clause {
        private final int ifOffset;
        private final Expression condition;

        If(FileLocations locs, int ifOffset, Expression condition) {
            super(locs);
            this.ifOffset = ifOffset;
            this.condition = condition;
        }

        public Expression getCondition() {
            return this.condition;
        }

        @Override
        public int getStartOffset() {
            return this.ifOffset;
        }

        @Override
        public int getEndOffset() {
            return this.condition.getEndOffset();
        }

        @Override
        public void accept(NodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static final class For
    extends Clause {
        private final int forOffset;
        private final Expression vars;
        private final Expression iterable;

        For(FileLocations locs, int forOffset, Expression vars, Expression iterable) {
            super(locs);
            this.forOffset = forOffset;
            this.vars = vars;
            this.iterable = iterable;
        }

        public Expression getVars() {
            return this.vars;
        }

        public Expression getIterable() {
            return this.iterable;
        }

        @Override
        public int getStartOffset() {
            return this.forOffset;
        }

        @Override
        public int getEndOffset() {
            return this.iterable.getEndOffset();
        }

        @Override
        public void accept(NodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static abstract class Clause
    extends Node {
        Clause(FileLocations locs) {
            super(locs);
        }
    }
}

