/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import net.starlark.java.syntax.Argument;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.ListExpression;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.NodeVisitor;

public final class CallExpression
extends Expression {
    private final Expression function;
    private final Location lparenLocation;
    private final ImmutableList<Argument> arguments;
    private final int rparenOffset;
    private final int numPositionalArgs;

    CallExpression(FileLocations locs, Expression function, Location lparenLocation, ImmutableList<Argument> arguments, int rparenOffset) {
        super(locs, Expression.Kind.CALL);
        this.function = Preconditions.checkNotNull(function);
        this.lparenLocation = lparenLocation;
        this.arguments = arguments;
        this.rparenOffset = rparenOffset;
        int n = 0;
        for (Argument arg : arguments) {
            if (!(arg instanceof Argument.Positional)) continue;
            ++n;
        }
        this.numPositionalArgs = n;
    }

    public Expression getFunction() {
        return this.function;
    }

    public int getNumPositionalArguments() {
        return this.numPositionalArgs;
    }

    public ImmutableList<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public int getStartOffset() {
        return this.function.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.rparenOffset + 1;
    }

    public Location getLparenLocation() {
        return this.lparenLocation;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.function);
        buf.append('(');
        ListExpression.appendNodes(buf, this.arguments);
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

