/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import net.starlark.java.syntax.FileOptions;

final class AutoValue_FileOptions
extends FileOptions {
    private final boolean allowLoadPrivateSymbols;
    private final boolean allowToplevelRebinding;
    private final boolean loadBindsGlobally;
    private final boolean requireLoadStatementsFirst;

    private AutoValue_FileOptions(boolean allowLoadPrivateSymbols, boolean allowToplevelRebinding, boolean loadBindsGlobally, boolean requireLoadStatementsFirst) {
        this.allowLoadPrivateSymbols = allowLoadPrivateSymbols;
        this.allowToplevelRebinding = allowToplevelRebinding;
        this.loadBindsGlobally = loadBindsGlobally;
        this.requireLoadStatementsFirst = requireLoadStatementsFirst;
    }

    @Override
    public boolean allowLoadPrivateSymbols() {
        return this.allowLoadPrivateSymbols;
    }

    @Override
    public boolean allowToplevelRebinding() {
        return this.allowToplevelRebinding;
    }

    @Override
    public boolean loadBindsGlobally() {
        return this.loadBindsGlobally;
    }

    @Override
    public boolean requireLoadStatementsFirst() {
        return this.requireLoadStatementsFirst;
    }

    public String toString() {
        return "FileOptions{allowLoadPrivateSymbols=" + this.allowLoadPrivateSymbols + ", allowToplevelRebinding=" + this.allowToplevelRebinding + ", loadBindsGlobally=" + this.loadBindsGlobally + ", requireLoadStatementsFirst=" + this.requireLoadStatementsFirst + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FileOptions) {
            FileOptions that = (FileOptions)o;
            return this.allowLoadPrivateSymbols == that.allowLoadPrivateSymbols() && this.allowToplevelRebinding == that.allowToplevelRebinding() && this.loadBindsGlobally == that.loadBindsGlobally() && this.requireLoadStatementsFirst == that.requireLoadStatementsFirst();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.allowLoadPrivateSymbols ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.allowToplevelRebinding ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.loadBindsGlobally ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.requireLoadStatementsFirst ? 1231 : 1237;
    }

    @Override
    public FileOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FileOptions.Builder {
        private Boolean allowLoadPrivateSymbols;
        private Boolean allowToplevelRebinding;
        private Boolean loadBindsGlobally;
        private Boolean requireLoadStatementsFirst;

        Builder() {
        }

        private Builder(FileOptions source) {
            this.allowLoadPrivateSymbols = source.allowLoadPrivateSymbols();
            this.allowToplevelRebinding = source.allowToplevelRebinding();
            this.loadBindsGlobally = source.loadBindsGlobally();
            this.requireLoadStatementsFirst = source.requireLoadStatementsFirst();
        }

        @Override
        public FileOptions.Builder allowLoadPrivateSymbols(boolean allowLoadPrivateSymbols) {
            this.allowLoadPrivateSymbols = allowLoadPrivateSymbols;
            return this;
        }

        @Override
        public FileOptions.Builder allowToplevelRebinding(boolean allowToplevelRebinding) {
            this.allowToplevelRebinding = allowToplevelRebinding;
            return this;
        }

        @Override
        public FileOptions.Builder loadBindsGlobally(boolean loadBindsGlobally) {
            this.loadBindsGlobally = loadBindsGlobally;
            return this;
        }

        @Override
        public FileOptions.Builder requireLoadStatementsFirst(boolean requireLoadStatementsFirst) {
            this.requireLoadStatementsFirst = requireLoadStatementsFirst;
            return this;
        }

        @Override
        public FileOptions build() {
            if (this.allowLoadPrivateSymbols == null || this.allowToplevelRebinding == null || this.loadBindsGlobally == null || this.requireLoadStatementsFirst == null) {
                StringBuilder missing = new StringBuilder();
                if (this.allowLoadPrivateSymbols == null) {
                    missing.append(" allowLoadPrivateSymbols");
                }
                if (this.allowToplevelRebinding == null) {
                    missing.append(" allowToplevelRebinding");
                }
                if (this.loadBindsGlobally == null) {
                    missing.append(" loadBindsGlobally");
                }
                if (this.requireLoadStatementsFirst == null) {
                    missing.append(" requireLoadStatementsFirst");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FileOptions(this.allowLoadPrivateSymbols, this.allowToplevelRebinding, this.loadBindsGlobally, this.requireLoadStatementsFirst);
        }
    }
}

