/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import javax.annotation.Nullable;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.TokenKind;

public final class AssignmentStatement
extends Statement {
    private final Expression lhs;
    @Nullable
    private final TokenKind op;
    private final int opOffset;
    private final Expression rhs;

    AssignmentStatement(FileLocations locs, Expression lhs, @Nullable TokenKind op, int opOffset, Expression rhs) {
        super(locs, Statement.Kind.ASSIGNMENT);
        this.lhs = lhs;
        this.op = op;
        this.opOffset = opOffset;
        this.rhs = rhs;
    }

    public Expression getLHS() {
        return this.lhs;
    }

    @Nullable
    public TokenKind getOperator() {
        return this.op;
    }

    public Location getOperatorLocation() {
        return this.locs.getLocation(this.opOffset);
    }

    @Override
    public int getStartOffset() {
        return this.lhs.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.rhs.getEndOffset();
    }

    public boolean isAugmented() {
        return this.op != null;
    }

    public Expression getRHS() {
        return this.rhs;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

