/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.NodeVisitor;

public abstract class Argument
extends Node {
    protected final Expression value;

    Argument(FileLocations locs, Expression value) {
        super(locs);
        this.value = Preconditions.checkNotNull(value);
    }

    public final Expression getValue() {
        return this.value;
    }

    @Override
    public int getEndOffset() {
        return this.value.getEndOffset();
    }

    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public static final class StarStar
    extends Argument {
        private final int starStarOffset;

        StarStar(FileLocations locs, int starStarOffset, Expression value) {
            super(locs, value);
            this.starStarOffset = starStarOffset;
        }

        @Override
        public int getStartOffset() {
            return this.starStarOffset;
        }
    }

    public static final class Star
    extends Argument {
        private final int starOffset;

        Star(FileLocations locs, int starOffset, Expression value) {
            super(locs, value);
            this.starOffset = starOffset;
        }

        @Override
        public int getStartOffset() {
            return this.starOffset;
        }
    }

    public static final class Keyword
    extends Argument {
        final Identifier id;

        Keyword(FileLocations locs, Identifier id, Expression value) {
            super(locs, value);
            this.id = id;
        }

        public Identifier getIdentifier() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.id.getName();
        }

        @Override
        public int getStartOffset() {
            return this.id.getStartOffset();
        }
    }

    public static final class Positional
    extends Argument {
        Positional(FileLocations locs, Expression value) {
            super(locs, value);
        }

        @Override
        public int getStartOffset() {
            return this.value.getStartOffset();
        }
    }
}

