/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.spelling;

import javax.annotation.Nullable;

public final class SpellChecker {
    public static int editDistance(String s1, String s2, int maxEditDistance) {
        int i;
        if (s1.equals(s2)) {
            return 0;
        }
        if (Math.abs(s1.length() - s2.length()) > maxEditDistance) {
            return -1;
        }
        int[] row = new int[s2.length() + 1];
        for (i = 0; i <= s2.length(); ++i) {
            row[i] = i;
        }
        for (i = 1; i <= s1.length(); ++i) {
            row[0] = i;
            int bestInTheRow = row[0];
            int previous = i - 1;
            for (int j = 1; j <= s2.length(); ++j) {
                int old = row[j];
                row[j] = Math.min(previous + (s1.charAt(i - 1) == s2.charAt(j - 1) ? 0 : 1), 1 + Math.min(row[j - 1], row[j]));
                previous = old;
                bestInTheRow = Math.min(bestInTheRow, row[j]);
            }
            if (bestInTheRow <= maxEditDistance) continue;
            return -1;
        }
        int result = row[s2.length()];
        return result <= maxEditDistance ? result : -1;
    }

    @Nullable
    public static String suggest(String input, Iterable<String> words) {
        String best = null;
        int bestDistance = Math.min(5, (input.length() + 1) / 2);
        input = input.toLowerCase();
        for (String candidate : words) {
            int d = SpellChecker.editDistance(input, candidate.toLowerCase(), bestDistance);
            if (d < 0 || d >= bestDistance) continue;
            bestDistance = d;
            best = candidate;
        }
        return best;
    }

    public static String didYouMean(String input, Iterable<String> words) {
        String suggestion = SpellChecker.suggest(input, words);
        if (suggestion == null) {
            return "";
        }
        return " (did you mean '" + suggestion + "'?)";
    }
}

