/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.RegularTuple;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.SingletonTuple;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;

@StarlarkBuiltin(name="tuple", category="core", doc="The built-in tuple type. Example tuple expressions:<br><pre class=language-python>x = (1, 2, 3)</pre>Accessing elements is possible using indexing (starts from <code>0</code>):<br><pre class=language-python>e = x[1]   # e == 2</pre>Lists support the <code>+</code> operator to concatenate two tuples. Example:<br><pre class=language-python>x = (1, 2) + (3, 4)   # x == (1, 2, 3, 4)\nx = (\"a\", \"b\")\nx += (\"c\",)            # x == (\"a\", \"b\", \"c\")</pre>Similar to lists, tuples support slice operations:<pre class=language-python>('a', 'b', 'c', 'd')[1:3]   # ('b', 'c')\n('a', 'b', 'c', 'd')[::2]  # ('a', 'c')\n('a', 'b', 'c', 'd')[3:0:-1]  # ('d', 'c', 'b')</pre>Tuples are immutable, therefore <code>x[1] = \"a\"</code> is not supported.")
public abstract class Tuple
extends AbstractList<Object>
implements Sequence<Object>,
Comparable<Tuple> {
    private static final Tuple EMPTY = new RegularTuple(new Object[0]);

    Tuple() {
    }

    public static Tuple empty() {
        return EMPTY;
    }

    static Tuple wrap(Object[] array) {
        switch (array.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return new SingletonTuple(array[0]);
            }
        }
        return new RegularTuple(array);
    }

    public static Tuple copyOf(Iterable<?> seq) {
        if (seq instanceof Tuple) {
            return (Tuple)seq;
        }
        return Tuple.wrap(Iterables.toArray(seq, Object.class));
    }

    public static Tuple of(Object ... elems) {
        return Tuple.wrap(Arrays.copyOf(elems, elems.length));
    }

    public static Tuple pair(Object a, Object b) {
        return Tuple.wrap(new Object[]{a, b});
    }

    public static Tuple triple(Object a, Object b, Object c) {
        return Tuple.wrap(new Object[]{a, b, c});
    }

    public static Tuple concat(Tuple x, Tuple y) {
        Object[] objectArray;
        Object[] xelems;
        Object[] objectArray2;
        if (x.isEmpty()) {
            return y;
        }
        if (y.isEmpty()) {
            return x;
        }
        if (x instanceof SingletonTuple) {
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = ((SingletonTuple)x).elem;
        } else {
            objectArray2 = xelems = ((RegularTuple)x).elems;
        }
        if (y instanceof SingletonTuple) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = ((SingletonTuple)y).elem;
        } else {
            objectArray = ((RegularTuple)y).elems;
        }
        Object[] yelems = objectArray;
        return Tuple.wrap(ObjectArrays.concat(xelems, yelems, Object.class));
    }

    @Override
    public int compareTo(Tuple that) {
        return Sequence.compare(this, that);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof Tuple && Sequence.sameElems(this, (Tuple)that);
    }

    @Override
    public String toString() {
        return Starlark.repr(this);
    }

    static <T> ImmutableList<T> wrapImmutable(final Object[] array) {
        return ImmutableList.copyOf(new AbstractCollection<T>(){

            @Override
            public Object[] toArray() {
                return array;
            }

            @Override
            public int size() {
                return array.length;
            }

            @Override
            public Iterator<T> iterator() {
                throw new UnsupportedOperationException();
            }
        });
    }

    abstract Tuple repeat(StarlarkInt var1) throws EvalException;
}

