/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.Eval;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.eval.Tuple;
import net.starlark.java.spelling.SpellChecker;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.Resolver;

@StarlarkBuiltin(name="function", category="core", doc="The type of functions declared in Starlark.")
public final class StarlarkFunction
implements StarlarkCallable {
    final Resolver.Function rfn;
    private final Module module;
    final int[] globalIndex;
    private final Tuple defaultValues;
    private final Tuple freevars;
    static final Object MANDATORY = new Mandatory();

    StarlarkFunction(Resolver.Function rfn, Module module, int[] globalIndex, Tuple defaultValues, Tuple freevars) {
        this.rfn = rfn;
        this.module = module;
        this.globalIndex = globalIndex;
        this.defaultValues = defaultValues;
        this.freevars = freevars;
    }

    void setGlobal(int progIndex, Object value) {
        this.module.setGlobalByIndex(this.globalIndex[progIndex], value);
    }

    @Nullable
    Object getGlobal(int progIndex) {
        return this.module.getGlobalByIndex(this.globalIndex[progIndex]);
    }

    boolean isToplevel() {
        return this.rfn.isToplevel();
    }

    @Nullable
    public Object getDefaultValue(int i) {
        if (i < 0 || i >= this.rfn.getParameters().size()) {
            throw new IndexOutOfBoundsException();
        }
        int nparams = this.rfn.getParameters().size() - (this.rfn.hasKwargs() ? 1 : 0) - (this.rfn.hasVarargs() ? 1 : 0);
        int prefix = nparams - this.defaultValues.size();
        if (i < prefix) {
            return null;
        }
        if (i < nparams) {
            Object v = this.defaultValues.get(i - prefix);
            return v == MANDATORY ? null : v;
        }
        return null;
    }

    public ImmutableList<String> getParameterNames() {
        return this.rfn.getParameterNames();
    }

    public boolean hasVarargs() {
        return this.rfn.hasVarargs();
    }

    public boolean hasKwargs() {
        return this.rfn.hasKwargs();
    }

    @Override
    public Location getLocation() {
        return this.rfn.getLocation();
    }

    @Override
    public String getName() {
        return this.rfn.getName();
    }

    @Nullable
    public String getDocumentation() {
        return this.rfn.getDocumentation();
    }

    public Module getModule() {
        return this.module;
    }

    @Override
    public Object fastcall(StarlarkThread thread, Object[] positional, Object[] named) throws EvalException, InterruptedException {
        if (!thread.isRecursionAllowed() && thread.isRecursiveCall(this)) {
            throw Starlark.errorf("function '%s' called recursively", this.getName());
        }
        StarlarkThread.Frame fr = thread.frame(0);
        fr.locals = this.processArgs(thread.mutability(), positional, named);
        for (int index : this.rfn.getCellIndices()) {
            fr.locals[index] = new Cell(fr.locals[index]);
        }
        return Eval.execFunctionBody(fr, this.rfn.getBody());
    }

    Cell getFreeVar(int index) {
        return (Cell)this.freevars.get(index);
    }

    @Override
    public void repr(Printer printer) {
        Object clientData = this.module.getClientData();
        printer.append("<function " + this.getName());
        if (clientData != null) {
            printer.append(" from " + clientData);
        }
        printer.append(">");
    }

    private Object[] processArgs(Mutability mu, Object[] positional, Object[] named) throws EvalException {
        ImmutableList<String> names = this.rfn.getParameterNames();
        Object[] locals = new Object[this.rfn.getLocals().size()];
        int n = positional.length;
        int nparams = this.rfn.getParameters().size() - (this.rfn.hasKwargs() ? 1 : 0) - (this.rfn.hasVarargs() ? 1 : 0);
        int numPositionalParams = nparams - this.rfn.numKeywordOnlyParams();
        if (n > numPositionalParams) {
            if (!this.rfn.hasVarargs()) {
                if (numPositionalParams > 0) {
                    throw Starlark.errorf("%s() accepts no more than %d positional argument%s but got %d", this.getName(), numPositionalParams, StarlarkFunction.plural(numPositionalParams), n);
                }
                throw Starlark.errorf("%s() does not accept positional arguments, but got %d", this.getName(), n);
            }
            n = numPositionalParams;
        }
        for (int i = 0; i < n; ++i) {
            locals[i] = positional[i];
        }
        if (this.rfn.hasVarargs()) {
            locals[nparams] = Tuple.wrap(Arrays.copyOfRange(positional, n, positional.length));
        }
        ArrayList<String> unexpected = null;
        LinkedHashMap<String, Object> kwargs = null;
        if (this.rfn.hasKwargs()) {
            kwargs = new LinkedHashMap<String, Object>();
        }
        for (int i = 0; i < named.length; i += 2) {
            String keyword = (String)named[i];
            Object value = named[i + 1];
            int pos = names.indexOf(keyword);
            if (0 <= pos && pos < nparams) {
                if (locals[pos] != null) {
                    throw Starlark.errorf("%s() got multiple values for parameter '%s'", this.getName(), keyword);
                }
                locals[pos] = value;
                continue;
            }
            if (kwargs != null) {
                if (kwargs.put(keyword, value) == null) continue;
                throw Starlark.errorf("%s() got multiple values for keyword argument '%s'", this.getName(), keyword);
            }
            if (unexpected == null) {
                unexpected = new ArrayList<String>();
            }
            unexpected.add(keyword);
        }
        if (unexpected != null) {
            throw Starlark.errorf("%s() got unexpected keyword argument%s: %s%s", this.getName(), StarlarkFunction.plural(unexpected.size()), Joiner.on(", ").join((Iterable<? extends Object>)unexpected), unexpected.size() == 1 ? SpellChecker.didYouMean((String)unexpected.get(0), names.subList(0, nparams)) : "");
        }
        if (kwargs != null) {
            locals[this.rfn.getParameters().size() - 1] = Dict.wrap(mu, kwargs);
        }
        int m4 = nparams - this.defaultValues.size();
        ArrayList<String> missingPositional = null;
        ArrayList<String> missingKwonly = null;
        for (int i = n; i < nparams; ++i) {
            Object dflt;
            if (locals[i] != null) continue;
            if (i >= m4 && (dflt = this.defaultValues.get(i - m4)) != MANDATORY) {
                locals[i] = dflt;
                continue;
            }
            if (i < numPositionalParams) {
                if (missingPositional == null) {
                    missingPositional = new ArrayList<String>();
                }
                missingPositional.add((String)names.get(i));
                continue;
            }
            if (missingKwonly == null) {
                missingKwonly = new ArrayList<String>();
            }
            missingKwonly.add((String)names.get(i));
        }
        if (missingPositional != null) {
            throw Starlark.errorf("%s() missing %d required positional argument%s: %s", this.getName(), missingPositional.size(), StarlarkFunction.plural(missingPositional.size()), Joiner.on(", ").join(missingPositional));
        }
        if (missingKwonly != null) {
            throw Starlark.errorf("%s() missing %d required keyword-only argument%s: %s", this.getName(), missingKwonly.size(), StarlarkFunction.plural(missingKwonly.size()), Joiner.on(", ").join(missingKwonly));
        }
        return locals;
    }

    private static String plural(int n) {
        return n == 1 ? "" : "s";
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getName());
        out.append('(');
        String sep = "";
        for (String param : this.getParameterNames()) {
            out.append(sep).append(param);
            sep = ", ";
        }
        out.append(')');
        return out.toString();
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    static final class Cell
    implements StarlarkValue {
        Object x;

        Cell(Object x) {
            this.x = x;
        }
    }

    private static class Mandatory
    implements StarlarkValue {
        private Mandatory() {
        }
    }
}

