/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import java.math.BigInteger;
import java.util.Locale;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkValue;

@StarlarkBuiltin(name="float", category="core", doc="The type of floating-point numbers in Starlark.")
public final class StarlarkFloat
implements StarlarkValue,
Comparable<StarlarkFloat> {
    private final double v;
    private static final int EXPONENT_MASK = 2047;

    private StarlarkFloat(double v) {
        this.v = v;
    }

    public static StarlarkFloat of(double v) {
        return new StarlarkFloat(v);
    }

    public double toDouble() {
        return this.v;
    }

    public String toString() {
        return StarlarkFloat.format(this.v, 'g');
    }

    @Override
    public void repr(Printer printer) {
        printer.append(this.toString());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean truth() {
        return this.v != 0.0;
    }

    @Override
    public int compareTo(StarlarkFloat that) {
        double x = this.v;
        double y = that.v;
        if (x > y) {
            return 1;
        }
        if (x < y) {
            return -1;
        }
        if (x == y) {
            return 0;
        }
        long xbits = Double.doubleToLongBits(x);
        long ybits = Double.doubleToLongBits(y);
        return Long.compare(xbits, ybits);
    }

    public int hashCode() {
        if (Double.isFinite(this.v) && this.v == Math.rint(this.v)) {
            return StarlarkInt.ofFiniteDouble(this.v).hashCode();
        }
        long bits = Double.doubleToLongBits(this.v);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object that) {
        return that instanceof StarlarkFloat && StarlarkFloat.equal(this.v, ((StarlarkFloat)that).v) || that instanceof StarlarkInt && StarlarkInt.intEqualsFloat((StarlarkInt)that, this);
    }

    private static boolean equal(double x, double y) {
        return x == y || Double.isNaN(x) && Double.isNaN(y);
    }

    static String format(double v, char conv) {
        Object s2;
        if (!Double.isFinite(v)) {
            if (v == Double.POSITIVE_INFINITY) {
                return "+inf";
            }
            if (v == Double.NEGATIVE_INFINITY) {
                return "-inf";
            }
            return "nan";
        }
        switch (conv) {
            case 'e': {
                s2 = String.format(Locale.US, "%e", v);
                break;
            }
            case 'E': {
                s2 = String.format(Locale.US, "%E", v);
                break;
            }
            case 'F': 
            case 'f': {
                s2 = String.format(Locale.US, "%f", v);
                break;
            }
            case 'g': {
                s2 = String.format(Locale.US, "%.17g", v);
                break;
            }
            case 'G': {
                s2 = String.format(Locale.US, "%.17G", v);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported conversion: " + conv);
            }
        }
        if (conv == 'g' || conv == 'G') {
            int e = ((String)s2).indexOf(conv == 'g' ? 101 : 69);
            if (e < 0) {
                int dot = ((String)s2).indexOf(46);
                if (dot < 0) {
                    s2 = (String)s2 + ".0";
                } else {
                    int i;
                    for (i = ((String)s2).length() - 1; i > dot + 1 && ((String)s2).charAt(i) == '0'; --i) {
                    }
                    s2 = ((String)s2).substring(0, i + 1);
                }
            } else {
                int i = e - 1;
                while (((String)s2).charAt(i) == '0') {
                    --i;
                }
                if (((String)s2).charAt(i) == '.') {
                    --i;
                }
                if (i < e - 1) {
                    s2 = new StringBuilder(i + 1 + ((String)s2).length() - e).append((CharSequence)s2, 0, i + 1).append((CharSequence)s2, e, ((String)s2).length()).toString();
                }
            }
        }
        return s2;
    }

    static StarlarkFloat floordiv(double x, double y) throws EvalException {
        if (y == 0.0) {
            throw Starlark.errorf("integer division by zero", new Object[0]);
        }
        return StarlarkFloat.of(Math.floor(x / y));
    }

    static StarlarkFloat div(double x, double y) throws EvalException {
        if (y == 0.0) {
            throw Starlark.errorf("floating-point division by zero", new Object[0]);
        }
        return StarlarkFloat.of(x / y);
    }

    static StarlarkFloat mod(double x, double y) throws EvalException {
        if (y == 0.0) {
            throw Starlark.errorf("floating-point modulo by zero", new Object[0]);
        }
        double z = x % y;
        if (x < 0.0 != y < 0.0 && z != 0.0) {
            z += y;
        }
        return StarlarkFloat.of(z);
    }

    static StarlarkInt finiteDoubleToIntExact(double x) {
        if (-9.223372036854776E18 <= x && x <= 9.223372036854776E18) {
            return StarlarkInt.of((long)x);
        }
        int shift = StarlarkFloat.getShift(x);
        if (shift <= 0) {
            throw new IllegalStateException("non-positive shift");
        }
        long mantissa = StarlarkFloat.getMantissa(x);
        return StarlarkInt.of(BigInteger.valueOf(mantissa).shiftLeft(shift));
    }

    static long getMantissa(double x) {
        long bits = Double.doubleToRawLongBits(x);
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        int exp = (int)(bits >>> 52) & 0x7FF;
        switch (exp) {
            case 0: {
                break;
            }
            case 2047: {
                throw new IllegalArgumentException("not finite: " + x);
            }
            default: {
                mantissa |= 0x10000000000000L;
            }
        }
        return x < 0.0 ? -mantissa : mantissa;
    }

    static int getShift(double x) {
        long bits = Double.doubleToRawLongBits(x);
        int exp = (int)(bits >>> 52) & 0x7FF;
        switch (exp) {
            case 0: {
                exp -= 1022;
                break;
            }
            case 2047: {
                throw new IllegalArgumentException("not finite: " + x);
            }
            default: {
                exp -= 1023;
            }
        }
        return exp - 52;
    }
}

