/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.starlark.java.annot.StarlarkAnnotations;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.BuiltinFunction;
import net.starlark.java.eval.CallUtils;
import net.starlark.java.eval.CpuProfiler;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.EvalUtils;
import net.starlark.java.eval.MethodDescriptor;
import net.starlark.java.eval.MethodLibrary;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.RangeList;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkFloat;
import net.starlark.java.eval.StarlarkFunction;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkIterable;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.eval.StringModule;
import net.starlark.java.eval.Structure;
import net.starlark.java.eval.Tuple;
import net.starlark.java.spelling.SpellChecker;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileOptions;
import net.starlark.java.syntax.ParserInput;
import net.starlark.java.syntax.Program;
import net.starlark.java.syntax.Resolver;
import net.starlark.java.syntax.StarlarkFile;
import net.starlark.java.syntax.SyntaxError;

public final class Starlark {
    public static final NoneType NONE = NoneType.NONE;
    public static final Object UNBOUND = new UnboundMarker();
    public static final ImmutableMap<String, Object> UNIVERSE = Starlark.makeUniverse();
    public static final Ordering<Object> ORDERING = new Ordering<Object>(){

        @Override
        public int compare(Object x, Object y) {
            return Starlark.compareUnchecked(x, y);
        }
    };
    private static final Object[] EMPTY = new Object[0];

    private Starlark() {
    }

    private static ImmutableMap<String, Object> makeUniverse() {
        ImmutableMap.Builder<String, Object> env = ImmutableMap.builder();
        env.put("False", false).put("True", true).put("None", (Boolean)((Object)NONE));
        Starlark.addMethods(env, new MethodLibrary());
        return env.build();
    }

    public static boolean valid(Object x) {
        return x instanceof String || x instanceof Boolean || x instanceof StarlarkValue;
    }

    public static <T> T checkValid(T x) {
        if (!Starlark.valid(x)) {
            throw new InvalidStarlarkValueException(x.getClass());
        }
        return x;
    }

    public static boolean isNullOrNone(Object x) {
        return x == null || x == NONE;
    }

    public static boolean isImmutable(Object x) {
        if (x instanceof String || x instanceof Boolean) {
            return true;
        }
        if (x instanceof StarlarkValue) {
            return ((StarlarkValue)x).isImmutable();
        }
        throw new InvalidStarlarkValueException(x.getClass());
    }

    public static void checkHashable(Object x) throws EvalException {
        if (!(x instanceof String)) {
            if (x instanceof StarlarkValue) {
                ((StarlarkValue)x).checkHashable();
            } else {
                Starlark.checkValid(x);
            }
        }
    }

    public static Object fromJava(Object x, @Nullable Mutability mutability) {
        if (x == null) {
            return NONE;
        }
        if (Starlark.valid(x)) {
            return x;
        }
        if (x instanceof Number) {
            if (x instanceof Integer) {
                return StarlarkInt.of((Integer)x);
            }
            if (x instanceof Long) {
                return StarlarkInt.of((Long)x);
            }
            if (x instanceof BigInteger) {
                return StarlarkInt.of((BigInteger)x);
            }
            if (x instanceof Double) {
                return StarlarkFloat.of((Double)x);
            }
        } else {
            if (x instanceof List) {
                return StarlarkList.copyOf(mutability, (List)x);
            }
            if (x instanceof Map) {
                return Dict.copyOf(mutability, (Map)x);
            }
        }
        throw new InvalidStarlarkValueException(x.getClass());
    }

    public static <T> Optional<T> toJavaOptional(Object x, Class<T> expectedClass) {
        if (x == UNBOUND || x == NONE) {
            return Optional.empty();
        }
        return Optional.of(expectedClass.cast(x));
    }

    public static boolean truth(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof StarlarkValue) {
            return ((StarlarkValue)x).truth();
        }
        if (x instanceof String) {
            return !((String)x).isEmpty();
        }
        throw new InvalidStarlarkValueException(x.getClass());
    }

    public static void checkMutable(Mutability.Freezable x) throws EvalException {
        if (x.mutability().isFrozen()) {
            throw Starlark.errorf("trying to mutate a frozen %s value", Starlark.type(x));
        }
        if (x.updateIteratorCount(0)) {
            throw Starlark.errorf("%s value is temporarily immutable due to active for-loop iteration", Starlark.type(x));
        }
    }

    public static Iterable<?> toIterable(Object x) throws EvalException {
        if (x instanceof StarlarkIterable) {
            return (Iterable)x;
        }
        throw Starlark.errorf("type '%s' is not iterable", Starlark.type(x));
    }

    public static Object[] toArray(Object x) throws EvalException {
        if (x instanceof Sequence) {
            return ((Sequence)x).toArray(EMPTY);
        }
        if (x instanceof Dict) {
            return ((Dict)x).keySet().toArray();
        }
        return Iterables.toArray(Starlark.toIterable(x), Object.class);
    }

    public static int len(Object x) {
        if (x instanceof String) {
            return ((String)x).length();
        }
        if (x instanceof Sequence) {
            return ((Sequence)x).size();
        }
        if (x instanceof Dict) {
            return ((Dict)x).size();
        }
        if (x instanceof StarlarkIterable) {
            return Iterables.size((Iterable)x);
        }
        Starlark.checkValid(x);
        return -1;
    }

    public static String type(Object x) {
        return Starlark.classType(x.getClass());
    }

    public static String classType(Class<?> c) {
        if (c.equals(String.class)) {
            return "string";
        }
        if (StarlarkInt.class.isAssignableFrom(c)) {
            return "int";
        }
        if (c.equals(Boolean.class)) {
            return "bool";
        }
        if (c.equals(StarlarkFloat.class)) {
            return "float";
        }
        if (StarlarkList.class.isAssignableFrom(c)) {
            return "list";
        }
        if (Tuple.class.isAssignableFrom(c)) {
            return "tuple";
        }
        if (c.equals(Dict.class)) {
            return "dict";
        }
        if (c.equals(NoneType.class)) {
            return "NoneType";
        }
        if (c.equals(StarlarkFunction.class)) {
            return "function";
        }
        if (c.equals(RangeList.class)) {
            return "range";
        }
        if (c.equals(UnboundMarker.class)) {
            return "unbound";
        }
        if (c == StarlarkIterable.class) {
            return "iterable";
        }
        if (c == Sequence.class) {
            return "sequence";
        }
        if (c == StarlarkCallable.class) {
            return "callable";
        }
        if (c == Structure.class) {
            return "structure";
        }
        StarlarkBuiltin module = StarlarkAnnotations.getStarlarkBuiltin(c);
        if (module != null) {
            return module.name();
        }
        if (c.equals(Object.class)) {
            return "unknown";
        }
        if (List.class.isAssignableFrom(c)) {
            return "List";
        }
        if (Map.class.isAssignableFrom(c)) {
            return "Map";
        }
        if (c.equals(Integer.class)) {
            return "int";
        }
        if (c == Void.TYPE) {
            return "NoneType";
        }
        if (c == Boolean.TYPE) {
            return "bool";
        }
        String simpleName = c.getSimpleName();
        return simpleName.isEmpty() ? c.getName() : simpleName;
    }

    public static String classTypeFromJava(Class<?> c) {
        if (c.equals(Void.TYPE) || c.equals(String.class) || c.equals(Boolean.TYPE) || c.equals(Boolean.class) || StarlarkValue.class.isAssignableFrom(c) || c.equals(Object.class)) {
            return Starlark.classType(c);
        }
        if (c.equals(Integer.TYPE) || c.equals(Integer.class) || c.equals(Long.TYPE) || c.equals(Long.class) || BigInteger.class.isAssignableFrom(c)) {
            return Starlark.classType(StarlarkInt.class);
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class)) {
            return Starlark.classType(StarlarkFloat.class);
        }
        if (List.class.isAssignableFrom(c)) {
            return Starlark.classType(StarlarkList.class);
        }
        if (Map.class.isAssignableFrom(c)) {
            return Starlark.classType(Dict.class);
        }
        throw new InvalidStarlarkValueException(c);
    }

    static int compareUnchecked(Object x, Object y) {
        if (Starlark.sameType(x, y)) {
            if (x instanceof Comparable) {
                Comparable xcomp = (Comparable)x;
                return xcomp.compareTo(y);
            }
        } else {
            if (x instanceof StarlarkFloat && y instanceof StarlarkInt) {
                double xf = ((StarlarkFloat)x).toDouble();
                return Double.isNaN(xf) ? 1 : -StarlarkInt.compareIntAndDouble((StarlarkInt)y, xf);
            }
            if (x instanceof StarlarkInt && y instanceof StarlarkFloat) {
                double yf = ((StarlarkFloat)y).toDouble();
                return Double.isNaN(yf) ? -1 : StarlarkInt.compareIntAndDouble((StarlarkInt)x, yf);
            }
        }
        throw new ClassCastException(String.format("unsupported comparison: %s <=> %s", Starlark.type(x), Starlark.type(y)));
    }

    private static boolean sameType(Object x, Object y) {
        return x.getClass() == y.getClass() || Starlark.type(x).equals(Starlark.type(y));
    }

    public static String str(Object x, StarlarkSemantics semantics) {
        return new Printer().str(x, semantics).toString();
    }

    public static String repr(Object x) {
        return new Printer().repr(x).toString();
    }

    public static String format(StarlarkSemantics semantics, String pattern, Object ... arguments) {
        Printer pr = new Printer();
        Printer.format(pr, semantics, pattern, arguments);
        return pr.toString();
    }

    public static String formatWithList(StarlarkSemantics semantics, String pattern, List<?> arguments) {
        Printer pr = new Printer();
        Printer.formatWithList(pr, semantics, pattern, arguments);
        return pr.toString();
    }

    public static Object slice(Mutability mu, Object x, Object startObj, Object stopObj, Object stepObj) throws EvalException {
        int start;
        int stop;
        int step;
        int n;
        if (x instanceof String) {
            n = ((String)x).length();
        } else if (x instanceof Sequence) {
            n = ((Sequence)x).size();
        } else {
            throw Starlark.errorf("invalid slice operand: %s", Starlark.type(x));
        }
        if (stepObj == NONE) {
            step = 1;
        } else {
            step = Starlark.toInt(stepObj, "slice step");
            if (step == 0) {
                throw Starlark.errorf("slice step cannot be zero", new Object[0]);
            }
        }
        if (step > 0) {
            stop = stopObj == NONE ? n : EvalUtils.toIndex(Starlark.toInt(stopObj, "stop index"), n);
            if (stop < (start = startObj == NONE ? 0 : EvalUtils.toIndex(Starlark.toInt(startObj, "start index"), n))) {
                stop = start;
            }
        } else {
            if (startObj == NONE) {
                start = n - 1;
            } else {
                start = Starlark.toInt(startObj, "start index");
                if (start < 0) {
                    start += n;
                }
                if (start >= n) {
                    start = n - 1;
                }
            }
            if (stopObj == NONE) {
                stop = -1;
            } else {
                stop = Starlark.toInt(stopObj, "stop index");
                if (stop < 0) {
                    stop += n;
                }
                if (stop < -1) {
                    stop = -1;
                }
            }
            if (start < stop) {
                start = stop;
            }
        }
        if (x instanceof String) {
            return StringModule.slice((String)x, start, stop, step);
        }
        return ((Sequence)x).getSlice(mu, start, stop, step);
    }

    public static int toInt(Object x, String what) throws EvalException {
        if (x instanceof StarlarkInt) {
            return ((StarlarkInt)x).toInt(what);
        }
        if (x instanceof Integer) {
            throw new IllegalArgumentException("Integer is not a legal Starlark value");
        }
        throw Starlark.errorf("got %s for %s, want int", Starlark.type(x), what);
    }

    public static Object call(StarlarkThread thread, Object fn, List<Object> args, Map<String, Object> kwargs) throws EvalException, InterruptedException {
        Object[] named = new Object[2 * kwargs.size()];
        int i = 0;
        for (Map.Entry<String, Object> e : kwargs.entrySet()) {
            named[i++] = e.getKey();
            named[i++] = Starlark.checkValid(e.getValue());
        }
        return Starlark.fastcall(thread, fn, args.toArray(), named);
    }

    public static Object fastcall(StarlarkThread thread, Object fn, Object[] positional, Object[] named) throws EvalException, InterruptedException {
        Object desc;
        StarlarkCallable callable;
        if (fn instanceof StarlarkCallable) {
            callable = (StarlarkCallable)fn;
        } else {
            desc = CallUtils.getSelfCallMethodDescriptor(thread.getSemantics(), fn.getClass());
            if (desc == null) {
                throw Starlark.errorf("'%s' object is not callable", Starlark.type(fn));
            }
            callable = new BuiltinFunction(fn, ((MethodDescriptor)desc).getName(), (MethodDescriptor)desc);
        }
        thread.push(callable);
        try {
            desc = callable.fastcall(thread, positional, named);
            return desc;
        }
        catch (UncheckedEvalError | UncheckedEvalException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new UncheckedEvalException(ex, thread);
        }
        catch (Error ex) {
            throw new UncheckedEvalError(ex, thread);
        }
        catch (EvalException ex) {
            throw ex.ensureStack(thread);
        }
        finally {
            thread.pop();
        }
    }

    private static String createUncheckedEvalMessage(Throwable cause, StarlarkThread thread) {
        String msg = cause.getClass().getSimpleName() + " thrown during Starlark evaluation";
        String context = thread.getContextForUncheckedException();
        return Strings.isNullOrEmpty(context) ? msg : msg + " (" + context + ")";
    }

    @CheckReturnValue
    @FormatMethod
    public static EvalException errorf(String format, Object ... args) {
        return new EvalException(String.format(format, args));
    }

    public static boolean hasattr(StarlarkSemantics semantics, Object x, String name) throws EvalException {
        return x instanceof Structure && ((Structure)x).getValue(name) != null || CallUtils.getAnnotatedMethods(semantics, x.getClass()).containsKey(name);
    }

    public static Object getattr(Mutability mu, StarlarkSemantics semantics, Object x, String name, @Nullable Object defaultValue) throws EvalException, InterruptedException {
        MethodDescriptor method = CallUtils.getAnnotatedMethods(semantics, x.getClass()).get(name);
        if (method != null) {
            if (method.isStructField()) {
                return method.callField(x, semantics, mu);
            }
            return new BuiltinFunction(x, name, method);
        }
        if (x instanceof Structure) {
            Structure struct = (Structure)x;
            Object field = struct.getValue(semantics, name);
            if (field != null) {
                return Starlark.checkValid(field);
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            String error = struct.getErrorMessageForUnknownField(name);
            if (error != null) {
                throw Starlark.errorf("%s", error);
            }
        } else if (defaultValue != null) {
            return defaultValue;
        }
        throw Starlark.errorf("'%s' value has no field or method '%s'%s", Starlark.type(x), name, SpellChecker.didYouMean(name, Starlark.dir(mu, semantics, x)));
    }

    public static StarlarkList<String> dir(Mutability mu, StarlarkSemantics semantics, Object x) {
        TreeSet<String> fields = new TreeSet<String>();
        if (x instanceof Structure) {
            fields.addAll(((Structure)x).getFieldNames());
        }
        fields.addAll(CallUtils.getAnnotatedMethods(semantics, x.getClass()).keySet());
        return StarlarkList.copyOf(mu, fields);
    }

    public static Object getAnnotatedField(StarlarkSemantics semantics, Object x, String name) throws EvalException, InterruptedException {
        return CallUtils.getAnnotatedField(semantics, x, name);
    }

    public static ImmutableSet<String> getAnnotatedFieldNames(StarlarkSemantics semantics, Object x) {
        return CallUtils.getAnnotatedFieldNames(semantics, x);
    }

    public static ImmutableMap<Method, StarlarkMethod> getMethodAnnotations(Class<?> clazz) {
        ImmutableMap.Builder<Method, StarlarkMethod> result = ImmutableMap.builder();
        for (MethodDescriptor desc : CallUtils.getAnnotatedMethods(StarlarkSemantics.DEFAULT, clazz).values()) {
            result.put(desc.getMethod(), desc.getAnnotation());
        }
        return result.build();
    }

    @Nullable
    public static Method getSelfCallMethod(StarlarkSemantics semantics, Class<?> clazz) {
        return CallUtils.getSelfCallMethod(semantics, clazz);
    }

    public static void addMethods(ImmutableMap.Builder<String, Object> env, Object v) {
        Starlark.addMethods(env, v, StarlarkSemantics.DEFAULT);
    }

    public static void addMethods(ImmutableMap.Builder<String, Object> env, Object v, StarlarkSemantics semantics) {
        Class<?> cls = v.getClass();
        for (Map.Entry e : CallUtils.getAnnotatedMethods(semantics, cls).entrySet()) {
            String name = (String)e.getKey();
            if (((MethodDescriptor)e.getValue()).isStructField()) {
                throw new IllegalArgumentException(String.format("addMethods(%s): method %s has structField=true", cls.getName(), name));
            }
            env.put(name, new BuiltinFunction(v, name));
        }
    }

    public static Object execFile(ParserInput input, FileOptions options, Module module, StarlarkThread thread) throws SyntaxError.Exception, EvalException, InterruptedException {
        StarlarkFile file = StarlarkFile.parse(input, options);
        Program prog = Program.compileFile(file, module);
        return Starlark.execFileProgram(prog, module, thread);
    }

    public static Object execFile(ParserInput input, FileOptions options, Map<String, Object> predeclared, StarlarkThread thread) throws SyntaxError.Exception, EvalException, InterruptedException {
        Module module = Module.withPredeclared(thread.getSemantics(), predeclared);
        return Starlark.execFile(input, options, module, thread);
    }

    public static Object execFileProgram(Program prog, Module module, StarlarkThread thread) throws EvalException, InterruptedException {
        Resolver.Function rfn = prog.getResolvedFunction();
        int[] globalIndex = module.getIndicesOfGlobals(rfn.getGlobals());
        if (module.getDocumentation() == null) {
            module.setDocumentation(rfn.getDocumentation());
        }
        StarlarkFunction toplevel = new StarlarkFunction(rfn, module, globalIndex, Tuple.empty(), Tuple.empty());
        return Starlark.fastcall(thread, toplevel, EMPTY, EMPTY);
    }

    public static Object eval(ParserInput input, FileOptions options, Module module, StarlarkThread thread) throws SyntaxError.Exception, EvalException, InterruptedException {
        StarlarkFunction fn = Starlark.newExprFunction(input, options, module);
        return Starlark.fastcall(thread, fn, EMPTY, EMPTY);
    }

    public static Object eval(ParserInput input, FileOptions options, Map<String, Object> predeclared, StarlarkThread thread) throws SyntaxError.Exception, EvalException, InterruptedException {
        Module module = Module.withPredeclared(thread.getSemantics(), predeclared);
        return Starlark.eval(input, options, module, thread);
    }

    private static StarlarkFunction newExprFunction(ParserInput input, FileOptions options, Module module) throws SyntaxError.Exception {
        Expression expr = Expression.parse(input);
        Program prog = Program.compileExpr(expr, module, options);
        Resolver.Function rfn = prog.getResolvedFunction();
        int[] globalIndex = module.getIndicesOfGlobals(rfn.getGlobals());
        return new StarlarkFunction(rfn, module, globalIndex, Tuple.empty(), Tuple.empty());
    }

    public static boolean startCpuProfile(OutputStream out, Duration period) {
        return CpuProfiler.start(out, period);
    }

    public static void stopCpuProfile() throws IOException {
        CpuProfiler.stop();
    }

    public static final class UncheckedEvalError
    extends Error {
        private UncheckedEvalError(Error cause, StarlarkThread thread) {
            super(Starlark.createUncheckedEvalMessage(cause, thread), cause);
            thread.fillInStackTrace(this);
        }
    }

    public static final class UncheckedEvalException
    extends RuntimeException {
        private UncheckedEvalException(RuntimeException cause, StarlarkThread thread) {
            super(Starlark.createUncheckedEvalMessage(cause, thread), cause);
            thread.fillInStackTrace(this);
        }
    }

    public static final class InvalidStarlarkValueException
    extends IllegalArgumentException {
        private final Class<?> invalidClass;

        public Class<?> getInvalidClass() {
            return this.invalidClass;
        }

        private InvalidStarlarkValueException(Class<?> invalidClass) {
            super("invalid Starlark value: " + invalidClass);
            this.invalidClass = invalidClass;
        }
    }

    @Immutable
    private static final class UnboundMarker
    implements StarlarkValue {
        private UnboundMarker() {
        }

        public String toString() {
            return "<unbound>";
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public void repr(Printer printer) {
            printer.append("<unbound>");
        }
    }
}

