/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.RangeList;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.Tuple;

final class SingletonTuple
extends Tuple {
    final Object elem;

    SingletonTuple(Object elem) {
        this.elem = elem;
    }

    @Override
    public boolean isImmutable() {
        return Starlark.isImmutable(this.elem);
    }

    @Override
    public void checkHashable() throws EvalException {
        Starlark.checkHashable(this.elem);
    }

    @Override
    public int hashCode() {
        return 9857 + 8167 * (31 + this.elem.hashCode());
    }

    @Override
    public Object get(int i) {
        Preconditions.checkElementIndex(i, 1);
        return this.elem;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return o.equals(this.elem);
    }

    public Tuple subList(int from, int to) {
        Preconditions.checkPositionIndexes(from, to, 1);
        return from <= 0 && to >= 1 ? this : SingletonTuple.empty();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.elem};
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < 1) {
            return new Object[]{this.elem};
        }
        a[0] = this.elem;
        Arrays.fill(a, 1, a.length, null);
        return a;
    }

    @Override
    public void repr(Printer printer) {
        printer.append('(').repr(this.elem).append(",)");
    }

    @Override
    public ImmutableList<Object> getImmutableList() {
        return ImmutableList.of(this.elem);
    }

    public Tuple getSlice(Mutability mu, int start, int stop, int step) throws EvalException {
        RangeList indices = new RangeList(start, stop, step);
        return indices.isEmpty() ? Tuple.empty() : this;
    }

    @Override
    Tuple repeat(StarlarkInt n) throws EvalException {
        if (n.signum() <= 0) {
            return SingletonTuple.empty();
        }
        int ni = n.toInt("repeat");
        if (ni > 0x40000000) {
            throw Starlark.errorf("excessive repeat (%d * %d elements)", 1, ni);
        }
        Object[] res = new Object[ni];
        Arrays.fill(res, 0, ni, this.elem);
        return SingletonTuple.wrap(res);
    }
}

