/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatWidthException;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkFloat;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.eval.Tuple;

public class Printer {
    private final StringBuilder buffer;
    private Object[] stack;
    private int depth;

    public Printer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public Printer() {
        this(new StringBuilder());
    }

    @CanIgnoreReturnValue
    public final Printer append(char c) {
        this.buffer.append(c);
        return this;
    }

    @CanIgnoreReturnValue
    public final Printer append(CharSequence s2) {
        this.buffer.append(s2);
        return this;
    }

    @CanIgnoreReturnValue
    public final Printer append(CharSequence s2, int start, int end) {
        this.buffer.append(s2, start, end);
        return this;
    }

    @CanIgnoreReturnValue
    public final Printer append(int i) {
        this.buffer.append(i);
        return this;
    }

    @CanIgnoreReturnValue
    public final Printer append(long l) {
        this.buffer.append(l);
        return this;
    }

    public Printer printList(Iterable<?> list, String before, String separator, String after) {
        this.append(before);
        String sep = "";
        for (Object elem : list) {
            this.append(sep);
            sep = separator;
            this.repr(elem);
        }
        return this.append(after);
    }

    public final String toString() {
        return this.buffer.toString();
    }

    public Printer debugPrint(Object o, StarlarkSemantics semantics) {
        if (o instanceof StarlarkValue) {
            ((StarlarkValue)o).debugPrint(this, semantics);
            return this;
        }
        return this.str(o, semantics);
    }

    public Printer str(Object o, StarlarkSemantics semantics) {
        if (o instanceof String) {
            return this.append((String)o);
        }
        if (o instanceof StarlarkValue) {
            ((StarlarkValue)o).str(this, semantics);
            return this;
        }
        return this.repr(o);
    }

    public Printer repr(Object o) {
        if (o == null) {
            return this.append("null");
        }
        if (o instanceof String) {
            this.appendQuoted((String)o);
            return this;
        }
        if (o instanceof StarlarkInt) {
            ((StarlarkInt)o).repr(this);
            return this;
        }
        if (o instanceof Boolean) {
            this.append((Boolean)o != false ? "True" : "False");
            return this;
        }
        if (o instanceof Integer) {
            this.buffer.append((Integer)o);
            return this;
        }
        if (o instanceof Class) {
            this.append(Starlark.classType((Class)o));
            return this;
        }
        if (!this.push(o)) {
            return this.append("...");
        }
        try {
            if (o instanceof StarlarkValue) {
                ((StarlarkValue)o).repr(this);
            } else if (o instanceof Map) {
                Map dict = (Map)o;
                this.printList(dict.entrySet(), "{", ", ", "}");
            } else if (o instanceof List) {
                this.printList((List)o, "[", ", ", "]");
            } else if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                this.repr(entry.getKey());
                this.append(": ");
                this.repr(entry.getValue());
            } else {
                this.append(o.toString());
            }
        }
        finally {
            this.pop();
        }
        return this;
    }

    private Printer appendQuoted(String s2) {
        this.append('\"');
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            this.escapeCharacter(c);
        }
        return this.append('\"');
    }

    private Printer backslashChar(char c) {
        return this.append('\\').append(c);
    }

    private Printer escapeCharacter(char c) {
        if (c == '\"') {
            return this.backslashChar(c);
        }
        switch (c) {
            case '\\': {
                return this.backslashChar('\\');
            }
            case '\r': {
                return this.backslashChar('r');
            }
            case '\n': {
                return this.backslashChar('n');
            }
            case '\t': {
                return this.backslashChar('t');
            }
        }
        if (c < ' ') {
            return this.append(String.format("\\x%02x", c));
        }
        return this.append(c);
    }

    private boolean push(Object x) {
        for (int i = 0; i < this.depth; ++i) {
            if (x != this.stack[i]) continue;
            return false;
        }
        if (this.stack == null) {
            this.stack = new Object[4];
        } else if (this.depth == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, 2 * this.stack.length);
        }
        this.stack[this.depth++] = x;
        return true;
    }

    private void pop() {
        this.stack[--this.depth] = null;
    }

    public static void format(Printer printer, StarlarkSemantics semantics, String format, Object ... arguments) {
        Printer.formatWithList(printer, semantics, format, Arrays.asList(arguments));
    }

    public static void formatWithList(Printer printer, StarlarkSemantics semantics, String pattern, List<?> arguments) {
        int length = pattern.length();
        int argLength = arguments.size();
        int i = 0;
        int a = 0;
        block8: while (i < length) {
            int p = pattern.indexOf(37, i);
            if (p == -1) {
                printer.append(pattern, i, length);
                break;
            }
            if (p > i) {
                printer.append(pattern, i, p);
            }
            if (p == length - 1) {
                throw new MissingFormatWidthException("incomplete format pattern ends with %: " + Starlark.repr(pattern));
            }
            char conv = pattern.charAt(p + 1);
            i = p + 2;
            if (conv == '%') {
                printer.append('%');
                continue;
            }
            if (a >= argLength) {
                throw new MissingFormatWidthException("not enough arguments for format pattern " + Starlark.repr(pattern) + ": " + Starlark.repr(Tuple.copyOf(arguments)));
            }
            Object arg = arguments.get(a++);
            switch (conv) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    Number n;
                    if (arg instanceof StarlarkInt) {
                        n = ((StarlarkInt)arg).toNumber();
                    } else if (arg instanceof Integer) {
                        n = (Number)arg;
                    } else if (arg instanceof StarlarkFloat) {
                        double d = ((StarlarkFloat)arg).toDouble();
                        try {
                            n = StarlarkInt.ofFiniteDouble(d).toNumber();
                        }
                        catch (IllegalArgumentException unused) {
                            throw new MissingFormatWidthException("got " + arg + ", want a finite number");
                        }
                    } else {
                        throw new MissingFormatWidthException(String.format("got %s for '%%%c' format, want int or float", Starlark.type(arg), Character.valueOf(conv)));
                    }
                    printer.append(String.format(conv == 'd' ? "%d" : (conv == 'o' ? "%o" : (conv == 'x' ? "%x" : "%X")), n));
                    continue block8;
                }
                case 'E': 
                case 'F': 
                case 'G': 
                case 'e': 
                case 'f': 
                case 'g': {
                    double v;
                    if (arg instanceof Integer) {
                        v = ((Integer)arg).intValue();
                    } else if (arg instanceof StarlarkInt) {
                        v = ((StarlarkInt)arg).toDouble();
                    } else if (arg instanceof StarlarkFloat) {
                        v = ((StarlarkFloat)arg).toDouble();
                    } else {
                        throw new MissingFormatWidthException(String.format("got %s for '%%%c' format, want int or float", Starlark.type(arg), Character.valueOf(conv)));
                    }
                    printer.append(StarlarkFloat.format(v, conv));
                    continue block8;
                }
                case 'r': {
                    printer.repr(arg);
                    continue block8;
                }
                case 's': {
                    printer.str(arg, semantics);
                    continue block8;
                }
            }
            throw new MissingFormatWidthException(String.format("unsupported format character \"%s\" at index %s in %s", String.valueOf(conv), p + 1, Starlark.repr(pattern)));
        }
        if (a < argLength) {
            throw new MissingFormatWidthException("not all arguments converted during string formatting");
        }
    }
}

