/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.ParamType;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.Tuple;
import net.starlark.java.syntax.FileOptions;
import net.starlark.java.syntax.ParserInput;
import net.starlark.java.syntax.SyntaxError;

final class ParamDescriptor {
    private final String name;
    @Nullable
    private final Object defaultValue;
    private final boolean named;
    private final boolean positional;
    @Nullable
    private final List<Class<?>> allowedClasses;
    @Nullable
    private final String disabledByFlag;
    private static final ConcurrentHashMap<String, Object> defaultValueCache = new ConcurrentHashMap();

    private ParamDescriptor(String name, String defaultExpr, boolean named, boolean positional, List<Class<?>> allowedClasses, @Nullable String disabledByFlag) {
        this.name = name;
        this.defaultValue = defaultExpr.isEmpty() ? null : ParamDescriptor.evalDefault(name, defaultExpr);
        this.named = named;
        this.positional = positional;
        this.allowedClasses = allowedClasses.contains(Object.class) ? null : allowedClasses;
        this.disabledByFlag = disabledByFlag;
    }

    static ParamDescriptor of(Param param, Class<?> paramClass, StarlarkSemantics starlarkSemantics) {
        String defaultExpr = param.defaultValue();
        String disabledByFlag = null;
        if (!starlarkSemantics.isFeatureEnabledBasedOnTogglingFlags(param.enableOnlyWithFlag(), param.disableWithFlag())) {
            defaultExpr = param.valueWhenDisabled();
            disabledByFlag = !param.enableOnlyWithFlag().isEmpty() ? param.enableOnlyWithFlag() : param.disableWithFlag();
            Preconditions.checkState(!disabledByFlag.isEmpty());
        }
        ParamType[] allowedTypes = param.allowedTypes();
        ArrayList allowedClasses = new ArrayList();
        if (allowedTypes.length > 0) {
            for (ParamType pt : allowedTypes) {
                allowedClasses.add(pt.type());
            }
        } else {
            allowedClasses.add(paramClass == Boolean.TYPE ? Boolean.class : paramClass);
        }
        return new ParamDescriptor(param.name(), defaultExpr, param.named(), param.positional(), allowedClasses, disabledByFlag);
    }

    String getName() {
        return this.name;
    }

    String getTypeErrorMessage() {
        if (this.allowedClasses == null) {
            return Starlark.classType(Object.class);
        }
        StringBuilder buf = new StringBuilder();
        ImmutableList allowedClassesFiltered = this.allowedClasses.stream().filter(x -> !Starlark.classType(x).equals("NativeComputedDefault")).collect(ImmutableList.toImmutableList());
        int n = allowedClassesFiltered.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(n == 2 ? " or " : (i < n - 1 ? ", " : ", or "));
            }
            buf.append(Starlark.classType((Class)allowedClassesFiltered.get(i)));
        }
        return buf.toString();
    }

    @Nullable
    List<Class<?>> getAllowedClasses() {
        return this.allowedClasses;
    }

    boolean isPositional() {
        return this.positional;
    }

    boolean isNamed() {
        return this.named;
    }

    @Nullable
    Object getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    String disabledByFlag() {
        return this.disabledByFlag;
    }

    private static Object evalDefault(String name, String expr) {
        if (expr.equals("None")) {
            return Starlark.NONE;
        }
        if (expr.equals("True")) {
            return true;
        }
        if (expr.equals("False")) {
            return false;
        }
        if (expr.equals("unbound")) {
            return Starlark.UNBOUND;
        }
        if (expr.equals("0")) {
            return StarlarkInt.of(0);
        }
        if (expr.equals("1")) {
            return StarlarkInt.of(1);
        }
        if (expr.equals("[]")) {
            return StarlarkList.empty();
        }
        if (expr.equals("()")) {
            return Tuple.empty();
        }
        if (expr.equals("\" \"")) {
            return " ";
        }
        Object x = defaultValueCache.get(expr);
        if (x != null) {
            return x;
        }
        if (Starlark.UNIVERSE == null) {
            throw new IllegalStateException("no bootstrap value for " + name + "=" + expr);
        }
        Module module = Module.create();
        try (Mutability mu = Mutability.create("Builtin param default init");){
            StarlarkThread thread = new StarlarkThread(mu, StarlarkSemantics.DEFAULT);
            thread.ignoreThreadInterrupts();
            x = Starlark.eval(ParserInput.fromLines(expr), FileOptions.DEFAULT, module, thread);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
        catch (EvalException | SyntaxError.Exception ex) {
            throw new IllegalArgumentException(String.format("failed to evaluate default value '%s' of parameter '%s': %s", expr, name, ex.getMessage()), ex);
        }
        defaultValueCache.put(expr, x);
        return x;
    }
}

