/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Joiner;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.IdentityHashMap;

public final class Mutability
implements AutoCloseable {
    private IdentityHashMap<Freezable, Integer> iteratorCount = new IdentityHashMap(10);
    private final Object[] annotation;
    private final boolean allowsUnsafeShallowFreeze;
    public static final Mutability IMMUTABLE = Mutability.create("IMMUTABLE").freeze();

    private Mutability(Object[] annotation, boolean allowsUnsafeShallowFreeze) {
        this.annotation = annotation;
        this.allowsUnsafeShallowFreeze = allowsUnsafeShallowFreeze;
    }

    public static Mutability create(Object ... annotation) {
        return new Mutability(annotation, false);
    }

    public static Mutability createAllowingShallowFreeze(Object ... annotation) {
        return new Mutability(annotation, true);
    }

    public String getAnnotation() {
        return Joiner.on(" ").join(this.annotation);
    }

    public String toString() {
        return (this.isFrozen() ? "(" : "[") + this.getAnnotation() + (this.isFrozen() ? ")" : "]");
    }

    public boolean isFrozen() {
        return this.iteratorCount == null;
    }

    private boolean updateIteratorCount(Freezable x, int delta) {
        if (this.isFrozen()) {
            return false;
        }
        int i = this.iteratorCount.getOrDefault(x, 0);
        if (delta > 0) {
            this.iteratorCount.put(x, ++i);
        } else if (delta < 0) {
            if (--i == 0) {
                this.iteratorCount.remove(x);
            } else if (i > 0) {
                this.iteratorCount.put(x, i);
            } else {
                throw new IllegalStateException("zero value in this.iteratorCount");
            }
        }
        return i > 0;
    }

    @CanIgnoreReturnValue
    public Mutability freeze() {
        this.iteratorCount = null;
        return this;
    }

    @Override
    public void close() {
        this.freeze();
    }

    public boolean allowsUnsafeShallowFreeze() {
        return this.allowsUnsafeShallowFreeze;
    }

    public static interface Freezable {
        public Mutability mutability();

        default public boolean updateIteratorCount(int delta) {
            return this.mutability().updateIteratorCount(this, delta);
        }

        default public void unsafeShallowFreeze() {
            throw new UnsupportedOperationException();
        }

        public static void checkUnsafeShallowFreezePrecondition(Freezable freezable) {
            Mutability mutability = freezable.mutability();
            if (mutability.isFrozen()) {
                throw new IllegalArgumentException("cannot call unsafeShallowFreeze() on an object whose Mutability is already frozen");
            }
            if (!mutability.allowsUnsafeShallowFreeze()) {
                throw new IllegalArgumentException("cannot call unsafeShallowFreeze() on a mutable object whose Mutability's allowsUnsafeShallowFreeze() == false");
            }
        }
    }
}

