/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.GuardedValue;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkFunction;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.syntax.Resolver;

public final class Module
implements Resolver.Module {
    private ImmutableMap<String, Object> predeclared;
    private final LinkedHashMap<String, Integer> globalIndex = new LinkedHashMap();
    private Object[] globals = new Object[8];
    @Nullable
    private final Object clientData;
    @Nullable
    private String documentation;

    private Module(ImmutableMap<String, Object> predeclared, Object clientData) {
        this.predeclared = predeclared;
        this.clientData = clientData;
    }

    public static Module withPredeclared(StarlarkSemantics semantics, Map<String, Object> predeclared) {
        return Module.withPredeclaredAndData(semantics, predeclared, null);
    }

    public static Module withPredeclaredAndData(StarlarkSemantics semantics, Map<String, Object> predeclared, @Nullable Object clientData) {
        return new Module(Module.filter(predeclared, semantics, clientData), clientData);
    }

    public static Module create() {
        return new Module(ImmutableMap.of(), null);
    }

    @Nullable
    public static Module ofInnermostEnclosingStarlarkFunction(StarlarkThread thread, int depth) {
        StarlarkFunction fn = thread.getInnermostEnclosingStarlarkFunction(depth);
        if (fn != null) {
            return fn.getModule();
        }
        return null;
    }

    @Nullable
    public static Module ofInnermostEnclosingStarlarkFunction(StarlarkThread thread) {
        return Module.ofInnermostEnclosingStarlarkFunction(thread, 0);
    }

    private static ImmutableMap<String, Object> filter(Map<String, Object> predeclared, StarlarkSemantics semantics, @Nullable Object clientData) {
        ImmutableMap.Builder<String, Object> filtered = ImmutableMap.builder();
        for (Map.Entry<String, Object> bind : predeclared.entrySet()) {
            GuardedValue gv;
            Object v = bind.getValue();
            if (v instanceof GuardedValue && (gv = (GuardedValue)bind.getValue()).isObjectAccessibleUsingSemantics(semantics, clientData)) {
                v = gv.getObject();
            }
            filtered.put(bind.getKey(), v);
        }
        return filtered.build();
    }

    @Nullable
    public Object getClientData() {
        return this.clientData;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Nullable
    public String getDocumentation() {
        return this.documentation;
    }

    Object getPredeclared(String name) {
        return this.predeclared.get(name);
    }

    public ImmutableMap<String, Object> getPredeclaredBindings() {
        return this.predeclared;
    }

    public ImmutableMap<String, Object> getGlobals() {
        int n = this.globalIndex.size();
        ImmutableMap.Builder<String, Object> m4 = ImmutableMap.builderWithExpectedSize(n);
        for (Map.Entry<String, Integer> e : this.globalIndex.entrySet()) {
            Object v = this.getGlobalByIndex(e.getValue());
            if (v == null) continue;
            m4.put(e.getKey(), v);
        }
        return m4.build();
    }

    @Override
    public Resolver.Scope resolve(String name) throws Resolver.Module.Undefined {
        if (this.globalIndex.containsKey(name)) {
            return Resolver.Scope.GLOBAL;
        }
        Object v = this.predeclared.get(name);
        if (v != null) {
            if (v instanceof GuardedValue) {
                throw new Resolver.Module.Undefined(((GuardedValue)v).getErrorFromAttemptingAccess(name), null);
            }
            return Resolver.Scope.PREDECLARED;
        }
        if (Starlark.UNIVERSE.containsKey(name)) {
            return Resolver.Scope.UNIVERSAL;
        }
        HashSet<String> candidates = new HashSet<String>();
        candidates.addAll(this.globalIndex.keySet());
        candidates.addAll(this.predeclared.keySet());
        candidates.addAll(Starlark.UNIVERSE.keySet());
        throw new Resolver.Module.Undefined(String.format("name '%s' is not defined", name), candidates);
    }

    @Nullable
    public Object getGlobal(String name) {
        Integer i = this.globalIndex.get(name);
        return i != null ? this.globals[i] : null;
    }

    void setGlobalByIndex(int i, Object v) {
        Preconditions.checkArgument(i < this.globalIndex.size());
        this.globals[i] = v;
    }

    @Nullable
    Object getGlobalByIndex(int i) {
        Preconditions.checkArgument(i < this.globalIndex.size());
        return this.globals[i];
    }

    int getIndexOfGlobal(String name) {
        int i = this.globalIndex.size();
        Integer prev = this.globalIndex.putIfAbsent(name, i);
        if (prev != null) {
            return prev;
        }
        if (i == this.globals.length) {
            this.globals = Arrays.copyOf(this.globals, this.globals.length << 1);
        }
        return i;
    }

    int[] getIndicesOfGlobals(List<String> globals) {
        int n = globals.size();
        int[] array = new int[n];
        for (int i = 0; i < n; ++i) {
            array[i] = this.getIndexOfGlobal(globals.get(i));
        }
        return array;
    }

    public void setGlobal(String name, Object value) {
        Preconditions.checkNotNull(value, "Module.setGlobal(%s, null)", (Object)name);
        this.setGlobalByIndex(this.getIndexOfGlobal(name), value);
    }

    public String toString() {
        return String.format("<module %s>", this.clientData == null ? "?" : this.clientData);
    }
}

