/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.ParamDescriptor;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.eval.Tuple;

final class MethodDescriptor {
    private final Method method;
    private final StarlarkMethod annotation;
    private final String name;
    private final String doc;
    private final boolean documented;
    private final boolean structField;
    private final ParamDescriptor[] parameters;
    private final boolean extraPositionals;
    private final boolean extraKeywords;
    private final boolean selfCall;
    private final boolean allowReturnNones;
    private final boolean useStarlarkThread;
    private final boolean useStarlarkSemantics;
    private final HowToHandleReturn howToHandleReturn;
    private static final Object[] EMPTY = new Object[0];

    private MethodDescriptor(Method method, StarlarkMethod annotation, String name, String doc, boolean documented, boolean structField, ParamDescriptor[] parameters, boolean extraPositionals, boolean extraKeywords, boolean selfCall, boolean allowReturnNones, boolean useStarlarkThread, boolean useStarlarkSemantics) {
        this.method = method;
        this.annotation = annotation;
        this.name = name;
        this.doc = doc;
        this.documented = documented;
        this.structField = structField;
        this.parameters = parameters;
        this.extraPositionals = extraPositionals;
        this.extraKeywords = extraKeywords;
        this.selfCall = selfCall;
        this.allowReturnNones = allowReturnNones;
        this.useStarlarkThread = useStarlarkThread;
        this.useStarlarkSemantics = useStarlarkSemantics;
        Class<?> ret = method.getReturnType();
        this.howToHandleReturn = ret == Void.TYPE || ret == Boolean.TYPE ? HowToHandleReturn.NULL_TO_NONE : (StarlarkValue.class.isAssignableFrom(ret) || String.class == ret || Boolean.class == ret ? (allowReturnNones ? HowToHandleReturn.NULL_TO_NONE : HowToHandleReturn.ERROR_ON_NULL) : (ret == Integer.TYPE ? HowToHandleReturn.STARLARK_INT_OF_INT : HowToHandleReturn.FROM_JAVA));
    }

    StarlarkMethod getAnnotation() {
        return this.annotation;
    }

    static MethodDescriptor of(Method method, StarlarkMethod annotation, StarlarkSemantics semantics) {
        method.setAccessible(true);
        Class[] paramClasses = method.getParameterTypes();
        Param[] paramAnnots = annotation.parameters();
        ParamDescriptor[] params = new ParamDescriptor[paramAnnots.length];
        Arrays.setAll(params, i -> ParamDescriptor.of(paramAnnots[i], paramClasses[i], semantics));
        return new MethodDescriptor(method, annotation, annotation.name(), annotation.doc(), annotation.documented(), annotation.structField(), params, !annotation.extraPositionals().name().isEmpty(), !annotation.extraKeywords().name().isEmpty(), annotation.selfCall(), annotation.allowReturnNones(), annotation.useStarlarkThread(), annotation.useStarlarkSemantics());
    }

    Object callField(Object obj, StarlarkSemantics semantics, @Nullable Mutability mu) throws EvalException, InterruptedException {
        Object[] objectArray;
        if (!this.structField) {
            throw new IllegalStateException("not a struct field: " + this.name);
        }
        if (this.useStarlarkSemantics) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = semantics;
        } else {
            objectArray = EMPTY;
        }
        Object[] args = objectArray;
        return this.call(obj, args, mu);
    }

    Object call(Object obj, Object[] args, @Nullable Mutability mu) throws EvalException, InterruptedException {
        Object result;
        Preconditions.checkNotNull(obj);
        try {
            result = this.method.invoke(obj, args);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("IllegalArgumentException (%s) in Starlark call of %s, obj=%s (%s), args=[", ex.getMessage(), this.method, Starlark.repr(obj), Starlark.type(obj)));
            String sep = "";
            for (Object arg : args) {
                buf.append(String.format("%s%s (%s)", sep, Starlark.repr(arg), Starlark.type(arg)));
                sep = ", ";
            }
            buf.append(']');
            throw new IllegalArgumentException(buf.toString());
        }
        catch (InvocationTargetException ex) {
            Throwable e = ex.getCause();
            if (e == null) {
                throw new IllegalStateException(e);
            }
            Throwables.throwIfUnchecked(e);
            if (e instanceof EvalException) {
                throw (EvalException)e;
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            throw new EvalException(e);
        }
        switch (this.howToHandleReturn) {
            case NULL_TO_NONE: {
                return result != null ? result : Starlark.NONE;
            }
            case ERROR_ON_NULL: {
                if (result == null) {
                    throw this.methodInvocationReturnedNull(args);
                }
                return result;
            }
            case STARLARK_INT_OF_INT: {
                return StarlarkInt.of((Integer)result);
            }
            case FROM_JAVA: {
                if (result == null && !this.allowReturnNones) {
                    throw this.methodInvocationReturnedNull(args);
                }
                return Starlark.fromJava(result, mu);
            }
        }
        throw new IllegalStateException("unreachable: " + this.howToHandleReturn);
    }

    @CheckReturnValue
    private NullPointerException methodInvocationReturnedNull(Object[] args) {
        return new NullPointerException("method invocation returned null: " + this.getName() + Tuple.of(args));
    }

    String getName() {
        return this.name;
    }

    Method getMethod() {
        return this.method;
    }

    boolean isStructField() {
        return this.structField;
    }

    boolean isUseStarlarkThread() {
        return this.useStarlarkThread;
    }

    boolean isUseStarlarkSemantics() {
        return this.useStarlarkSemantics;
    }

    boolean acceptsExtraArgs() {
        return this.extraPositionals;
    }

    boolean acceptsExtraKwargs() {
        return this.extraKeywords;
    }

    ParamDescriptor[] getParameters() {
        return this.parameters;
    }

    int getParameterIndex(String name) {
        for (int i = 0; i < this.parameters.length; ++i) {
            if (!this.parameters[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    boolean isDocumented() {
        return this.documented;
    }

    String getDoc() {
        return this.doc;
    }

    boolean isSelfCall() {
        return this.selfCall;
    }

    private static enum HowToHandleReturn {
        NULL_TO_NONE,
        ERROR_ON_NULL,
        STARLARK_INT_OF_INT,
        FROM_JAVA;

    }
}

