/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.eval.Tuple;

final class ImmutableStarlarkList<E>
extends StarlarkList<E> {
    final Object[] elems;

    ImmutableStarlarkList(Object[] elems) {
        Preconditions.checkArgument(elems.getClass() == Object[].class);
        this.elems = elems;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean updateIteratorCount(int delta) {
        return false;
    }

    @Override
    public Mutability mutability() {
        return Mutability.IMMUTABLE;
    }

    @Override
    public void unsafeShallowFreeze() {
        Mutability.Freezable.checkUnsafeShallowFreezePrecondition(this);
    }

    @Override
    public ImmutableList<E> getImmutableList() {
        return Tuple.wrapImmutable(this.elems);
    }

    @Override
    public E get(int i) {
        Preconditions.checkElementIndex(i, this.elems.length);
        return (E)this.elems[i];
    }

    @Override
    public int size() {
        return this.elems.length;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        for (Object elem : this.elems) {
            if (!o.equals(elem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addElement(E element) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void addElementAt(int index, E element) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void addElements(Iterable<? extends E> elements) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void removeElementAt(int index) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void setElementAt(int index, E value) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void clearElements() throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public Object[] toArray() {
        return this.elems.length != 0 ? Arrays.copyOf(this.elems, this.elems.length, Object[].class) : EMPTY_ARRAY;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.elems.length) {
            return Arrays.copyOf(this.elems, this.elems.length, a.getClass());
        }
        System.arraycopy(this.elems, 0, a, 0, this.elems.length);
        Arrays.fill(a, this.elems.length, a.length, null);
        return a;
    }

    @Override
    Object[] elems() {
        return this.elems;
    }
}

