/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkSemantics;

final class FormatParser {
    private static final CharMatcher LIKELY_NUMERIC_MATCHER = CharMatcher.inRange('0', '9').or(CharMatcher.is('-'));
    private static final ImmutableSet<Character> ILLEGAL_IN_FIELD = ImmutableSet.of(Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf(','));

    FormatParser() {
    }

    String format(String input, List<Object> args, Map<String, Object> kwargs, StarlarkSemantics semantics) throws EvalException {
        char[] chars = input.toCharArray();
        StringBuilder output = new StringBuilder();
        History history = new History();
        for (int pos = 0; pos < chars.length; ++pos) {
            char current = chars[pos];
            int advancePos = 0;
            if (current == '{') {
                advancePos = this.processOpeningBrace(chars, pos, args, kwargs, history, output, semantics);
            } else if (current == '}') {
                advancePos = this.processClosingBrace(chars, pos, output);
            } else {
                output.append(current);
            }
            pos += advancePos;
        }
        return output.toString();
    }

    private int processOpeningBrace(char[] chars, int pos, List<Object> args, Map<String, Object> kwargs, History history, StringBuilder output, StarlarkSemantics semantics) throws EvalException {
        Printer printer = new Printer(output);
        if (FormatParser.has(chars, pos + 1, '{')) {
            printer.append("{");
            return 1;
        }
        String key = this.getFieldName(chars, pos);
        Object value = null;
        try {
            if (key.isEmpty() || LIKELY_NUMERIC_MATCHER.matchesAllOf(key)) {
                int index = this.parsePositional(key, history);
                if (index < 0 || index >= args.size()) {
                    throw Starlark.errorf("No replacement found for index %d", index);
                }
                value = args.get(index);
            } else {
                value = this.getKwarg(kwargs, key);
            }
        }
        catch (NumberFormatException nfe) {
            value = this.getKwarg(kwargs, key);
        }
        printer.str(value, semantics);
        return key.length() + 1;
    }

    private Object getKwarg(Map<String, Object> kwargs, String key) throws EvalException {
        if (!kwargs.containsKey(key)) {
            throw Starlark.errorf("Missing argument '%s'", key);
        }
        return kwargs.get(key);
    }

    private int processClosingBrace(char[] chars, int pos, StringBuilder output) throws EvalException {
        if (!FormatParser.has(chars, pos + 1, '}')) {
            throw Starlark.errorf("Found '}' without matching '{'", new Object[0]);
        }
        output.append("}");
        return 1;
    }

    private static boolean has(char[] data, int pos, char needle) {
        return pos < data.length && data[pos] == needle;
    }

    private String getFieldName(char[] chars, int openingBrace) throws EvalException {
        StringBuilder result = new StringBuilder();
        boolean foundClosingBrace = false;
        for (int pos = openingBrace + 1; pos < chars.length; ++pos) {
            char current = chars[pos];
            if (current == '}') {
                foundClosingBrace = true;
                break;
            }
            if (current == '{') {
                throw Starlark.errorf("Nested replacement fields are not supported", new Object[0]);
            }
            if (ILLEGAL_IN_FIELD.contains(Character.valueOf(current))) {
                throw Starlark.errorf("Invalid character '%s' inside replacement field", Character.valueOf(current));
            }
            result.append(current);
        }
        if (!foundClosingBrace) {
            throw Starlark.errorf("Found '{' without matching '}'", new Object[0]);
        }
        return result.toString();
    }

    private int parsePositional(String key, History history) throws EvalException {
        int result = -1;
        try {
            if (key.isEmpty()) {
                history.setAutomaticPositional();
                result = history.getNextPosition();
            } else {
                result = Integer.parseInt(key);
                history.setManualPositional();
            }
        }
        catch (MixedTypeException mte) {
            throw Starlark.errorf("%s", mte.getMessage());
        }
        return result;
    }

    private static final class History {
        Positional type = Positional.NONE;
        int position = -1;

        private History() {
        }

        int getNextPosition() {
            ++this.position;
            return this.position;
        }

        void setManualPositional() throws MixedTypeException {
            this.setPositional(Positional.MANUAL);
        }

        void setAutomaticPositional() throws MixedTypeException {
            this.setPositional(Positional.AUTOMATIC);
        }

        void setPositional(Positional current) throws MixedTypeException {
            if (this.type == Positional.NONE) {
                this.type = current;
            } else if (this.type != current) {
                throw new MixedTypeException();
            }
        }

        static enum Positional {
            NONE,
            MANUAL,
            AUTOMATIC;

        }
    }

    private static final class MixedTypeException
    extends Exception {
        MixedTypeException() {
            super("Cannot mix manual and automatic numbering of positional fields");
        }
    }
}

