/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import net.starlark.java.eval.GuardedValue;
import net.starlark.java.eval.StarlarkSemantics;

public final class FlagGuardedValue {
    public static GuardedValue onlyWhenExperimentalFlagIsTrue(final String flag, final Object obj) {
        if (flag.charAt(0) != '-' && flag.charAt(0) != '+') {
            throw new IllegalArgumentException(String.format("flag needs [+-] prefix: %s", flag));
        }
        return new GuardedValue(){

            @Override
            public Object getObject() {
                return obj;
            }

            @Override
            public String getErrorFromAttemptingAccess(String name) {
                return name + " is experimental and thus unavailable with the current flags. It may be enabled by setting --" + flag.substring(1);
            }

            @Override
            public boolean isObjectAccessibleUsingSemantics(StarlarkSemantics semantics, Object clientData) {
                return semantics.isFeatureEnabledBasedOnTogglingFlags(flag, "");
            }
        };
    }

    public static GuardedValue onlyWhenIncompatibleFlagIsFalse(final String flag, final Object obj) {
        if (flag.charAt(0) != '-' && flag.charAt(0) != '+') {
            throw new IllegalArgumentException(String.format("flag needs [+-] prefix: %s", flag));
        }
        return new GuardedValue(){

            @Override
            public Object getObject() {
                return obj;
            }

            @Override
            public String getErrorFromAttemptingAccess(String name) {
                return name + " is deprecated and will be removed soon. It may be temporarily re-enabled by setting --" + flag.substring(1) + "=false";
            }

            @Override
            public boolean isObjectAccessibleUsingSemantics(StarlarkSemantics semantics, Object clientData) {
                return semantics.isFeatureEnabledBasedOnTogglingFlags("", flag);
            }
        };
    }

    private FlagGuardedValue() {
    }
}

