/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import java.util.IllegalFormatException;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.HasBinary;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkFloat;
import net.starlark.java.eval.StarlarkIndexable;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StringModule;
import net.starlark.java.eval.Structure;
import net.starlark.java.eval.Tuple;
import net.starlark.java.syntax.TokenKind;

final class EvalUtils {
    private EvalUtils() {
    }

    static void addIterator(Object x) {
        if (x instanceof Mutability.Freezable) {
            ((Mutability.Freezable)x).updateIteratorCount(1);
        }
    }

    static void removeIterator(Object x) {
        if (x instanceof Mutability.Freezable) {
            ((Mutability.Freezable)x).updateIteratorCount(-1);
        }
    }

    static int getSequenceIndex(int index, int length) throws EvalException {
        int actualIndex = index;
        if (actualIndex < 0) {
            actualIndex += length;
        }
        if (actualIndex < 0 || actualIndex >= length) {
            throw Starlark.errorf("index out of range (index is %d, but sequence has %d elements)", index, length);
        }
        return actualIndex;
    }

    static int toIndex(int index, int length) {
        if (index < 0) {
            index += length;
        }
        if (index < 0) {
            return 0;
        }
        if (index > length) {
            return length;
        }
        return index;
    }

    static Object binaryOp(TokenKind op, Object x, Object y, StarlarkThread starlarkThread) throws EvalException {
        Object z;
        StarlarkSemantics semantics = starlarkThread.getSemantics();
        Mutability mu = starlarkThread.mutability();
        switch (op) {
            case PLUS: {
                if (x instanceof StarlarkInt) {
                    if (y instanceof StarlarkInt) {
                        return StarlarkInt.add((StarlarkInt)x, (StarlarkInt)y);
                    }
                    if (!(y instanceof StarlarkFloat)) break;
                    double z2 = ((StarlarkInt)x).toFiniteDouble() + ((StarlarkFloat)y).toDouble();
                    return StarlarkFloat.of(z2);
                }
                if (x instanceof String) {
                    if (!(y instanceof String)) break;
                    return (String)x + (String)y;
                }
                if (x instanceof Tuple) {
                    if (!(y instanceof Tuple)) break;
                    return Tuple.concat((Tuple)x, (Tuple)y);
                }
                if (x instanceof StarlarkList) {
                    if (!(y instanceof StarlarkList)) break;
                    return StarlarkList.concat((StarlarkList)x, (StarlarkList)y, mu);
                }
                if (!(x instanceof StarlarkFloat)) break;
                double xf = ((StarlarkFloat)x).toDouble();
                if (y instanceof StarlarkFloat) {
                    double z3 = xf + ((StarlarkFloat)y).toDouble();
                    return StarlarkFloat.of(z3);
                }
                if (!(y instanceof StarlarkInt)) break;
                double z4 = xf + ((StarlarkInt)y).toFiniteDouble();
                return StarlarkFloat.of(z4);
            }
            case PIPE: {
                if (x instanceof StarlarkInt) {
                    if (!(y instanceof StarlarkInt)) break;
                    return StarlarkInt.or((StarlarkInt)x, (StarlarkInt)y);
                }
                if (!(x instanceof Map) || !(y instanceof Map)) break;
                return Dict.builder().putAll((Map)x).putAll((Map)y).build(mu);
            }
            case AMPERSAND: {
                if (!(x instanceof StarlarkInt) || !(y instanceof StarlarkInt)) break;
                return StarlarkInt.and((StarlarkInt)x, (StarlarkInt)y);
            }
            case CARET: {
                if (!(x instanceof StarlarkInt) || !(y instanceof StarlarkInt)) break;
                return StarlarkInt.xor((StarlarkInt)x, (StarlarkInt)y);
            }
            case GREATER_GREATER: {
                if (!(x instanceof StarlarkInt) || !(y instanceof StarlarkInt)) break;
                return StarlarkInt.shiftRight((StarlarkInt)x, (StarlarkInt)y);
            }
            case LESS_LESS: {
                if (!(x instanceof StarlarkInt) || !(y instanceof StarlarkInt)) break;
                return StarlarkInt.shiftLeft((StarlarkInt)x, (StarlarkInt)y);
            }
            case MINUS: {
                if (x instanceof StarlarkInt) {
                    if (y instanceof StarlarkInt) {
                        return StarlarkInt.subtract((StarlarkInt)x, (StarlarkInt)y);
                    }
                    if (!(y instanceof StarlarkFloat)) break;
                    double z5 = ((StarlarkInt)x).toFiniteDouble() - ((StarlarkFloat)y).toDouble();
                    return StarlarkFloat.of(z5);
                }
                if (!(x instanceof StarlarkFloat)) break;
                double xf = ((StarlarkFloat)x).toDouble();
                if (y instanceof StarlarkFloat) {
                    double z6 = xf - ((StarlarkFloat)y).toDouble();
                    return StarlarkFloat.of(z6);
                }
                if (!(y instanceof StarlarkInt)) break;
                double z7 = xf - ((StarlarkInt)y).toFiniteDouble();
                return StarlarkFloat.of(z7);
            }
            case STAR: {
                if (x instanceof StarlarkInt) {
                    StarlarkInt xi = (StarlarkInt)x;
                    if (y instanceof StarlarkInt) {
                        return StarlarkInt.multiply(xi, (StarlarkInt)y);
                    }
                    if (y instanceof String) {
                        return EvalUtils.repeatString((String)y, xi);
                    }
                    if (y instanceof Tuple) {
                        return ((Tuple)y).repeat(xi);
                    }
                    if (y instanceof StarlarkList) {
                        return ((StarlarkList)y).repeat(xi, mu);
                    }
                    if (!(y instanceof StarlarkFloat)) break;
                    double z8 = xi.toFiniteDouble() * ((StarlarkFloat)y).toDouble();
                    return StarlarkFloat.of(z8);
                }
                if (x instanceof String) {
                    if (!(y instanceof StarlarkInt)) break;
                    return EvalUtils.repeatString((String)x, (StarlarkInt)y);
                }
                if (x instanceof Tuple) {
                    if (!(y instanceof StarlarkInt)) break;
                    return ((Tuple)x).repeat((StarlarkInt)y);
                }
                if (x instanceof StarlarkList) {
                    if (!(y instanceof StarlarkInt)) break;
                    return ((StarlarkList)x).repeat((StarlarkInt)y, mu);
                }
                if (!(x instanceof StarlarkFloat)) break;
                double xf = ((StarlarkFloat)x).toDouble();
                if (y instanceof StarlarkFloat) {
                    return StarlarkFloat.of(xf * ((StarlarkFloat)y).toDouble());
                }
                if (!(y instanceof StarlarkInt)) break;
                return StarlarkFloat.of(xf * ((StarlarkInt)y).toFiniteDouble());
            }
            case SLASH: {
                if (x instanceof StarlarkInt) {
                    double xf = ((StarlarkInt)x).toFiniteDouble();
                    if (y instanceof StarlarkInt) {
                        return StarlarkFloat.div(xf, ((StarlarkInt)y).toFiniteDouble());
                    }
                    if (!(y instanceof StarlarkFloat)) break;
                    return StarlarkFloat.div(xf, ((StarlarkFloat)y).toDouble());
                }
                if (!(x instanceof StarlarkFloat)) break;
                double xf = ((StarlarkFloat)x).toDouble();
                if (y instanceof StarlarkFloat) {
                    return StarlarkFloat.div(xf, ((StarlarkFloat)y).toDouble());
                }
                if (!(y instanceof StarlarkInt)) break;
                return StarlarkFloat.div(xf, ((StarlarkInt)y).toFiniteDouble());
            }
            case SLASH_SLASH: {
                if (x instanceof StarlarkInt) {
                    if (y instanceof StarlarkInt) {
                        return StarlarkInt.floordiv((StarlarkInt)x, (StarlarkInt)y);
                    }
                    if (!(y instanceof StarlarkFloat)) break;
                    double xf = ((StarlarkInt)x).toFiniteDouble();
                    double yf = ((StarlarkFloat)y).toDouble();
                    return StarlarkFloat.floordiv(xf, yf);
                }
                if (!(x instanceof StarlarkFloat)) break;
                double xf = ((StarlarkFloat)x).toDouble();
                if (y instanceof StarlarkFloat) {
                    return StarlarkFloat.floordiv(xf, ((StarlarkFloat)y).toDouble());
                }
                if (!(y instanceof StarlarkInt)) break;
                return StarlarkFloat.floordiv(xf, ((StarlarkInt)y).toFiniteDouble());
            }
            case PERCENT: {
                if (x instanceof StarlarkInt) {
                    if (y instanceof StarlarkInt) {
                        return StarlarkInt.mod((StarlarkInt)x, (StarlarkInt)y);
                    }
                    if (!(y instanceof StarlarkFloat)) break;
                    double xf = ((StarlarkInt)x).toFiniteDouble();
                    double yf = ((StarlarkFloat)y).toDouble();
                    return StarlarkFloat.mod(xf, yf);
                }
                if (x instanceof String) {
                    String xs = (String)x;
                    try {
                        if (y instanceof Tuple) {
                            return Starlark.formatWithList(semantics, xs, (Tuple)y);
                        }
                        return Starlark.format(semantics, xs, y);
                    }
                    catch (IllegalFormatException ex) {
                        throw new EvalException(ex);
                    }
                }
                if (!(x instanceof StarlarkFloat)) break;
                double xf = ((StarlarkFloat)x).toDouble();
                if (y instanceof StarlarkFloat) {
                    return StarlarkFloat.mod(xf, ((StarlarkFloat)y).toDouble());
                }
                if (!(y instanceof StarlarkInt)) break;
                return StarlarkFloat.mod(xf, ((StarlarkInt)y).toFiniteDouble());
            }
            case EQUALS_EQUALS: {
                return x.equals(y);
            }
            case NOT_EQUALS: {
                return !x.equals(y);
            }
            case LESS: {
                return EvalUtils.compare(x, y) < 0;
            }
            case LESS_EQUALS: {
                return EvalUtils.compare(x, y) <= 0;
            }
            case GREATER: {
                return EvalUtils.compare(x, y) > 0;
            }
            case GREATER_EQUALS: {
                return EvalUtils.compare(x, y) >= 0;
            }
            case IN: {
                if (y instanceof StarlarkIndexable) {
                    return ((StarlarkIndexable)y).containsKey(semantics, x);
                }
                if (y instanceof StarlarkIndexable.Threaded) {
                    return ((StarlarkIndexable.Threaded)y).containsKey(starlarkThread, semantics, x);
                }
                if (!(y instanceof String)) break;
                if (!(x instanceof String)) {
                    throw Starlark.errorf("'in <string>' requires string as left operand, not '%s'", Starlark.type(x));
                }
                return ((String)y).contains((String)x);
            }
            case NOT_IN: {
                Object z9 = EvalUtils.binaryOp(TokenKind.IN, x, y, starlarkThread);
                if (z9 == null) break;
                return !Starlark.truth(z9);
            }
            default: {
                throw new AssertionError((Object)("not a binary operator: " + op));
            }
        }
        if (x instanceof HasBinary && (z = ((HasBinary)x).binaryOp(op, y, true)) != null) {
            return z;
        }
        if (y instanceof HasBinary && (z = ((HasBinary)y).binaryOp(op, x, false)) != null) {
            return z;
        }
        throw Starlark.errorf("unsupported binary operation: %s %s %s", new Object[]{Starlark.type(x), op, Starlark.type(y)});
    }

    private static int compare(Object x, Object y) throws EvalException {
        try {
            return Starlark.compareUnchecked(x, y);
        }
        catch (ClassCastException ex) {
            throw new EvalException(ex.getMessage());
        }
    }

    private static String repeatString(String s2, StarlarkInt in) throws EvalException {
        int n = in.toInt("repeat");
        if (n <= 0) {
            return "";
        }
        if ((long)s2.length() * (long)n > Integer.MAX_VALUE) {
            throw Starlark.errorf("excessive repeat (%d * %d characters)", s2.length(), n);
        }
        return s2.repeat(n);
    }

    static Object unaryOp(TokenKind op, Object x) throws EvalException {
        switch (op) {
            case NOT: {
                return !Starlark.truth(x);
            }
            case MINUS: {
                if (x instanceof StarlarkInt) {
                    return StarlarkInt.uminus((StarlarkInt)x);
                }
                if (!(x instanceof StarlarkFloat)) break;
                return StarlarkFloat.of(-((StarlarkFloat)x).toDouble());
            }
            case PLUS: {
                if (x instanceof StarlarkInt) {
                    return x;
                }
                if (!(x instanceof StarlarkFloat)) break;
                return x;
            }
            case TILDE: {
                if (!(x instanceof StarlarkInt)) break;
                return StarlarkInt.bitnot((StarlarkInt)x);
            }
        }
        throw Starlark.errorf("unsupported unary operation: %s%s", new Object[]{op, Starlark.type(x)});
    }

    @Nullable
    static Object index(StarlarkThread starlarkThread, Object object, Object key) throws EvalException {
        Mutability mu = starlarkThread.mutability();
        StarlarkSemantics semantics = starlarkThread.getSemantics();
        if (object instanceof StarlarkIndexable.Threaded) {
            return ((StarlarkIndexable.Threaded)object).getIndex(starlarkThread, semantics, key);
        }
        if (object instanceof StarlarkIndexable) {
            Object result = ((StarlarkIndexable)object).getIndex(semantics, key);
            return result == null ? null : Starlark.fromJava(result, mu);
        }
        if (object instanceof String) {
            String string = (String)object;
            int index = Starlark.toInt(key, "string index");
            index = EvalUtils.getSequenceIndex(index, string.length());
            return StringModule.memoizedCharToString(string.charAt(index));
        }
        throw Starlark.errorf("type '%s' has no operator [](%s)", Starlark.type(object), Starlark.type(key));
    }

    static void setIndex(Object object, Object key, Object value) throws EvalException {
        if (object instanceof Dict) {
            Dict dict = (Dict)object;
            dict.putEntry(key, value);
        } else if (object instanceof StarlarkList) {
            StarlarkList list = (StarlarkList)object;
            int index = Starlark.toInt(key, "list index");
            index = EvalUtils.getSequenceIndex(index, list.size());
            list.setElementAt(index, value);
        } else {
            throw Starlark.errorf("can only assign an element in a dictionary or a list, not in a '%s'", Starlark.type(object));
        }
    }

    static void setField(Object x, String field, Object value) throws EvalException {
        if (!(x instanceof Structure)) {
            throw Starlark.errorf("cannot set .%s field of %s value", field, Starlark.type(x));
        }
        ((Structure)x).setField(field, value);
    }
}

