/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.EvalUtils;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkFloat;
import net.starlark.java.eval.StarlarkFunction;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkIterable;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.Tuple;
import net.starlark.java.spelling.SpellChecker;
import net.starlark.java.syntax.Argument;
import net.starlark.java.syntax.AssignmentStatement;
import net.starlark.java.syntax.BinaryOperatorExpression;
import net.starlark.java.syntax.CallExpression;
import net.starlark.java.syntax.Comprehension;
import net.starlark.java.syntax.ConditionalExpression;
import net.starlark.java.syntax.DefStatement;
import net.starlark.java.syntax.DictExpression;
import net.starlark.java.syntax.DotExpression;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.ExpressionStatement;
import net.starlark.java.syntax.FloatLiteral;
import net.starlark.java.syntax.FlowStatement;
import net.starlark.java.syntax.ForStatement;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.IfStatement;
import net.starlark.java.syntax.IndexExpression;
import net.starlark.java.syntax.IntLiteral;
import net.starlark.java.syntax.LambdaExpression;
import net.starlark.java.syntax.ListExpression;
import net.starlark.java.syntax.LoadStatement;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.Parameter;
import net.starlark.java.syntax.Resolver;
import net.starlark.java.syntax.ReturnStatement;
import net.starlark.java.syntax.SliceExpression;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.StringLiteral;
import net.starlark.java.syntax.TokenKind;
import net.starlark.java.syntax.UnaryOperatorExpression;

final class Eval {
    private static final Object[] EMPTY = new Object[0];

    private Eval() {
    }

    static Object execFunctionBody(StarlarkThread.Frame fr, List<Statement> statements) throws EvalException, InterruptedException {
        fr.thread.checkInterrupt();
        Eval.execStatements(fr, statements, false);
        return fr.result;
    }

    private static StarlarkFunction fn(StarlarkThread.Frame fr) {
        return (StarlarkFunction)fr.fn;
    }

    private static TokenKind execStatements(StarlarkThread.Frame fr, List<Statement> statements, boolean indented) throws EvalException, InterruptedException {
        boolean isToplevelFunction = Eval.fn(fr).isToplevel();
        for (int i = 0; i < statements.size(); ++i) {
            Statement stmt = statements.get(i);
            TokenKind flow = Eval.exec(fr, stmt);
            if (flow != TokenKind.PASS) {
                return flow;
            }
            if (!isToplevelFunction || indented || fr.thread.postAssignHook == null || !(stmt instanceof AssignmentStatement)) continue;
            AssignmentStatement assign = (AssignmentStatement)stmt;
            for (Identifier id : Identifier.boundIdentifiers(assign.getLHS())) {
                Object value = Eval.fn(fr).getGlobal(id.getBinding().getIndex());
                fr.thread.postAssignHook.assign(id.getName(), value);
            }
        }
        return TokenKind.PASS;
    }

    private static void execAssignment(StarlarkThread.Frame fr, AssignmentStatement node) throws EvalException, InterruptedException {
        try {
            if (node.isAugmented()) {
                Eval.execAugmentedAssignment(fr, node);
            } else {
                Object rvalue = Eval.eval(fr, node.getRHS());
                Eval.assign(fr, node.getLHS(), rvalue);
            }
        }
        catch (EvalException ex) {
            fr.setErrorLocation(node.getOperatorLocation());
            throw ex;
        }
    }

    private static TokenKind execFor(StarlarkThread.Frame fr, ForStatement node) throws EvalException, InterruptedException {
        Iterable<?> seq = Eval.evalAsIterable(fr, node.getCollection());
        EvalUtils.addIterator(seq);
        try {
            block12: for (Object it : seq) {
                Eval.assign(fr, node.getVars(), it);
                switch (Eval.execStatements(fr, node.getBody(), true)) {
                    case PASS: 
                    case CONTINUE: {
                        fr.thread.checkInterrupt();
                        continue block12;
                    }
                    case BREAK: {
                        TokenKind tokenKind = TokenKind.PASS;
                        return tokenKind;
                    }
                    case RETURN: {
                        TokenKind tokenKind = TokenKind.RETURN;
                        return tokenKind;
                    }
                }
                throw new IllegalStateException("unreachable");
            }
        }
        catch (EvalException ex) {
            fr.setErrorLocation(node.getStartLocation());
            throw ex;
        }
        finally {
            EvalUtils.removeIterator(seq);
        }
        return TokenKind.PASS;
    }

    private static StarlarkFunction newFunction(StarlarkThread.Frame fr, Resolver.Function rfn) throws EvalException, InterruptedException {
        Object[] defaults = null;
        int nparams = rfn.getParameters().size() - (rfn.hasKwargs() ? 1 : 0) - (rfn.hasVarargs() ? 1 : 0);
        for (int i = 0; i < nparams; ++i) {
            Expression expr = ((Parameter)rfn.getParameters().get(i)).getDefaultValue();
            if (expr == null && defaults == null) continue;
            if (defaults == null) {
                defaults = new Object[nparams - i];
            }
            defaults[i - (nparams - defaults.length)] = expr == null ? StarlarkFunction.MANDATORY : Eval.eval(fr, expr);
        }
        if (defaults == null) {
            defaults = EMPTY;
        }
        Object[] freevars = new Object[rfn.getFreeVars().size()];
        int i = 0;
        block5: for (Resolver.Binding bind : rfn.getFreeVars()) {
            switch (bind.getScope()) {
                case FREE: {
                    freevars[i++] = Eval.fn(fr).getFreeVar(bind.getIndex());
                    continue block5;
                }
                case CELL: {
                    freevars[i++] = fr.locals[bind.getIndex()];
                    continue block5;
                }
            }
            throw new IllegalStateException("unexpected: " + bind);
        }
        StarlarkFunction fn = Eval.fn(fr);
        return new StarlarkFunction(rfn, fn.getModule(), fn.globalIndex, Tuple.wrap(defaults), Tuple.wrap(freevars));
    }

    private static TokenKind execIf(StarlarkThread.Frame fr, IfStatement node) throws EvalException, InterruptedException {
        boolean cond = Starlark.truth(Eval.eval(fr, node.getCondition()));
        if (cond) {
            return Eval.execStatements(fr, node.getThenBlock(), true);
        }
        if (node.getElseBlock() != null) {
            return Eval.execStatements(fr, node.getElseBlock(), true);
        }
        return TokenKind.PASS;
    }

    private static void execLoad(StarlarkThread.Frame fr, LoadStatement node) throws EvalException {
        StarlarkThread.Loader loader = fr.thread.getLoader();
        if (loader == null) {
            fr.setErrorLocation(node.getStartLocation());
            throw Starlark.errorf("load statements may not be executed in this thread", new Object[0]);
        }
        String moduleName = node.getImport().getValue();
        Module module = loader.load(moduleName);
        if (module == null) {
            fr.setErrorLocation(node.getStartLocation());
            throw Starlark.errorf("module '%s' not found", moduleName);
        }
        for (LoadStatement.Binding binding : node.getBindings()) {
            Identifier orig = binding.getOriginalName();
            Object value = module.getGlobal(orig.getName());
            if (value == null) {
                fr.setErrorLocation(orig.getStartLocation());
                throw Starlark.errorf("file '%s' does not contain symbol '%s'%s", moduleName, orig.getName(), SpellChecker.didYouMean(orig.getName(), module.getGlobals().keySet()));
            }
            Eval.assignIdentifier(fr, binding.getLocalName(), value);
        }
    }

    private static TokenKind execReturn(StarlarkThread.Frame fr, ReturnStatement node) throws EvalException, InterruptedException {
        Expression result = node.getResult();
        if (result != null) {
            fr.result = Eval.eval(fr, result);
        }
        return TokenKind.RETURN;
    }

    private static TokenKind exec(StarlarkThread.Frame fr, Statement st) throws EvalException, InterruptedException {
        if (fr.dbg != null) {
            Location loc = st.getStartLocation();
            fr.setLocation(loc);
            fr.dbg.before(fr.thread, loc);
        }
        if (++fr.thread.steps >= fr.thread.stepLimit) {
            throw new EvalException("Starlark computation cancelled: too many steps");
        }
        switch (st.kind()) {
            case ASSIGNMENT: {
                Eval.execAssignment(fr, (AssignmentStatement)st);
                return TokenKind.PASS;
            }
            case EXPRESSION: {
                Eval.eval(fr, ((ExpressionStatement)st).getExpression());
                return TokenKind.PASS;
            }
            case FLOW: {
                return ((FlowStatement)st).getFlowKind();
            }
            case FOR: {
                return Eval.execFor(fr, (ForStatement)st);
            }
            case DEF: {
                DefStatement def = (DefStatement)st;
                StarlarkFunction fn = Eval.newFunction(fr, def.getResolvedFunction());
                Eval.assignIdentifier(fr, def.getIdentifier(), fn);
                return TokenKind.PASS;
            }
            case IF: {
                return Eval.execIf(fr, (IfStatement)st);
            }
            case LOAD: {
                Eval.execLoad(fr, (LoadStatement)st);
                return TokenKind.PASS;
            }
            case RETURN: {
                return Eval.execReturn(fr, (ReturnStatement)st);
            }
        }
        throw new IllegalArgumentException("unexpected statement: " + st.kind());
    }

    private static void assign(StarlarkThread.Frame fr, Expression lhs, Object value) throws EvalException, InterruptedException {
        if (lhs instanceof Identifier) {
            Eval.assignIdentifier(fr, (Identifier)lhs, value);
        } else if (lhs instanceof IndexExpression) {
            Object object = Eval.eval(fr, ((IndexExpression)lhs).getObject());
            Object key = Eval.eval(fr, ((IndexExpression)lhs).getKey());
            EvalUtils.setIndex(object, key, value);
        } else if (lhs instanceof ListExpression) {
            ListExpression list = (ListExpression)lhs;
            Eval.assignSequence(fr, list.getElements(), value);
        } else if (lhs instanceof DotExpression) {
            DotExpression dot = (DotExpression)lhs;
            Object object = Eval.eval(fr, dot.getObject());
            String field = dot.getField().getName();
            try {
                EvalUtils.setField(object, field, value);
            }
            catch (EvalException ex) {
                fr.setErrorLocation(dot.getDotLocation());
                throw ex;
            }
        } else {
            throw Starlark.errorf("cannot assign to '%s'", lhs);
        }
    }

    private static void assignIdentifier(StarlarkThread.Frame fr, Identifier id, Object value) throws EvalException {
        Resolver.Binding bind = id.getBinding();
        switch (bind.getScope()) {
            case LOCAL: {
                fr.locals[bind.getIndex()] = value;
                break;
            }
            case CELL: {
                ((StarlarkFunction.Cell)fr.locals[bind.getIndex()]).x = value;
                break;
            }
            case GLOBAL: {
                Eval.fn(fr).setGlobal(bind.getIndex(), value);
                break;
            }
            default: {
                throw new IllegalStateException(bind.getScope().toString());
            }
        }
    }

    private static void assignSequence(StarlarkThread.Frame fr, List<Expression> lhs, Object x) throws EvalException, InterruptedException {
        int nrhs = Starlark.len(x);
        int nlhs = lhs.size();
        if (nrhs < 0 || x instanceof String) {
            throw Starlark.errorf("got '%s' in sequence assignment (want %d-element sequence)", Starlark.type(x), nlhs);
        }
        Iterable<?> rhs = Starlark.toIterable(x);
        if (nlhs != nrhs) {
            throw Starlark.errorf("too %s values to unpack (got %d, want %d)", nrhs < nlhs ? "few" : "many", nrhs, nlhs);
        }
        int i = 0;
        for (Object item : rhs) {
            Eval.assign(fr, lhs.get(i), item);
            ++i;
        }
    }

    private static void execAugmentedAssignment(StarlarkThread.Frame fr, AssignmentStatement stmt) throws EvalException, InterruptedException {
        Expression lhs = stmt.getLHS();
        TokenKind op = stmt.getOperator();
        Expression rhs = stmt.getRHS();
        if (lhs instanceof Identifier) {
            Object z;
            Object x = Eval.eval(fr, lhs);
            Object y = Eval.eval(fr, rhs);
            try {
                z = Eval.inplaceBinaryOp(fr, op, x, y);
            }
            catch (EvalException ex) {
                fr.setErrorLocation(stmt.getOperatorLocation());
                throw ex;
            }
            Eval.assignIdentifier(fr, (Identifier)lhs, z);
        } else {
            if (lhs instanceof IndexExpression) {
                Object z;
                IndexExpression index = (IndexExpression)lhs;
                Object object = Eval.eval(fr, index.getObject());
                Object key = Eval.eval(fr, index.getKey());
                Object x = EvalUtils.index(fr.thread, object, key);
                Object y = Eval.eval(fr, rhs);
                try {
                    z = Eval.inplaceBinaryOp(fr, op, x, y);
                }
                catch (EvalException ex) {
                    fr.setErrorLocation(stmt.getOperatorLocation());
                    throw ex;
                }
                try {
                    EvalUtils.setIndex(object, key, z);
                }
                catch (EvalException ex) {
                    fr.setErrorLocation(stmt.getOperatorLocation());
                    throw ex;
                }
            }
            if (lhs instanceof DotExpression) {
                DotExpression dot = (DotExpression)lhs;
                Object object = Eval.eval(fr, dot.getObject());
                String field = dot.getField().getName();
                try {
                    Object z;
                    Object x = Starlark.getattr(fr.thread.mutability(), fr.thread.getSemantics(), object, field, null);
                    Object y = Eval.eval(fr, rhs);
                    try {
                        z = Eval.inplaceBinaryOp(fr, op, x, y);
                    }
                    catch (EvalException ex) {
                        fr.setErrorLocation(stmt.getOperatorLocation());
                        throw ex;
                    }
                    EvalUtils.setField(object, field, z);
                }
                catch (EvalException ex) {
                    fr.setErrorLocation(dot.getDotLocation());
                    throw ex;
                }
            }
            fr.setErrorLocation(stmt.getOperatorLocation());
            throw Starlark.errorf("cannot perform augmented assignment on '%s'", lhs);
        }
    }

    private static Object inplaceBinaryOp(StarlarkThread.Frame fr, TokenKind op, Object x, Object y) throws EvalException {
        if (op == TokenKind.PLUS && x instanceof StarlarkList && y instanceof StarlarkList) {
            StarlarkList list = (StarlarkList)x;
            list.extend(y);
            return list;
        }
        if (op == TokenKind.PIPE && x instanceof Dict && y instanceof Map) {
            Dict xDict = (Dict)x;
            Map yMap = (Map)y;
            xDict.putEntries(yMap);
            return xDict;
        }
        return EvalUtils.binaryOp(op, x, y, fr.thread);
    }

    private static Object eval(StarlarkThread.Frame fr, Expression expr) throws EvalException, InterruptedException {
        if (++fr.thread.steps >= fr.thread.stepLimit) {
            throw new EvalException("Starlark computation cancelled: too many steps");
        }
        switch (expr.kind()) {
            case BINARY_OPERATOR: {
                return Eval.evalBinaryOperator(fr, (BinaryOperatorExpression)expr);
            }
            case COMPREHENSION: {
                return Eval.evalComprehension(fr, (Comprehension)expr);
            }
            case CONDITIONAL: {
                return Eval.evalConditional(fr, (ConditionalExpression)expr);
            }
            case DICT_EXPR: {
                return Eval.evalDict(fr, (DictExpression)expr);
            }
            case DOT: {
                return Eval.evalDot(fr, (DotExpression)expr);
            }
            case CALL: {
                return Eval.evalCall(fr, (CallExpression)expr);
            }
            case IDENTIFIER: {
                return Eval.evalIdentifier(fr, (Identifier)expr);
            }
            case INDEX: {
                return Eval.evalIndex(fr, (IndexExpression)expr);
            }
            case INT_LITERAL: {
                Number n = ((IntLiteral)expr).getValue();
                if (n instanceof Integer) {
                    return StarlarkInt.of((Integer)n);
                }
                if (n instanceof Long) {
                    return StarlarkInt.of((Long)n);
                }
                return StarlarkInt.of((BigInteger)n);
            }
            case FLOAT_LITERAL: {
                return StarlarkFloat.of(((FloatLiteral)expr).getValue());
            }
            case LAMBDA: {
                return Eval.newFunction(fr, ((LambdaExpression)expr).getResolvedFunction());
            }
            case LIST_EXPR: {
                return Eval.evalList(fr, (ListExpression)expr);
            }
            case SLICE: {
                return Eval.evalSlice(fr, (SliceExpression)expr);
            }
            case STRING_LITERAL: {
                return ((StringLiteral)expr).getValue();
            }
            case UNARY_OPERATOR: {
                return Eval.evalUnaryOperator(fr, (UnaryOperatorExpression)expr);
            }
        }
        throw new IllegalArgumentException("unexpected expression: " + expr.kind());
    }

    private static Object evalBinaryOperator(StarlarkThread.Frame fr, BinaryOperatorExpression binop) throws EvalException, InterruptedException {
        Object x = Eval.eval(fr, binop.getX());
        switch (binop.getOperator()) {
            case AND: {
                return Starlark.truth(x) ? Eval.eval(fr, binop.getY()) : x;
            }
            case OR: {
                return Starlark.truth(x) ? x : Eval.eval(fr, binop.getY());
            }
        }
        Object y = Eval.eval(fr, binop.getY());
        try {
            return EvalUtils.binaryOp(binop.getOperator(), x, y, fr.thread);
        }
        catch (EvalException ex) {
            fr.setErrorLocation(binop.getOperatorLocation());
            throw ex;
        }
    }

    private static Object evalConditional(StarlarkThread.Frame fr, ConditionalExpression cond) throws EvalException, InterruptedException {
        Object v = Eval.eval(fr, cond.getCondition());
        return Eval.eval(fr, Starlark.truth(v) ? cond.getThenCase() : cond.getElseCase());
    }

    private static Object evalDict(StarlarkThread.Frame fr, DictExpression dictexpr) throws EvalException, InterruptedException {
        Dict<Object, Object> dict = Dict.of(fr.thread.mutability());
        for (DictExpression.Entry entry : dictexpr.getEntries()) {
            Object k = Eval.eval(fr, entry.getKey());
            Object v = Eval.eval(fr, entry.getValue());
            int before = dict.size();
            try {
                dict.putEntry(k, v);
            }
            catch (EvalException ex) {
                fr.setErrorLocation(entry.getColonLocation());
                throw ex;
            }
            if (dict.size() != before) continue;
            fr.setErrorLocation(entry.getColonLocation());
            throw Starlark.errorf("dictionary expression has duplicate key: %s", Starlark.repr(k));
        }
        return dict;
    }

    private static Object evalDot(StarlarkThread.Frame fr, DotExpression dot) throws EvalException, InterruptedException {
        Object object = Eval.eval(fr, dot.getObject());
        String name = dot.getField().getName();
        try {
            return Starlark.getattr(fr.thread.mutability(), fr.thread.getSemantics(), object, name, null);
        }
        catch (EvalException ex) {
            fr.setErrorLocation(dot.getDotLocation());
            throw ex;
        }
    }

    private static Object evalCall(StarlarkThread.Frame fr, CallExpression call) throws EvalException, InterruptedException {
        int i;
        int npos;
        fr.thread.checkInterrupt();
        Object fn = Eval.eval(fr, call.getFunction());
        ImmutableList<Argument> arguments = call.getArguments();
        int n = arguments.size();
        Argument.StarStar starstar = null;
        if (n > 0 && arguments.get(n - 1) instanceof Argument.StarStar) {
            starstar = (Argument.StarStar)arguments.get(n - 1);
            --n;
        }
        Argument.Star star = null;
        if (n > 0 && arguments.get(n - 1) instanceof Argument.Star) {
            star = (Argument.Star)arguments.get(n - 1);
            --n;
        }
        Object[] positional = (npos = call.getNumPositionalArguments()) == 0 ? EMPTY : new Object[npos];
        for (i = 0; i < npos; ++i) {
            Object value;
            Argument arg = (Argument)arguments.get(i);
            positional[i] = value = Eval.eval(fr, arg.getValue());
        }
        Object[] named = n == npos ? EMPTY : new Object[2 * (n - npos)];
        int j = 0;
        while (i < n) {
            Argument.Keyword arg = (Argument.Keyword)arguments.get(i);
            Object value = Eval.eval(fr, arg.getValue());
            named[j++] = arg.getName();
            named[j++] = value;
            ++i;
        }
        if (star != null) {
            Object value = Eval.eval(fr, star.getValue());
            if (!(value instanceof StarlarkIterable)) {
                fr.setErrorLocation(star.getStartLocation());
                throw Starlark.errorf("argument after * must be an iterable, not %s", Starlark.type(value));
            }
            ArrayList list = new ArrayList();
            Collections.addAll(list, positional);
            Iterables.addAll(list, (Iterable)value);
            positional = list.toArray();
        }
        if (starstar != null) {
            Object value = Eval.eval(fr, starstar.getValue());
            if (!(value instanceof Map)) {
                fr.setErrorLocation(starstar.getStartLocation());
                throw Starlark.errorf("argument after ** must be a dict, not %s", Starlark.type(value));
            }
            Map kwargs = (Map)value;
            int j2 = named.length;
            named = Arrays.copyOf(named, j2 + 2 * kwargs.size());
            for (Map.Entry e : kwargs.entrySet()) {
                if (!(e.getKey() instanceof String)) {
                    fr.setErrorLocation(starstar.getStartLocation());
                    throw Starlark.errorf("keywords must be strings, not %s", Starlark.type(e.getKey()));
                }
                named[j2++] = e.getKey();
                named[j2++] = e.getValue();
            }
        }
        Location loc = call.getLparenLocation();
        fr.setLocation(loc);
        try {
            return Starlark.fastcall(fr.thread, fn, positional, named);
        }
        catch (EvalException ex) {
            fr.setErrorLocation(loc);
            throw ex;
        }
    }

    private static Object evalIdentifier(StarlarkThread.Frame fr, Identifier id) throws EvalException, InterruptedException {
        Object result;
        Resolver.Binding bind = id.getBinding();
        switch (bind.getScope()) {
            case LOCAL: {
                result = fr.locals[bind.getIndex()];
                break;
            }
            case CELL: {
                result = ((StarlarkFunction.Cell)fr.locals[bind.getIndex()]).x;
                break;
            }
            case FREE: {
                result = Eval.fn((StarlarkThread.Frame)fr).getFreeVar((int)bind.getIndex()).x;
                break;
            }
            case GLOBAL: {
                result = Eval.fn(fr).getGlobal(bind.getIndex());
                break;
            }
            case PREDECLARED: {
                result = Eval.fn(fr).getModule().getPredeclared(id.getName());
                break;
            }
            case UNIVERSAL: {
                result = Starlark.UNIVERSE.get(id.getName());
                break;
            }
            default: {
                throw new IllegalStateException(bind.toString());
            }
        }
        if (result == null) {
            fr.setErrorLocation(id.getStartLocation());
            throw Starlark.errorf("%s variable '%s' is referenced before assignment.", new Object[]{bind.getScope(), id.getName()});
        }
        return result;
    }

    private static Object evalIndex(StarlarkThread.Frame fr, IndexExpression index) throws EvalException, InterruptedException {
        Object object = Eval.eval(fr, index.getObject());
        Object key = Eval.eval(fr, index.getKey());
        try {
            return EvalUtils.index(fr.thread, object, key);
        }
        catch (EvalException ex) {
            fr.setErrorLocation(index.getLbracketLocation());
            throw ex;
        }
    }

    private static Object evalList(StarlarkThread.Frame fr, ListExpression expr) throws EvalException, InterruptedException {
        int n = expr.getElements().size();
        Object[] array = new Object[n];
        for (int i = 0; i < n; ++i) {
            array[i] = Eval.eval(fr, expr.getElements().get(i));
        }
        return expr.isTuple() ? Tuple.wrap(array) : StarlarkList.wrap(fr.thread.mutability(), array);
    }

    private static Object evalSlice(StarlarkThread.Frame fr, SliceExpression slice) throws EvalException, InterruptedException {
        Object x = Eval.eval(fr, slice.getObject());
        NoneType start = slice.getStart() == null ? Starlark.NONE : Eval.eval(fr, slice.getStart());
        NoneType stop = slice.getStop() == null ? Starlark.NONE : Eval.eval(fr, slice.getStop());
        NoneType step = slice.getStep() == null ? Starlark.NONE : Eval.eval(fr, slice.getStep());
        try {
            return Starlark.slice(fr.thread.mutability(), x, start, stop, step);
        }
        catch (EvalException ex) {
            fr.setErrorLocation(slice.getLbracketLocation());
            throw ex;
        }
    }

    private static Object evalUnaryOperator(StarlarkThread.Frame fr, UnaryOperatorExpression unop) throws EvalException, InterruptedException {
        Object x = Eval.eval(fr, unop.getX());
        try {
            return EvalUtils.unaryOp(unop.getOperator(), x);
        }
        catch (EvalException ex) {
            fr.setErrorLocation(unop.getStartLocation());
            throw ex;
        }
    }

    private static Object evalComprehension(final StarlarkThread.Frame fr, final Comprehension comp) throws EvalException, InterruptedException {
        final Dict dict = comp.isDict() ? Dict.of(fr.thread.mutability()) : null;
        final StarlarkList list = comp.isDict() ? null : StarlarkList.newList(fr.thread.mutability());
        class Lambda {
            Lambda() {
            }

            void execClauses(int index) throws EvalException, InterruptedException {
                fr.thread.checkInterrupt();
                if (index < comp.getClauses().size()) {
                    Comprehension.Clause clause = (Comprehension.Clause)comp.getClauses().get(index);
                    if (clause instanceof Comprehension.For) {
                        Comprehension.For forClause = (Comprehension.For)clause;
                        Iterable<?> seq = Eval.evalAsIterable(fr, forClause.getIterable());
                        EvalUtils.addIterator(seq);
                        try {
                            for (Object elem : seq) {
                                Eval.assign(fr, forClause.getVars(), elem);
                                this.execClauses(index + 1);
                            }
                        }
                        catch (EvalException ex) {
                            fr.setErrorLocation(forClause.getStartLocation());
                            throw ex;
                        }
                        finally {
                            EvalUtils.removeIterator(seq);
                        }
                    } else {
                        Comprehension.If ifClause = (Comprehension.If)clause;
                        if (Starlark.truth(Eval.eval(fr, ifClause.getCondition()))) {
                            this.execClauses(index + 1);
                        }
                    }
                    return;
                }
                if (dict != null) {
                    DictExpression.Entry body = (DictExpression.Entry)comp.getBody();
                    Object k = Eval.eval(fr, body.getKey());
                    try {
                        Starlark.checkHashable(k);
                        Object v = Eval.eval(fr, body.getValue());
                        dict.putEntry(k, v);
                    }
                    catch (EvalException ex) {
                        fr.setErrorLocation(body.getColonLocation());
                        throw ex;
                    }
                } else {
                    list.addElement(Eval.eval(fr, (Expression)comp.getBody()));
                }
            }
        }
        new Lambda().execClauses(0);
        return comp.isDict() ? dict : list;
    }

    private static Iterable<?> evalAsIterable(StarlarkThread.Frame fr, Expression expr) throws EvalException, InterruptedException {
        Object o = Eval.eval(fr, expr);
        try {
            return Starlark.toIterable(o);
        }
        catch (EvalException ex) {
            fr.setErrorLocation(expr.getStartLocation());
            throw ex;
        }
    }
}

