/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.starlark.java.annot.StarlarkAnnotations;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.MethodDescriptor;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StringModule;

final class CallUtils {
    private static final ConcurrentHashMap<Key, CacheValue> cache = new ConcurrentHashMap();

    private CallUtils() {
    }

    private static CacheValue getCacheValue(Class<?> cls, StarlarkSemantics semantics) {
        CacheValue prev;
        Key key;
        CacheValue v;
        if (cls == String.class) {
            cls = StringModule.class;
        }
        if ((v = cache.get(key = new Key(cls, semantics))) == null && (prev = cache.putIfAbsent(key, v = CallUtils.buildCacheValue(key))) != null) {
            v = prev;
        }
        return v;
    }

    private static CacheValue buildCacheValue(Key key) {
        MethodDescriptor selfCall = null;
        ImmutableMap.Builder<String, MethodDescriptor> methods = ImmutableMap.builder();
        HashMap<String, MethodDescriptor> fields = new HashMap<String, MethodDescriptor>();
        Method[] classMethods = key.cls.getMethods();
        Arrays.sort(classMethods, Comparator.comparing(Method::getName));
        for (Method method : classMethods) {
            StarlarkMethod callable;
            if (method.isSynthetic() || (callable = StarlarkAnnotations.getStarlarkMethod(method)) == null || !key.semantics.isFeatureEnabledBasedOnTogglingFlags(callable.enableOnlyWithFlag(), callable.disableWithFlag())) continue;
            MethodDescriptor descriptor = MethodDescriptor.of(method, callable, key.semantics);
            if (callable.selfCall()) {
                if (selfCall != null) {
                    throw new IllegalArgumentException(String.format("Class %s has two selfCall methods defined", key.cls.getName()));
                }
                selfCall = descriptor;
                continue;
            }
            methods.put(callable.name(), descriptor);
            if (!descriptor.isStructField() || fields.put(callable.name(), descriptor) == null) continue;
            throw new IllegalArgumentException(String.format("Class %s declares two structField methods named %s", key.cls.getName(), callable.name()));
        }
        CacheValue value = new CacheValue();
        value.selfCall = selfCall;
        value.methods = methods.build();
        value.fields = ImmutableMap.copyOf(fields);
        return value;
    }

    static ImmutableMap<String, MethodDescriptor> getAnnotatedMethods(StarlarkSemantics semantics, Class<?> objClass) {
        return CallUtils.getCacheValue(objClass, (StarlarkSemantics)semantics).methods;
    }

    static Object getAnnotatedField(StarlarkSemantics semantics, Object x, String fieldName) throws EvalException, InterruptedException {
        MethodDescriptor desc = CallUtils.getCacheValue(x.getClass(), (StarlarkSemantics)semantics).fields.get(fieldName);
        if (desc == null) {
            throw Starlark.errorf("value of type %s has no .%s field", Starlark.type(x), fieldName);
        }
        return desc.callField(x, semantics, null);
    }

    static ImmutableSet<String> getAnnotatedFieldNames(StarlarkSemantics semantics, Object x) {
        return CallUtils.getCacheValue(x.getClass(), (StarlarkSemantics)semantics).fields.keySet();
    }

    @Nullable
    static MethodDescriptor getSelfCallMethodDescriptor(StarlarkSemantics semantics, Class<?> objClass) {
        return CallUtils.getCacheValue(objClass, (StarlarkSemantics)semantics).selfCall;
    }

    @Nullable
    static Method getSelfCallMethod(StarlarkSemantics semantics, Class<?> objClass) {
        MethodDescriptor descriptor = CallUtils.getCacheValue(objClass, (StarlarkSemantics)semantics).selfCall;
        if (descriptor == null) {
            return null;
        }
        return descriptor.getMethod();
    }

    private static class CacheValue {
        @Nullable
        MethodDescriptor selfCall;
        ImmutableMap<String, MethodDescriptor> methods;
        ImmutableMap<String, MethodDescriptor> fields;

        private CacheValue() {
        }
    }

    private static final class Key {
        final Class<?> cls;
        final StarlarkSemantics semantics;

        Key(Class<?> cls, StarlarkSemantics semantics) {
            this.cls = cls;
            this.semantics = semantics;
        }

        public boolean equals(Object that) {
            return this == that || that instanceof Key && this.cls.equals(((Key)that).cls) && this.semantics.equals(((Key)that).semantics);
        }

        public int hashCode() {
            return 31 * this.cls.hashCode() + this.semantics.hashCode();
        }
    }
}

