/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.annot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;

public final class StarlarkAnnotations {
    private static Class<?> moreSpecific(Class<?> x, Class<?> y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (x.isAssignableFrom(y)) {
            return y;
        }
        if (y.isAssignableFrom(x)) {
            return x;
        }
        throw new IllegalArgumentException(String.format("Expected one of %s and %s to be a subclass of the other", x, y));
    }

    @Nullable
    private static Class<?> findAnnotatedAncestor(Class<?> classObj, Class<? extends Annotation> annotation) {
        if (classObj.isAnnotationPresent(annotation)) {
            return classObj;
        }
        Class<?> bestCandidate = null;
        Class<?> superclass = classObj.getSuperclass();
        if (superclass != null) {
            Class<?> result = StarlarkAnnotations.findAnnotatedAncestor(superclass, annotation);
            bestCandidate = StarlarkAnnotations.moreSpecific(result, bestCandidate);
        }
        for (Class<?> interfaceObj : classObj.getInterfaces()) {
            Class<?> result = StarlarkAnnotations.findAnnotatedAncestor(interfaceObj, annotation);
            bestCandidate = StarlarkAnnotations.moreSpecific(result, bestCandidate);
        }
        return bestCandidate;
    }

    @Nullable
    public static StarlarkBuiltin getStarlarkBuiltin(Class<?> classObj) {
        Class<?> cls = StarlarkAnnotations.findAnnotatedAncestor(classObj, StarlarkBuiltin.class);
        return cls == null ? null : cls.getAnnotation(StarlarkBuiltin.class);
    }

    @Nullable
    public static Class<?> getParentWithStarlarkBuiltin(Class<?> classObj) {
        return StarlarkAnnotations.findAnnotatedAncestor(classObj, StarlarkBuiltin.class);
    }

    @Nullable
    public static StarlarkMethod getStarlarkMethod(Class<?> classObj, Method method) {
        StarlarkMethod annotation;
        StarlarkMethod callable = StarlarkAnnotations.getAnnotationOnClassMatchingSignature(classObj, method);
        if (callable != null) {
            return callable;
        }
        if (classObj.getSuperclass() != null && (annotation = StarlarkAnnotations.getStarlarkMethod(classObj.getSuperclass(), method)) != null) {
            return annotation;
        }
        for (Class<?> interfaceObj : classObj.getInterfaces()) {
            StarlarkMethod annotation2 = StarlarkAnnotations.getStarlarkMethod(interfaceObj, method);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    @Nullable
    public static StarlarkMethod getStarlarkMethod(Method method) {
        return StarlarkAnnotations.getStarlarkMethod(method.getDeclaringClass(), method);
    }

    @Nullable
    private static StarlarkMethod getAnnotationOnClassMatchingSignature(Class<?> classObj, Method signatureToMatch) {
        Method[] methods = classObj.getDeclaredMethods();
        Class<?>[] paramsToMatch = signatureToMatch.getParameterTypes();
        StarlarkMethod callable = null;
        for (Method method : methods) {
            if (!signatureToMatch.getName().equals(method.getName()) || !method.isAnnotationPresent(StarlarkMethod.class)) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == paramsToMatch.length) {
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (paramTypes[i].isAssignableFrom(paramsToMatch[i])) continue;
                    throw new IllegalStateException(String.format("Class %s has an incompatible overload of annotated method %s declared by %s", classObj, signatureToMatch.getName(), signatureToMatch.getDeclaringClass()));
                }
            }
            if (callable == null) {
                callable = method.getAnnotation(StarlarkMethod.class);
                continue;
            }
            throw new IllegalStateException(String.format("Class %s has multiple overloaded methods named '%s' annotated with @StarlarkMethod", classObj, signatureToMatch.getName()));
        }
        return callable;
    }

    private StarlarkAnnotations() {
    }
}

