/*
 * Decompiled with CFR 0.152.
 */
package com.ryanharter.auto.value.gson.internal;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.ryanharter.auto.value.gson.internal.WildcardUtil;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class Util {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private Util() {
    }

    public static Map<String, String> renameFields(Class<?> targetClass, List<String> names, FieldNamingStrategy fieldNamingStrategy) {
        LinkedHashMap<String, String> renamedFields = new LinkedHashMap<String, String>();
        block9: for (String fieldName : names) {
            if (fieldNamingStrategy instanceof FieldNamingPolicy) {
                switch ((FieldNamingPolicy)fieldNamingStrategy) {
                    case UPPER_CAMEL_CASE: {
                        renamedFields.put(fieldName, Util.upperCaseFirstLetter(fieldName));
                        continue block9;
                    }
                    case UPPER_CAMEL_CASE_WITH_SPACES: {
                        renamedFields.put(fieldName, Util.upperCaseFirstLetter(Util.separateCamelCase(fieldName, " ")));
                        continue block9;
                    }
                    case LOWER_CASE_WITH_UNDERSCORES: {
                        renamedFields.put(fieldName, Util.separateCamelCase(fieldName, "_").toLowerCase(Locale.ENGLISH));
                        continue block9;
                    }
                    case LOWER_CASE_WITH_DASHES: {
                        renamedFields.put(fieldName, Util.separateCamelCase(fieldName, "-").toLowerCase(Locale.ENGLISH));
                        continue block9;
                    }
                    case LOWER_CASE_WITH_DOTS: {
                        renamedFields.put(fieldName, Util.separateCamelCase(fieldName, ".").toLowerCase(Locale.ENGLISH));
                        continue block9;
                    }
                }
                renamedFields.put(fieldName, fieldName);
                continue;
            }
            try {
                renamedFields.put(fieldName, fieldNamingStrategy.translateName(targetClass.getDeclaredField(fieldName)));
            }
            catch (NoSuchFieldException E) {
                renamedFields.put(fieldName, fieldName);
            }
        }
        return renamedFields;
    }

    private static String separateCamelCase(String name, String separator) {
        StringBuilder translation = new StringBuilder();
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char character = name.charAt(i);
            if (Character.isUpperCase(character) && translation.length() != 0) {
                translation.append(separator);
            }
            translation.append(character);
        }
        return translation.toString();
    }

    private static String modifyString(char firstCharacter, String srcString, int indexOfSubstring) {
        return indexOfSubstring < srcString.length() ? firstCharacter + srcString.substring(indexOfSubstring) : String.valueOf(firstCharacter);
    }

    private static String upperCaseFirstLetter(String name) {
        StringBuilder fieldNameBuilder = new StringBuilder();
        int index = 0;
        char firstCharacter = name.charAt(index);
        int length = name.length();
        while (index < length - 1 && !Character.isLetter(firstCharacter)) {
            fieldNameBuilder.append(firstCharacter);
            firstCharacter = name.charAt(++index);
        }
        if (!Character.isUpperCase(firstCharacter)) {
            String modifiedTarget = Util.modifyString(Character.toUpperCase(firstCharacter), name, ++index);
            return fieldNameBuilder.append(modifiedTarget).toString();
        }
        return name;
    }

    private static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.isArray() ? new GenericArrayTypeImpl(Util.canonicalize(c.getComponentType())) : c;
        }
        if (type instanceof ParameterizedType) {
            if (type instanceof ParameterizedTypeImpl) {
                return type;
            }
            ParameterizedType p = (ParameterizedType)type;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            if (type instanceof GenericArrayTypeImpl) {
                return type;
            }
            GenericArrayType g2 = (GenericArrayType)type;
            return new GenericArrayTypeImpl(g2.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            if (type instanceof WildcardTypeImpl) {
                return type;
            }
            WildcardType w = (WildcardType)type;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type;
    }

    private static int hashCodeOrZero(@Nullable Object o) {
        return o != null ? o.hashCode() : 0;
    }

    private static String typeToString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    private static void checkNotPrimitive(Type type) {
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            throw new IllegalArgumentException("Unexpected primitive " + type + ". Use the boxed type.");
        }
    }

    public static final class WildcardTypeImpl
    implements WildcardType {
        private final Type upperBound;
        @Nullable
        private final Type lowerBound;

        WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            if (lowerBounds.length > 1) {
                throw new IllegalArgumentException();
            }
            if (upperBounds.length != 1) {
                throw new IllegalArgumentException();
            }
            if (lowerBounds.length == 1) {
                if (lowerBounds[0] == null) {
                    throw new NullPointerException();
                }
                Util.checkNotPrimitive(lowerBounds[0]);
                if (upperBounds[0] != Object.class) {
                    throw new IllegalArgumentException();
                }
                this.lowerBound = Util.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                if (upperBounds[0] == null) {
                    throw new NullPointerException();
                }
                Util.checkNotPrimitive(upperBounds[0]);
                this.lowerBound = null;
                this.upperBound = Util.canonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && WildcardUtil.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + Util.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + Util.typeToString(this.upperBound);
        }
    }

    public static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        GenericArrayTypeImpl(Type componentType) {
            this.componentType = Util.canonicalize(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && WildcardUtil.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return Util.typeToString(this.componentType) + "[]";
        }
    }

    public static final class ParameterizedTypeImpl
    implements ParameterizedType {
        @Nullable
        private final Type ownerType;
        private final Type rawType;
        final Type[] typeArguments;

        ParameterizedTypeImpl(@Nullable Type ownerType, Type rawType, Type ... typeArguments) {
            if (rawType instanceof Class) {
                Class<?> enclosingClass = ((Class)rawType).getEnclosingClass();
                if (ownerType != null) {
                    if (enclosingClass == null || WildcardUtil.getRawType(ownerType) != enclosingClass) {
                        throw new IllegalArgumentException("unexpected owner type for " + rawType + ": " + ownerType);
                    }
                } else if (enclosingClass != null) {
                    throw new IllegalArgumentException("unexpected owner type for " + rawType + ": null");
                }
            }
            this.ownerType = ownerType == null ? null : Util.canonicalize(ownerType);
            this.rawType = Util.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            for (int t2 = 0; t2 < this.typeArguments.length; ++t2) {
                if (this.typeArguments[t2] == null) {
                    throw new NullPointerException();
                }
                Util.checkNotPrimitive(this.typeArguments[t2]);
                this.typeArguments[t2] = Util.canonicalize(this.typeArguments[t2]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && WildcardUtil.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ Util.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            StringBuilder result = new StringBuilder(30 * (this.typeArguments.length + 1));
            result.append(Util.typeToString(this.rawType));
            if (this.typeArguments.length == 0) {
                return result.toString();
            }
            result.append("<").append(Util.typeToString(this.typeArguments[0]));
            for (int i = 1; i < this.typeArguments.length; ++i) {
                result.append(", ").append(Util.typeToString(this.typeArguments[i]));
            }
            return result.append(">").toString();
        }
    }
}

