/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.devtools.common.options.ParamsFilePreProcessor;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ShellQuotedParamsFilePreProcessor
extends ParamsFilePreProcessor {
    public ShellQuotedParamsFilePreProcessor(FileSystem fs) {
        super(fs);
    }

    @Override
    protected List<String> parse(Path paramsFile) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        try (ShellQuotedReader reader = new ShellQuotedReader(Files.newBufferedReader(paramsFile, StandardCharsets.UTF_8));){
            String arg;
            while ((arg = reader.readArg()) != null) {
                args.add(arg);
            }
        }
        return args;
    }

    private static class ShellQuotedReader
    implements AutoCloseable {
        private final PushbackReader reader;
        private int position = -1;

        public ShellQuotedReader(Reader reader) {
            this.reader = new PushbackReader(reader, 10);
        }

        private char read() throws IOException {
            int value = this.reader.read();
            ++this.position;
            return (char)value;
        }

        private void unread(char value) throws IOException {
            this.reader.unread(value);
            --this.position;
        }

        private boolean hasNext() throws IOException {
            char value = this.read();
            boolean hasNext = value != '\uffff';
            this.unread(value);
            return hasNext;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Nullable
        public String readArg() throws IOException {
            char current;
            if (!this.hasNext()) {
                return null;
            }
            StringBuilder arg = new StringBuilder();
            int quoteStart = -1;
            boolean quoted = false;
            while ((current = this.read()) != '\uffff') {
                if (quoted) {
                    if (current == '\'') {
                        StringBuilder escapedQuoteRemainder = new StringBuilder().append(this.read()).append(this.read()).append(this.read());
                        if (escapedQuoteRemainder.toString().equals("\\''")) {
                            arg.append("'");
                            continue;
                        }
                        for (char c : escapedQuoteRemainder.reverse().toString().toCharArray()) {
                            this.unread(c);
                        }
                        quoted = false;
                        quoteStart = -1;
                        continue;
                    }
                    arg.append(current);
                    continue;
                }
                if (current == '\'') {
                    quoted = true;
                    quoteStart = this.position;
                    continue;
                }
                if (current == '\r') {
                    char next = this.read();
                    if (next == '\n') {
                        return arg.toString();
                    }
                    this.unread(next);
                    return arg.toString();
                }
                if (Character.isWhitespace(current)) {
                    return arg.toString();
                }
                arg.append(current);
            }
            if (quoted) {
                throw new IOException(String.format("Unfinished quote %s at %s", "'", quoteStart));
            }
            return arg.toString();
        }
    }
}

