/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionDocumentationCategory;
import com.google.devtools.common.options.OptionInstanceOrigin;
import com.google.devtools.common.options.OptionMetadataTag;
import com.google.devtools.common.options.OptionPriority;
import com.google.devtools.common.options.OptionsParsingException;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ParsedOptionDescription {
    private final OptionDefinition optionDefinition;
    @Nullable
    private final String commandLineForm;
    @Nullable
    private final String unconvertedValue;
    private final OptionInstanceOrigin origin;
    @Nullable
    private final Object conversionContext;

    private ParsedOptionDescription(OptionDefinition optionDefinition, @Nullable String commandLineForm, @Nullable String unconvertedValue, OptionInstanceOrigin origin, @Nullable Object conversionContext) {
        this.optionDefinition = Preconditions.checkNotNull(optionDefinition);
        this.commandLineForm = commandLineForm;
        this.unconvertedValue = unconvertedValue;
        this.origin = Preconditions.checkNotNull(origin);
        this.conversionContext = conversionContext;
    }

    static ParsedOptionDescription newParsedOptionDescription(OptionDefinition optionDefinition, String commandLineForm, @Nullable String unconvertedValue, OptionInstanceOrigin origin, @Nullable Object conversionContext) {
        return new ParsedOptionDescription(optionDefinition, Preconditions.checkNotNull(commandLineForm), unconvertedValue, origin, conversionContext);
    }

    static ParsedOptionDescription newDummyInstance(OptionDefinition optionDefinition, OptionInstanceOrigin origin, @Nullable Object conversionContext) {
        return new ParsedOptionDescription(optionDefinition, null, null, origin, conversionContext);
    }

    public OptionDefinition getOptionDefinition() {
        return this.optionDefinition;
    }

    @Nullable
    public String getCommandLineForm() {
        return this.commandLineForm;
    }

    public String getCanonicalForm() {
        return this.getCanonicalFormWithValueEscaper(s2 -> s2);
    }

    public String getCanonicalFormWithValueEscaper(Function<String, String> escapingFunction) {
        if (this.optionDefinition.getType().equals(Boolean.TYPE)) {
            try {
                return ((Boolean)this.getConvertedValue() != false ? "--" : "--no") + this.optionDefinition.getOptionName();
            }
            catch (OptionsParsingException e) {
                throw new RuntimeException("Unexpected parsing exception", e);
            }
        }
        String optionString = "--" + this.optionDefinition.getOptionName();
        if (this.unconvertedValue != null) {
            optionString = optionString + "=" + escapingFunction.apply(this.unconvertedValue);
        }
        return optionString;
    }

    @Deprecated
    String getDeprecatedCanonicalForm() {
        String value = this.unconvertedValue;
        if (this.optionDefinition.getType().equals(Boolean.TYPE)) {
            try {
                value = (Boolean)this.getConvertedValue() != false ? "1" : "0";
            }
            catch (OptionsParsingException e) {
                throw new RuntimeException("Unexpected parsing exception", e);
            }
        }
        return String.format("--%s=%s", this.optionDefinition.getOptionName(), value);
    }

    public boolean isBooleanOption() {
        return this.optionDefinition.getType().equals(Boolean.TYPE);
    }

    private OptionDocumentationCategory documentationCategory() {
        return this.optionDefinition.getDocumentationCategory();
    }

    private ImmutableList<OptionMetadataTag> metadataTags() {
        return ImmutableList.copyOf(this.optionDefinition.getOptionMetadataTags());
    }

    public boolean isDocumented() {
        return this.documentationCategory() != OptionDocumentationCategory.UNDOCUMENTED && !this.isHidden();
    }

    public boolean isHidden() {
        ImmutableList<OptionMetadataTag> tags = this.metadataTags();
        return tags.contains((Object)OptionMetadataTag.HIDDEN) || tags.contains((Object)OptionMetadataTag.INTERNAL);
    }

    @Nullable
    public String getUnconvertedValue() {
        return this.unconvertedValue;
    }

    public OptionInstanceOrigin getOrigin() {
        return this.origin;
    }

    public OptionPriority getPriority() {
        return this.origin.getPriority();
    }

    @Nullable
    public String getSource() {
        return this.origin.getSource();
    }

    @Nullable
    ParsedOptionDescription getImplicitDependent() {
        return this.origin.getImplicitDependent();
    }

    @Nullable
    ParsedOptionDescription getExpandedFrom() {
        return this.origin.getExpandedFrom();
    }

    public boolean isExplicit() {
        return this.origin.getExpandedFrom() == null && this.origin.getImplicitDependent() == null;
    }

    public Object getConvertedValue() throws OptionsParsingException {
        Converter<?> converter = this.optionDefinition.getConverter();
        try {
            return converter.convert(this.unconvertedValue, this.conversionContext);
        }
        catch (OptionsParsingException e) {
            throw new OptionsParsingException(String.format("While parsing option %s: %s", this.commandLineForm, e.getMessage()), e);
        }
    }

    public String toString() {
        if (this.commandLineForm == null) {
            return this.optionDefinition.toString();
        }
        String source = this.origin.getSource();
        return String.format("option '%s'%s", this.commandLineForm, source == null ? "" : String.format(" (source %s)", source));
    }
}

