/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.escape.Escaper;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionEffectTag;
import com.google.devtools.common.options.OptionMetadataTag;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsData;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.TriState;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class OptionsUsage {
    private static final Splitter NEWLINE_SPLITTER = Splitter.on('\n');
    private static final Joiner COMMA_JOINER = Joiner.on(",");

    OptionsUsage() {
    }

    static void getUsage(Class<? extends OptionsBase> optionsClass, StringBuilder usage) {
        OptionsData data = OptionsParser.getOptionsDataInternal(optionsClass);
        ArrayList<OptionDefinition> optionDefinitions = new ArrayList<OptionDefinition>(OptionsData.getAllOptionDefinitionsForClass(optionsClass));
        optionDefinitions.sort(OptionDefinition.BY_OPTION_NAME);
        for (OptionDefinition optionDefinition : optionDefinitions) {
            OptionsUsage.getUsage(optionDefinition, usage, OptionsParser.HelpVerbosity.LONG, data, false);
        }
    }

    static void getUsage(OptionDefinition optionDefinition, StringBuilder usage, OptionsParser.HelpVerbosity helpVerbosity, OptionsData optionsData, boolean includeTags) {
        Stream<OptionMetadataTag> metadataTagStream;
        ImmutableList<String> expansion;
        String flagName = OptionsUsage.getFlagName(optionDefinition);
        String typeDescription = OptionsUsage.getTypeDescription(optionDefinition);
        usage.append("  --").append(flagName);
        if (helpVerbosity == OptionsParser.HelpVerbosity.SHORT) {
            usage.append('\n');
            return;
        }
        if (optionDefinition.getAbbreviation() != '\u0000') {
            usage.append(" [-").append(optionDefinition.getAbbreviation()).append(']');
        }
        if (!typeDescription.isEmpty()) {
            usage.append(" (").append(typeDescription).append("; ");
            if (optionDefinition.allowsMultiple()) {
                usage.append("may be used multiple times");
            } else {
                String defaultValueString = optionDefinition.getUnparsedDefaultValue();
                if (optionDefinition.isSpecialNullDefault()) {
                    usage.append("default: see description");
                } else {
                    usage.append("default: \"").append(defaultValueString).append("\"");
                }
            }
            usage.append(")");
        }
        usage.append("\n");
        if (helpVerbosity == OptionsParser.HelpVerbosity.MEDIUM) {
            return;
        }
        if (!optionDefinition.getHelpText().isEmpty()) {
            usage.append(OptionsUsage.paragraphFill(optionDefinition.getHelpText(), 4, 80));
            usage.append('\n');
        }
        if ((expansion = OptionsUsage.getExpansionIfKnown(optionDefinition, optionsData)) == null) {
            usage.append(OptionsUsage.paragraphFill("Expands to unknown options.", 6, 80));
            usage.append('\n');
        } else if (!expansion.isEmpty()) {
            StringBuilder expandsMsg = new StringBuilder("Expands to: ");
            for (String exp : expansion) {
                expandsMsg.append(exp).append(" ");
            }
            usage.append(OptionsUsage.paragraphFill(expandsMsg.toString(), 6, 80));
            usage.append('\n');
        }
        if (optionDefinition.hasImplicitRequirements()) {
            StringBuilder requiredMsg = new StringBuilder("Using this option will also add: ");
            for (String req : optionDefinition.getImplicitRequirements()) {
                requiredMsg.append(req).append(" ");
            }
            usage.append(OptionsUsage.paragraphFill(requiredMsg.toString(), 6, 80));
            usage.append('\n');
        }
        if (!includeTags) {
            return;
        }
        Stream<OptionEffectTag> effectTagStream = Arrays.stream(optionDefinition.getOptionEffectTags()).filter(OptionsUsage::shouldEffectTagBeListed);
        String tagList = Stream.concat(effectTagStream, metadataTagStream = Arrays.stream(optionDefinition.getOptionMetadataTags()).filter(OptionsUsage::shouldMetadataTagBeListed)).map(tag -> Ascii.toLowerCase(tag.toString())).collect(Collectors.joining(", "));
        if (!tagList.isEmpty()) {
            usage.append(OptionsUsage.paragraphFill("Tags: " + tagList, 6, 80));
            usage.append("\n");
        }
    }

    static String paragraphFill(String in, int indent, int width) {
        String indentString = " ".repeat(indent);
        StringBuilder out = new StringBuilder();
        String sep = "";
        for (String paragraph : NEWLINE_SPLITTER.split(in)) {
            BreakIterator boundary = BreakIterator.getLineInstance();
            boundary.setText(paragraph);
            out.append(sep).append(indentString);
            int cursor = indent;
            int start = boundary.first();
            int end = boundary.next();
            while (end != -1) {
                String word = paragraph.substring(start, end);
                if (word.length() + cursor > width) {
                    out.append('\n').append(indentString);
                    cursor = indent;
                }
                out.append(word);
                cursor += word.length();
                start = end;
                end = boundary.next();
            }
            sep = "\n";
        }
        return out.toString();
    }

    @Nullable
    private static ImmutableList<String> getExpansionIfKnown(OptionDefinition optionDefinition, OptionsData optionsData) {
        Preconditions.checkNotNull(optionDefinition);
        return optionsData.getEvaluatedExpansion(optionDefinition);
    }

    private static boolean shouldEffectTagBeListed(OptionEffectTag effectTag) {
        return !effectTag.equals((Object)OptionEffectTag.UNKNOWN);
    }

    private static boolean shouldMetadataTagBeListed(OptionMetadataTag metadataTag) {
        return !metadataTag.equals((Object)OptionMetadataTag.HIDDEN) && !metadataTag.equals((Object)OptionMetadataTag.INTERNAL);
    }

    static void getUsageHtml(OptionDefinition optionDefinition, StringBuilder usage, Escaper escaper, OptionsData optionsData, boolean includeTags) {
        String plainFlagName = optionDefinition.getOptionName();
        String flagName = OptionsUsage.getFlagName(optionDefinition);
        String valueDescription = optionDefinition.getValueTypeHelpText();
        String typeDescription = OptionsUsage.getTypeDescription(optionDefinition);
        usage.append("<dt id=\"flag--").append(plainFlagName).append("\">").append("<code><a href=\"#flag--").append(plainFlagName).append("\">").append("--").append(flagName).append("</a>");
        if (!optionDefinition.usesBooleanValueSyntax() && !optionDefinition.isVoidField()) {
            if (!valueDescription.isEmpty()) {
                usage.append("=").append(escaper.escape(valueDescription));
            } else if (!typeDescription.isEmpty()) {
                usage.append("=&lt;").append(escaper.escape(typeDescription)).append("&gt");
            }
        }
        usage.append("</code>");
        if (optionDefinition.getAbbreviation() != '\u0000') {
            usage.append(" [<code>-").append(optionDefinition.getAbbreviation()).append("</code>]");
        }
        if (optionDefinition.allowsMultiple()) {
            usage.append(" multiple uses are accumulated");
        } else {
            String defaultValueString = optionDefinition.getUnparsedDefaultValue();
            if (!optionDefinition.isVoidField()) {
                if (optionDefinition.isSpecialNullDefault()) {
                    usage.append(" default: see description");
                } else {
                    usage.append(" default: \"").append(escaper.escape(defaultValueString)).append("\"");
                }
            }
        }
        usage.append("</dt>\n");
        usage.append("<dd>\n");
        if (!optionDefinition.getHelpText().isEmpty()) {
            usage.append(escaper.escape(optionDefinition.getHelpText()));
            usage.append('\n');
        }
        if (!optionsData.getEvaluatedExpansion(optionDefinition).isEmpty()) {
            StringBuilder expandsMsg;
            usage.append("<br/>\n");
            ImmutableList<String> expansion = OptionsUsage.getExpansionIfKnown(optionDefinition, optionsData);
            if (expansion == null) {
                expandsMsg = new StringBuilder("Expands to unknown options.<br/>\n");
            } else {
                Preconditions.checkArgument(!expansion.isEmpty());
                expandsMsg = new StringBuilder("Expands to:<br/>\n");
                for (String exp : expansion) {
                    expandsMsg.append("&nbsp;&nbsp;").append("<code><a href=\"#flag").append(Iterables.get(Splitter.on('=').split(escaper.escape(exp)), 0)).append("\">").append(escaper.escape(exp)).append("</a></code><br/>\n");
                }
            }
            usage.append((CharSequence)expandsMsg);
        }
        if (includeTags) {
            Stream<OptionEffectTag> effectTagStream = Arrays.stream(optionDefinition.getOptionEffectTags()).filter(OptionsUsage::shouldEffectTagBeListed);
            Stream<OptionMetadataTag> metadataTagStream = Arrays.stream(optionDefinition.getOptionMetadataTags()).filter(OptionsUsage::shouldMetadataTagBeListed);
            String tagList = Stream.concat(effectTagStream.map(tag -> String.format("<a href=\"#effect_tag_%s\"><code>%s</code></a>", tag, Ascii.toLowerCase(tag.name()))), metadataTagStream.map(tag -> String.format("<a href=\"#metadata_tag_%s\"><code>%s</code></a>", tag, Ascii.toLowerCase(tag.name())))).collect(Collectors.joining(", "));
            if (!tagList.isEmpty()) {
                usage.append("<br>Tags:\n").append(tagList);
            }
        }
        usage.append("</dd>\n");
    }

    static void getCompletion(OptionDefinition optionDefinition, StringBuilder builder) {
        String flagName = optionDefinition.getOptionName();
        Class<?> fieldType = optionDefinition.getType();
        builder.append("--").append(flagName);
        if (fieldType.equals(Boolean.TYPE)) {
            builder.append("\n");
            builder.append("--no").append(flagName).append("\n");
        } else if (fieldType.equals(TriState.class)) {
            builder.append("={auto,yes,no}\n");
            builder.append("--no").append(flagName).append("\n");
        } else if (fieldType.isEnum()) {
            builder.append("={").append(COMMA_JOINER.join(fieldType.getEnumConstants()).toLowerCase(Locale.ENGLISH)).append("}\n");
        } else if (fieldType.getSimpleName().equals("Label")) {
            builder.append("=label\n");
        } else if (fieldType.getSimpleName().equals("PathFragment")) {
            builder.append("=path\n");
        } else if (Void.class.isAssignableFrom(fieldType)) {
            builder.append("\n");
        } else {
            builder.append("=\n");
        }
    }

    private static String getTypeDescription(OptionDefinition optionsDefinition) {
        return optionsDefinition.getConverter().getTypeDescription();
    }

    static String getFlagName(OptionDefinition optionDefinition) {
        String name = optionDefinition.getOptionName();
        return optionDefinition.usesBooleanValueSyntax() ? "[no]" + name : name;
    }
}

